/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class StatelessCreateOnlyOne
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionTypeString();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                    Method[] methods = c10.getDeclaredMethods();
                    int foundThisManyTimes = 0;
                    Method m2 = null;
                    int i2 = 0;
                    while (i2 < methods.length) {
                        if (methods[i2].getName().equals("create")) {
                            if (foundThisManyTimes == 0) {
                                m2 = methods[i2];
                                ++foundThisManyTimes;
                            } else {
                                ++foundThisManyTimes;
                            }
                        }
                        ++i2;
                    }
                    if (m2 != null && foundThisManyTimes == 1) {
                        result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: This bean [ {0} ] has defined only one create method.\n Stateless session beans can only have one create method.", new Object[]{descriptor.getHomeClassName()}));
                    } else if (m2 != null && foundThisManyTimes > 1) {
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] Create methods exists within bean [ {1} ].  The home interface must have only one create method for stateless session bean.", new Object[]{new Integer(foundThisManyTimes), descriptor.getHomeClassName()}));
                    } else {
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed1", "Error: No create method exist within bean [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                }
                return result;
            }
            if (EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "{0} expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), EjbSessionDescriptor.STATELESS, stateType}));
                return result;
            }
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

