/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class TransportGuarantee
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int na = 0;
            int noSc = 0;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)securityConstraintImpl.getUserDataConstraint();
                if (userDataConstraint != null) {
                    String transportGuarantee = userDataConstraint.getTransportGuarantee();
                    foundIt = transportGuarantee.length() > 0 ? transportGuarantee.equals("NONE") || transportGuarantee.equals("INTEGRAL") || transportGuarantee.equals("CONFIDENTIAL") : false;
                    if (foundIt) {
                        result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "transport-guarantee [ {0} ] specifies that the communication between client and server should be one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]", new Object[]{transportGuarantee, descriptor.getName()}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: transport-guarantee [ {0} ] does not specify that the communication between client and server is one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]", new Object[]{transportGuarantee, descriptor.getName()}));
                    continue;
                }
                result.addNaDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "There are no transport-guarantee elements within the web application [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no transport-guarantee elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

