/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class EJBClassLoader
extends ClassLoader {
    private HashMap classCache;
    private Set urlSet = new HashSet();
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$EJBClassLoader != null ? class$com$sun$enterprise$util$EJBClassLoader : (class$com$sun$enterprise$util$EJBClassLoader = EJBClassLoader.class$("com.sun.enterprise.util.EJBClassLoader")));
    static /* synthetic */ Class class$com$sun$enterprise$util$EJBClassLoader;

    protected EJBClassLoader() {
        this.classCache = new HashMap(1024);
    }

    public synchronized void addURL(URL url) throws IOException {
        this.urlSet.add(url);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void finalize() {
        this.print("ClassLoader: " + this + " is getting garbage collected");
    }

    /*
     * Loose catch block
     */
    protected URL findResource(String name) {
        this.print("findResource : " + name);
        URL resource = null;
        Iterator itr = this.urlSet.iterator();
        while (itr.hasNext()) {
            URL classpathURL = (URL)itr.next();
            File thisFile = new File(classpathURL.getFile());
            if (thisFile.isFile()) {
                Object var8_9;
                ZipFile jarFile;
                block14: {
                    jarFile = null;
                    URL resourceURL = new URL("jar:" + classpathURL + "!/" + name);
                    jarFile = new JarFile(thisFile);
                    JarEntry jarEntry = ((JarFile)jarFile).getJarEntry(name);
                    if (jarEntry == null) break block14;
                    this.print("Found resource : " + resourceURL);
                    resource = resourceURL;
                    var8_9 = null;
                    if (jarFile == null) break;
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        this.print("Error closing jarFile " + jarFile);
                    }
                    break;
                    {
                        catch (IOException iOException) {
                            this.print("Couldn't find " + name + " in " + classpathURL);
                        }
                    }
                }
                var8_9 = null;
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    this.print("Error closing jarFile " + jarFile);
                }
                continue;
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {
                            this.print("Error closing jarFile " + jarFile);
                        }
                    }
                    throw throwable;
                }
            }
            File resourceFile = new File(String.valueOf(thisFile.toString()) + File.separator + name);
            if (resourceFile.exists()) {
                try {
                    resource = resourceFile.toURL();
                    break;
                }
                catch (IOException e10) {
                    this.print(e10.toString());
                    continue;
                }
            }
            this.print("Couldn't find " + resourceFile);
        }
        return resource;
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public URL[] getURLs() {
        return this.urlSet.toArray(new URL[0]);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c10 = null;
        try {
            try {
                c10 = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                c10 = null;
            }
            Object var5_4 = null;
            if (c10 != null) {
                return c10;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (c10 != null) {
                return c10;
            }
            throw throwable;
        }
        this.print("Loading class " + name + " using the classLoader " + this);
        c10 = (Class<?>)this.classCache.get(name);
        if (c10 == null) {
            byte[] data = this.loadClassData(name);
            if (data != null) {
                this.print("Read the class data ");
                c10 = this.defineClass(null, data, 0, data.length);
                if (!name.equals(c10.getName())) {
                    throw new ClassNotFoundException(localStrings.getLocalString("classloader.wrongpackage", "", new Object[]{name, c10.getName()}));
                }
                this.classCache.put(name, c10);
                if (resolve) {
                    this.resolveClass(c10);
                }
            } else {
                this.print("Looking for the class in the system class loader.");
                c10 = this.findSystemClass(name);
            }
        } else {
            this.print("Found the class " + c10 + " in the cache");
        }
        if (c10 == null) {
            this.print("JarClassLoader: could not find " + name + " in  " + this.urlSet);
        }
        return c10;
    }

    private byte[] loadClassData(String name) {
        this.print("JCL: load " + name);
        InputStream classStream = null;
        String entryName = String.valueOf(name.replace('.', '/')) + ".class";
        Iterator itr = this.urlSet.iterator();
        while (itr.hasNext()) {
            URL thisURL = (URL)itr.next();
            File thisFile = new File(thisURL.getFile());
            try {
                if (!thisFile.exists()) {
                    throw new FileNotFoundException(thisFile.toString());
                }
                if (thisFile.isFile()) {
                    this.print("JCL: opening " + thisFile);
                    ZipFile zip = new ZipFile(thisFile);
                    ZipEntry entry = zip.getEntry(entryName);
                    if (entry != null) {
                        this.print("JCL: yes !");
                        classStream = zip.getInputStream(entry);
                        byte[] classData = this.getClassData(classStream);
                        zip.close();
                        return classData;
                    }
                    this.print("JCL: no - closing");
                    zip.close();
                    continue;
                }
                File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                if (!classFile.exists()) continue;
                classStream = new FileInputStream(classFile);
                byte[] classData = this.getClassData(classStream);
                ((InputStream)classStream).close();
                return classData;
            }
            catch (IOException ioe) {
                this.print("JCL: Class Could not be loaded");
            }
        }
        return null;
    }

    private void print(Object o2) {
    }

    public String toString() {
        return "JCL: \n " + this.urlSet + " \n " + this.classCache;
    }
}

