/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.BeanMethodCalculator;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.NiceProperties;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropsToXmlConverter {
    private Hashtable ejbReferencesToConvert = new Hashtable();

    private void convertEjbReference(EjbBundleDescriptor ejbBundleDescriptor, Properties p2, String environmentPropertyPrefix, EjbDescriptor ejbDescriptor) {
        System.out.println("");
        String ejbRefPrefix = String.valueOf(environmentPropertyPrefix) + "ejbReference.";
        String envPropertyKey = p2.getProperty(String.valueOf(environmentPropertyPrefix) + "name");
        String jndiName = p2.getProperty(String.valueOf(environmentPropertyPrefix) + "value");
        boolean isEjbLinked = false;
        if ("true".equals(p2.getProperty(String.valueOf(ejbRefPrefix) + "isEjbLink"))) {
            isEjbLinked = true;
        }
        String ejbReferenceType = p2.getProperty(String.valueOf(ejbRefPrefix) + "type");
        String homeClassName = p2.getProperty(String.valueOf(ejbRefPrefix) + "homeInterface");
        String remoteClassName = p2.getProperty(String.valueOf(ejbRefPrefix) + "remoteInterface");
        if (isEjbLinked) {
            String ejbLinkName = p2.getProperty(String.valueOf(ejbRefPrefix) + "ejbLink");
            EjbDescriptor beanBeingReferredTo = null;
            if (ejbBundleDescriptor.hasEjbByName(ejbLinkName)) {
                beanBeingReferredTo = ejbBundleDescriptor.getEjbByName(ejbLinkName);
            }
            if (beanBeingReferredTo == null) {
                EjbExternalDescriptor external = new EjbExternalDescriptor("name ??", homeClassName, remoteClassName, ejbReferenceType);
                external.setLinkName(ejbLinkName);
                EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", external);
                System.out.println("Adding internal UNRESOLVED reference " + ejbReference);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
            } else {
                EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", beanBeingReferredTo);
                System.out.println("Adding internal RESOLVED reference " + ejbReference);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
            }
        } else {
            EjbExternalDescriptor external = new EjbExternalDescriptor("name ??", homeClassName, remoteClassName, ejbReferenceType);
            external.setJndiName(jndiName);
            EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", external);
            System.out.println("Adding external reference " + ejbReference);
            ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
        }
    }

    private void convertEnvironmentProperties(String prefix, Properties p2, EjbDescriptor ejbDescriptor) throws IOException {
        int envCount = Integer.parseInt(p2.getProperty(String.valueOf(prefix) + "#envProps"));
        HashSet environmentProperties = new HashSet();
        int j2 = 0;
        while (j2 < envCount) {
            String envPrefix = String.valueOf(prefix) + "envProps" + j2 + ".";
            String propName = p2.getProperty(String.valueOf(envPrefix) + "name");
            String propType = p2.getProperty(String.valueOf(envPrefix) + "type");
            String envValue = p2.getProperty(String.valueOf(envPrefix) + "value");
            if (propName == null) {
                throw new IOException("Bad envProps count or envProps key");
            }
            EnvironmentProperty environmentProperty = new EnvironmentProperty(propName, envValue, "");
            if (propType != null) {
                environmentProperty.setType(propType);
            }
            String isRoleRefKey = String.valueOf(envPrefix) + "isRoleRef";
            String isEjbRefKey = String.valueOf(envPrefix) + "isEjbReference";
            if (p2.getProperty(isRoleRefKey) != null) {
                System.out.println(String.valueOf(propName) + " is a role ref ");
                RoleReference rr = new RoleReference(propName, "");
                rr.setValue(envValue);
                ejbDescriptor.addRoleReference(rr);
            } else if (p2.getProperty(isEjbRefKey) != null) {
                String ejbReferenceKeyPrefix = String.valueOf(envPrefix) + "ejbReference.";
                this.ejbReferencesToConvert.put(envPrefix, ejbDescriptor);
            } else {
                ejbDescriptor.addEnvironmentProperty(environmentProperty);
            }
            ++j2;
        }
    }

    private MethodDescriptor convertMethodDescriptor(String mPrefix, Properties p2, ClassLoader fcl, EjbDescriptor ejbDescriptor) throws Exception {
        String methodName;
        String className = p2.getProperty(String.valueOf(mPrefix) + "classname");
        if (className == null) {
            throw new IOException("Bad mdesc count or mdesc key");
        }
        int parameterCount = 0;
        if (p2.getProperty(String.valueOf(mPrefix) + "#parameters") != null) {
            parameterCount = Integer.parseInt(p2.getProperty(String.valueOf(mPrefix) + "#parameters"));
        }
        if ((methodName = p2.getProperty(String.valueOf(mPrefix) + "methodname")) == null) {
            throw new RuntimeException("no value for " + mPrefix + "methodname is causing a method descriptor parse error");
        }
        Method[] methods = fcl.loadClass(className).getMethods();
        Method method = null;
        int k2 = 0;
        while (k2 < methods.length) {
            if (methods[k2].getName().equals(methodName)) {
                if (parameterCount > 0) {
                    String[] parameters = new String[parameterCount];
                    int i2 = 0;
                    while (i2 < parameterCount) {
                        String parameterType;
                        parameters[i2] = parameterType = p2.getProperty(String.valueOf(mPrefix) + "parameter" + i2);
                        ++i2;
                    }
                    MethodDescriptor compareMd = new MethodDescriptor(methods[k2], ejbDescriptor, fcl);
                    if (compareMd.equals(new MethodDescriptor(methodName, "", parameters, MethodDescriptor.EJB_BEAN)) || compareMd.equals(new MethodDescriptor(methodName, "", parameters, MethodDescriptor.EJB_REMOTE)) || compareMd.equals(new MethodDescriptor(methodName, "", parameters, MethodDescriptor.EJB_HOME))) {
                        method = methods[k2];
                        break;
                    }
                } else {
                    method = methods[k2];
                    break;
                }
            }
            ++k2;
        }
        if (method == null) {
            throw new RuntimeException("Couldn't locate method for " + methodName);
        }
        MethodDescriptor md = new MethodDescriptor(method, ejbDescriptor, fcl);
        return md;
    }

    private void convertMethodPermissions(String prefix, Properties p2, EjbDescriptor ejbDescriptor, ClassLoader fcl) throws Exception {
        String methodPermissionsCountKey = String.valueOf(prefix) + "#methodPermissions";
        if (p2.getProperty(methodPermissionsCountKey) != null) {
            System.out.println("There are method permissions set");
            int mPermissionsCount = Integer.parseInt(p2.getProperty(methodPermissionsCountKey));
            int j2 = 0;
            while (j2 < mPermissionsCount) {
                String methodKey = String.valueOf(prefix) + "mdesc" + j2 + ".";
                MethodDescriptor md = this.convertMethodDescriptor(methodKey, p2, fcl, ejbDescriptor);
                Enumeration e10 = PropsToXmlConverter.parseRolesFrom(p2.getProperty(String.valueOf(methodKey) + "permissionedRoles"));
                while (e10.hasMoreElements()) {
                    Role r2 = (Role)e10.nextElement();
                    System.out.println(String.valueOf(String.valueOf(r2)) + " can call " + md);
                    ejbDescriptor.addPermissionedRoleFor(r2, md);
                }
                ++j2;
            }
        }
    }

    private void convertResourceReferences(String prefix, Properties p2, EjbDescriptor ejbDescriptor) throws IOException {
        String resourceReferencesKey = p2.getProperty(String.valueOf(prefix) + "#resourceReferences");
        if (resourceReferencesKey != null) {
            int resCount = Integer.parseInt(p2.getProperty(String.valueOf(prefix) + "#resourceReferences"));
            int j2 = 0;
            while (j2 < resCount) {
                String mainResourceKey = String.valueOf(prefix) + "resourceReference" + j2;
                String resourceName = p2.getProperty(String.valueOf(mainResourceKey) + ".name");
                String jndiName = p2.getProperty(String.valueOf(mainResourceKey) + ".jndiName");
                String resourceType = p2.getProperty(String.valueOf(mainResourceKey) + ".type");
                EnvironmentProperty ep2 = new EnvironmentProperty(resourceName, jndiName, "description");
                ResourceReferenceDescriptor rr = new ResourceReferenceDescriptor(resourceName, "description", resourceType);
                rr.setJndiName(jndiName);
                ejbDescriptor.addResourceReferenceDescriptor(rr);
                String defaultDBAccountString = p2.getProperty(String.valueOf(mainResourceKey) + ".defaultDBAccount");
                rr.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(defaultDBAccountString));
                String mailConfigurationString = p2.getProperty(String.valueOf(mainResourceKey) + ".mailConfiguration");
                System.out.println("--- " + mailConfigurationString);
                rr.setMailConfiguration(PropsToXmlConverter.parseMailConfigurationFromString(mailConfigurationString));
                ++j2;
            }
        }
    }

    public void convertToXml(File propsFile, String codebase, String xmlFilename, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws Throwable {
        EjbDescriptor ejbDescriptor;
        System.out.println("Convert : " + propsFile + " to XML");
        FileInputStream fis = new FileInputStream(propsFile);
        NiceProperties p2 = new NiceProperties();
        p2.load(fis);
        FileClassLoader fcl = new FileClassLoader(codebase);
        String applicationName = ((Properties)p2).getProperty("application.name");
        Application application = new Application(applicationName, new File(String.valueOf(applicationName) + ".jar"));
        application.getApplicationArchivist().setClassLoader(fcl);
        EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
        application.addEjbBundleDescriptor(ejbBundleDescriptor);
        String ejbClientJarUri = ((Properties)p2).getProperty("ejbclientjaruri");
        if (ejbClientJarUri != null) {
            ejbBundleDescriptor.setEjbClientJarUri(ejbClientJarUri);
        }
        if (((Properties)p2).getProperty("rolecount") != null) {
            System.out.println("This ejb jar has assembly descriptor roles");
            RoleMapper rm = application.getRoleMapper();
            int roleCount = Integer.parseInt(((Properties)p2).getProperty("rolecount"));
            int j2 = 0;
            while (j2 < roleCount) {
                String lookupKey = "role" + j2 + ".name";
                Role nextRole = new Role(((Properties)p2).getProperty(lookupKey));
                System.out.println("-adding role: " + nextRole);
                String usersLookupKey = "role" + j2 + ".users";
                String groupsLookupKey = "role" + j2 + ".groups";
                if (((Properties)p2).getProperty(usersLookupKey) != null) {
                    PropsToXmlConverter.makeUserRoleMapping(rm, nextRole, ((Properties)p2).getProperty(usersLookupKey));
                }
                if (((Properties)p2).getProperty(groupsLookupKey) != null) {
                    PropsToXmlConverter.makeGroupRoleMapping(rm, nextRole, ((Properties)p2).getProperty(groupsLookupKey));
                }
                ejbBundleDescriptor.addRole(nextRole);
                ++j2;
            }
        }
        int ejbcount = Integer.parseInt(((Properties)p2).getProperty("ejbcount"));
        int i2 = 0;
        while (i2 < ejbcount) {
            String prefix = "ejb" + i2 + ".";
            String type = ((Properties)p2).getProperty(String.valueOf(prefix) + "type");
            ejbDescriptor = type.equals("session") ? new EjbSessionDescriptor() : new EjbEntityDescriptor();
            String logicalName = ((Properties)p2).getProperty(String.valueOf(prefix) + "logicalName");
            if (logicalName != null) {
                ejbDescriptor.setName(logicalName);
            }
            String ejbClassName = ((Properties)p2).getProperty(String.valueOf(prefix) + "name");
            ejbDescriptor.setEjbClassName(ejbClassName);
            Class<?> ejbClass = fcl.loadClass(ejbClassName);
            ejbDescriptor.setJndiName(((Properties)p2).getProperty(String.valueOf(prefix) + "JNDIName"));
            ejbDescriptor.setHomeClassName(((Properties)p2).getProperty(String.valueOf(prefix) + "homeInterface"));
            ejbDescriptor.setRemoteClassName(((Properties)p2).getProperty(String.valueOf(prefix) + "remoteInterface"));
            this.convertEnvironmentProperties(prefix, p2, ejbDescriptor);
            int mCount = Integer.parseInt(((Properties)p2).getProperty(String.valueOf(prefix) + "#methodDescriptors"));
            String ejb1TransactionAttribute = ((Properties)p2).getProperty(String.valueOf(prefix) + "transactionAttribute");
            if (ejb1TransactionAttribute.equals("TX_BEAN_MANAGED")) {
                System.out.println("You have chosen to make this bean manage its own transactions. This is illegal for entity beans, and the (session) bean cannot specifiy any method level container transactions.");
                ejbDescriptor.setTransactionType(EjbDescriptor.BEAN_TRANSACTION_TYPE);
            } else {
                ejbDescriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
                String mosconeTransactionAttribute = PropsToXmlConverter.convertTransactionAttribute(ejb1TransactionAttribute);
                System.out.println("You have entered the bean level transaction attribute of " + ejb1TransactionAttribute);
                System.out.println("This is being interpreted for Moscone as follows:");
                System.out.println("1) The bean level transaction attribute is 'Container'");
                System.out.println("2) The default for all the method level container transactions is " + mosconeTransactionAttribute);
                System.out.println("3) This default for each method is overridden by any method level transaction attribute you specify elsewhere in the props file");
                Class<?> beanHome = fcl.loadClass(ejbDescriptor.getHomeClassName());
                Class<?> beanRemote = fcl.loadClass(ejbDescriptor.getRemoteClassName());
                Vector allMethods = BeanMethodCalculator.getTransactionalMethodsFor(ejbDescriptor, beanHome, beanRemote);
                Enumeration e10 = allMethods.elements();
                while (e10.hasMoreElements()) {
                    Method nextMethod = (Method)e10.nextElement();
                    MethodDescriptor nextMethodDescriptor = new MethodDescriptor(nextMethod, ejbDescriptor, fcl);
                    ContainerTransaction methodContainerTransaction = new ContainerTransaction(mosconeTransactionAttribute, "");
                    ejbDescriptor.getMethodContainerTransactions().put(nextMethodDescriptor, methodContainerTransaction);
                }
            }
            int j3 = 0;
            while (j3 < mCount) {
                String mPrefix = String.valueOf(prefix) + "mdesc" + j3 + ".";
                MethodDescriptor md = this.convertMethodDescriptor(mPrefix, p2, fcl, ejbDescriptor);
                ejb1TransactionAttribute = ((Properties)p2).getProperty(String.valueOf(mPrefix) + "transactionAttribute");
                String mosconeTransactionAttribute = PropsToXmlConverter.convertTransactionAttribute(ejb1TransactionAttribute);
                ContainerTransaction methodContainerTransaction = new ContainerTransaction(mosconeTransactionAttribute, "");
                ejbDescriptor.getMethodContainerTransactions().put(md, methodContainerTransaction);
                ++j3;
            }
            if (type.equals("session")) {
                EjbSessionDescriptor sessionDescriptor = (EjbSessionDescriptor)ejbDescriptor;
                String sm = ((Properties)p2).getProperty(String.valueOf(prefix) + "session.state");
                if (sm.equals("STATEFUL_SESSION")) {
                    sessionDescriptor.setStateless(false);
                } else if (sm.equals("STATELESS_SESSION")) {
                    sessionDescriptor.setStateless(true);
                }
            } else {
                String primaryKeyFieldName;
                EjbEntityDescriptor entityDescriptor = (EjbEntityDescriptor)ejbDescriptor;
                String name = ((Properties)p2).getProperty(String.valueOf(prefix) + "entity.primaryKey");
                entityDescriptor.setPrimaryKeyClassName(name);
                String reentrant = ((Properties)p2).getProperty(String.valueOf(prefix) + "isReentrant");
                if (reentrant != null && "true".equals(reentrant)) {
                    entityDescriptor.setReentrant(true);
                }
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.persistenceType") != null) {
                    entityDescriptor.setPersistenceType(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.persistenceType").trim());
                }
                if ((primaryKeyFieldName = ((Properties)p2).getProperty(String.valueOf(prefix) + "entity.primaryKeyField")) != null) {
                    entityDescriptor.setPrimaryKeyField(new FieldDescriptor(primaryKeyFieldName, ""));
                }
                int count = Integer.parseInt(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.#containerFields"));
                HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
                int j4 = 0;
                while (j4 < count) {
                    String str = String.valueOf(prefix) + "entity.containerField" + j4;
                    String fieldName = ((Properties)p2).getProperty(str);
                    FieldDescriptor fieldDescriptor = new FieldDescriptor(fieldName, "");
                    if (fieldName == null) {
                        throw new IOException("Bad containerField count or containerField key");
                    }
                    persistentFields.add(fieldDescriptor);
                    ++j4;
                }
                entityDescriptor.setPersistentFields(persistentFields);
                ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.DBJndiName") != null) {
                    rrd.setJndiName(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.DBJndiName"));
                }
                rrd.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.defaultDBAccount")));
                entityDescriptor.setResourceReference(rrd);
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.tableCreateSqlStatement") != null) {
                    entityDescriptor.setTableCreateSqlStatement(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.tableCreateSqlStatement"));
                }
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.tableRemoveSqlStatement") != null) {
                    entityDescriptor.setTableRemoveSqlStatement(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.tableRemoveSqlStatement"));
                }
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.#sqlStatements") != null) {
                    int sqlStatementCount = Integer.parseInt(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.#sqlStatements"));
                    int index = 0;
                    while (index < sqlStatementCount) {
                        String sqlMethodPrefix = String.valueOf(prefix) + "entity.sqlStatement" + index + ".mdesc.";
                        MethodDescriptor md = this.convertMethodDescriptor(sqlMethodPrefix, p2, fcl, entityDescriptor);
                        String sql = ((Properties)p2).getProperty(String.valueOf(prefix) + "entity.sqlStatement" + index + ".sql");
                        entityDescriptor.setSqlStatementFor(md, sql);
                        ++index;
                    }
                }
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.createTableOnDeployment") != null) {
                    entityDescriptor.setCreateTableOnDeployment(new Boolean(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.createTableOnDeployment")));
                }
                if (((Properties)p2).getProperty(String.valueOf(prefix) + "entity.deleteTableOnUndeployment") != null) {
                    entityDescriptor.setDeleteTableOnUndeployment(new Boolean(((Properties)p2).getProperty(String.valueOf(prefix) + "entity.deleteTableOnUndeployment")));
                }
            }
            this.convertResourceReferences(prefix, p2, ejbDescriptor);
            System.out.println("Adding an XML EJB descriptor to the application...");
            ejbBundleDescriptor.addEjb(ejbDescriptor);
            this.convertMethodPermissions(prefix, p2, ejbDescriptor, fcl);
            ++i2;
        }
        if (!ejbBundleDescriptor.areResourceReferencesValid()) {
            throw new RuntimeException("Make sure that if you declare an env prop to be a role reference, the value of the prop must be a declared role");
        }
        Enumeration e11 = this.ejbReferencesToConvert.keys();
        while (e11.hasMoreElements()) {
            String envPrefix = (String)e11.nextElement();
            ejbDescriptor = (EjbDescriptor)this.ejbReferencesToConvert.get(envPrefix);
            this.convertEjbReference(ejbDescriptor.getEjbBundleDescriptor(), p2, envPrefix, ejbDescriptor);
        }
        PropsToXmlConverter.writeXmlToFiles(application, xmlFilename, optionalEjbBundleFilename, optionalRuntimeFilename);
        System.out.println("Done: XML deployment descriptor for " + application.getName() + " has been written to " + xmlFilename);
    }

    public static String convertTransactionAttribute(String ejb1TransactionAttribute) {
        if (ejb1TransactionAttribute.equals("TX_NOT_SUPPORTED")) {
            return ContainerTransaction.NOT_SUPPORTED;
        }
        if (ejb1TransactionAttribute.equals("TX_REQUIRED")) {
            return ContainerTransaction.REQUIRED;
        }
        if (ejb1TransactionAttribute.equals("TX_SUPPORTS")) {
            return ContainerTransaction.SUPPORTS;
        }
        if (ejb1TransactionAttribute.equals("TX_REQUIRES_NEW")) {
            return ContainerTransaction.REQUIRES_NEW;
        }
        if (ejb1TransactionAttribute.equals("TX_MANDATORY")) {
            return ContainerTransaction.MANDATORY;
        }
        if (ejb1TransactionAttribute.equals("TX_NEVER")) {
            return ContainerTransaction.NEVER;
        }
        throw new IllegalArgumentException(String.valueOf(ejb1TransactionAttribute) + " is not a known transaction attribute in EJB 1.0");
    }

    private static void help() {
        System.out.println("Usage:- ");
        System.out.println("<propsfilename> <codebase> <applicationxmlfilenameForOutput> optional-ejb-bundle-xml-filename optional-runtime-filename");
        System.out.println("NB: The bean classes MUST be findable from the codebase. ");
    }

    public static void main(String[] args) {
        try {
            if (args[0] != null && args[1] != null && args[2] != null) {
                String optionalEjbBundleFilename = "";
                String optionalRuntimeFilename = "";
                if (args.length == 5) {
                    if (args[3] != null) {
                        optionalEjbBundleFilename = args[3];
                    }
                    if (args[4] != null) {
                        optionalRuntimeFilename = args[4];
                    }
                }
                PropsToXmlConverter converter = new PropsToXmlConverter();
                converter.convertToXml(new File(args[0]), args[1], args[2], optionalEjbBundleFilename, optionalRuntimeFilename);
            } else {
                PropsToXmlConverter.help();
                System.exit(1);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.out.println(" error converting properties file ");
            System.exit(1);
        }
    }

    private static void makeGroupRoleMapping(RoleMapper rm, Role r2, String commaSeparatedList) {
        StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
        while (st.hasMoreTokens()) {
            rm.assignRole(new Group(st.nextToken()), r2);
        }
    }

    private static void makeUserRoleMapping(RoleMapper rm, Role r2, String commaSeparatedList) {
        StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
        while (st.hasMoreTokens()) {
            rm.assignRole(new PrincipalImpl(st.nextToken()), r2);
        }
    }

    static MailConfiguration parseMailConfigurationFromString(String s2) {
        if (s2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s2, ",");
        return new MailConfiguration(st.nextToken(), st.nextToken(), st.nextToken());
    }

    private static ResourcePrincipal parseResourcePrincipalFromString(String s2) {
        if (s2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s2, ",");
        return new ResourcePrincipal(st.nextToken(), st.nextToken());
    }

    private static Enumeration parseRolesFrom(String commaSeparatedRoleNames) {
        Vector<Role> roles = new Vector<Role>();
        StringTokenizer st = new StringTokenizer(commaSeparatedRoleNames, ",");
        while (st.hasMoreTokens()) {
            roles.addElement(new Role(st.nextToken()));
        }
        return roles.elements();
    }

    public static void writeXmlToFiles(Application application, String xmlFilename, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws IOException {
        XmlDocument document = null;
        Object out = null;
        File xmlFile = null;
        xmlFile = "".equals(optionalEjbBundleFilename) ? new File(ComponentPackager.getEjbBundleFilename(xmlFilename)) : new File(optionalEjbBundleFilename);
        EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)application.getEjbBundleDescriptors().iterator().next();
        ejbBundleDescriptor.getArchivist().setArchiveUri("dannyc - not used when the xml is not in a JAR file");
        document = EjbBundleNode.getDocument(ejbBundleDescriptor);
        XMLUtils.writeDocumentToFile(document, xmlFile);
        document = RuntimeDescriptorNode.getDocument(application);
        StringWriter sw = new StringWriter();
        XMLUtils.writeDocument(document, sw);
        xmlFile = "".equals(optionalRuntimeFilename) ? new File(ComponentPackager.getRuntimeDescriptorFilename(xmlFilename)) : new File(optionalRuntimeFilename);
        XMLUtils.writeDocumentToFile(document, xmlFile);
        document = ApplicationNode.getDocument(application);
        xmlFile = new File(xmlFilename);
        XMLUtils.writeDocumentToFile(document, xmlFile);
    }
}

