/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.omg.CosTransactions.otid_t;

public class GlobalTID {
    static GlobalTID NullGlobalTID = new GlobalTID(-1, -1, null);
    otid_t realTID = null;
    private String stringForm = null;
    private int hashCode = 0;
    private boolean hashed = false;

    GlobalTID(int formatID, int bequal_length, byte[] data) {
        this.realTID = new otid_t(formatID, bequal_length, data);
    }

    GlobalTID(DataInputStream dataIn) {
        try {
            int formatID = dataIn.readInt();
            int bqualLength = dataIn.readInt();
            int bufferlen = dataIn.readUnsignedShort();
            byte[] tid = new byte[bufferlen];
            dataIn.read(tid);
            this.realTID = new otid_t(formatID, bqualLength, tid);
        }
        catch (Throwable throwable) {}
    }

    public GlobalTID(otid_t otherTID) {
        this.realTID = otherTID;
    }

    GlobalTID(byte[] bytes) {
        int formatID = (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
        int bqualLength = (bytes[4] & 0xFF) + ((bytes[5] & 0xFF) << 8) + ((bytes[6] & 0xFF) << 16) + ((bytes[7] & 0xFF) << 24);
        byte[] tid = new byte[bytes.length - 8];
        System.arraycopy(bytes, 8, tid, 0, tid.length);
        this.realTID = new otid_t(formatID, bqualLength, tid);
    }

    final GlobalTID copy() {
        GlobalTID result = new GlobalTID(this.realTID);
        result.hashed = this.hashed;
        result.hashCode = this.hashCode;
        result.stringForm = this.stringForm;
        return result;
    }

    public final boolean equals(Object other) {
        otid_t otherTID = null;
        if (other == null) {
            return false;
        }
        if (other instanceof otid_t) {
            otherTID = (otid_t)other;
        } else if (other instanceof GlobalTID) {
            otherTID = ((GlobalTID)other).realTID;
        } else {
            return false;
        }
        boolean result = false;
        if (this.realTID == otherTID) {
            return true;
        }
        if (this.realTID.formatID != otherTID.formatID) {
            return false;
        }
        int firstGTRID = this.realTID.tid.length - this.realTID.bequal_length;
        int secondGTRID = otherTID.tid.length - otherTID.bequal_length;
        if (firstGTRID != secondGTRID) {
            return false;
        }
        result = true;
        int pos = 0;
        while (pos < firstGTRID && result) {
            result = this.realTID.tid[pos] == otherTID.tid[pos];
            ++pos;
        }
        return result;
    }

    public final int hashCode() {
        if (this.hashed) {
            return this.hashCode;
        }
        this.hashCode = 0;
        if (this.realTID.tid != null) {
            int pos = 0;
            while (pos < this.realTID.tid.length) {
                this.hashCode += this.realTID.tid[pos];
                ++pos;
            }
        }
        this.hashCode += this.realTID.formatID + this.realTID.bequal_length;
        this.hashCode *= 1904362337;
        this.hashed = true;
        return this.hashCode;
    }

    final boolean isNull() {
        return this.realTID.formatID == -1;
    }

    final byte[] toBytes() {
        if (this.realTID.formatID == -1) {
            return null;
        }
        byte[] result = new byte[this.realTID.tid.length + 8];
        result[0] = (byte)this.realTID.formatID;
        result[1] = (byte)(this.realTID.formatID >> 8);
        result[2] = (byte)(this.realTID.formatID >> 16);
        result[3] = (byte)(this.realTID.formatID >> 24);
        result[4] = (byte)this.realTID.bequal_length;
        result[5] = (byte)(this.realTID.bequal_length >> 8);
        result[6] = (byte)(this.realTID.bequal_length >> 16);
        result[7] = (byte)(this.realTID.bequal_length >> 24);
        System.arraycopy(this.realTID.tid, 0, result, 8, this.realTID.tid.length);
        return result;
    }

    public final String toString() {
        if (this.realTID.formatID == -1) {
            return "[NULL ID]";
        }
        if (this.stringForm != null) {
            return this.stringForm;
        }
        char[] buff = new char[this.realTID.tid.length * 2 + 2 + (this.realTID.bequal_length > 0 ? 1 : 0)];
        int pos = 0;
        buff[pos++] = 91;
        int globalLen = this.realTID.tid.length - this.realTID.bequal_length;
        int i2 = 0;
        while (i2 < globalLen) {
            int currCharHigh = (this.realTID.tid[i2] & 0xF0) >> 4;
            int currCharLow = this.realTID.tid[i2] & 0xF;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            ++i2;
        }
        if (this.realTID.bequal_length > 0) {
            buff[pos++] = 58;
            int i3 = 0;
            while (i3 < this.realTID.bequal_length) {
                int currCharHigh = (this.realTID.tid[i3 + globalLen] & 0xF0) >> 4;
                int currCharLow = this.realTID.tid[i3 + globalLen] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
                ++i3;
            }
        }
        buff[pos] = 93;
        this.stringForm = new String(buff);
        return this.stringForm;
    }

    final void write(DataOutputStream dataOut) {
        try {
            dataOut.writeInt(this.realTID.formatID);
            dataOut.writeInt(this.realTID.bequal_length);
            dataOut.writeShort(this.realTID.tid.length);
            dataOut.write(this.realTID.tid, 0, this.realTID.tid.length);
        }
        catch (Throwable throwable) {}
    }
}

