/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import java.io.Serializable;

class LogLSN
implements Serializable {
    static final LogLSN HEAD_LSN = new LogLSN(-1, -1);
    static final LogLSN TAIL_LSN = new LogLSN(-1, -2);
    static final LogLSN NULL_LSN = new LogLSN(0, 0);
    static final LogLSN FIRST_LSN = new LogLSN(1, 0);
    static final int SIZEOF = 8;
    int offset = 0;
    int extent = 0;

    LogLSN() {
        this.offset = 0;
        this.extent = 0;
    }

    LogLSN(int ext, int off) {
        this.offset = off;
        this.extent = ext;
    }

    LogLSN(LogLSN lsn) {
        this.offset = lsn.offset;
        this.extent = lsn.extent;
    }

    LogLSN(byte[] bytes, int index) {
        this.offset = (bytes[index++] & 0xFF) + ((bytes[index++] & 0xFF) << 8) + ((bytes[index++] & 0xFF) << 16) + ((bytes[index++] & 0xFF) << 24);
        this.extent = (bytes[index++] & 0xFF) + ((bytes[index++] & 0xFF) << 8) + ((bytes[index++] & 0xFF) << 16) + ((bytes[index++] & 0xFF) << 24);
    }

    final void copy(LogLSN other) {
        this.extent = other.extent;
        this.offset = other.offset;
    }

    final boolean equals(LogLSN other) {
        return this.offset == other.offset && this.extent == other.extent;
    }

    final boolean greaterThan(LogLSN other) {
        return this.offset > other.offset && this.extent == other.extent || this.extent > other.extent;
    }

    final boolean isNULL() {
        return this.offset == 0 && this.extent == 0;
    }

    final boolean lessThan(LogLSN other) {
        return this.offset < other.offset && this.extent == other.extent || this.extent < other.extent;
    }

    final int toBytes(byte[] bytes, int index) {
        bytes[index++] = (byte)this.offset;
        bytes[index++] = (byte)(this.offset >> 8);
        bytes[index++] = (byte)(this.offset >> 16);
        bytes[index++] = (byte)(this.offset >> 24);
        bytes[index++] = (byte)this.extent;
        bytes[index++] = (byte)(this.extent >> 8);
        bytes[index++] = (byte)(this.extent >> 16);
        bytes[index++] = (byte)(this.extent >> 24);
        return 8;
    }

    public final String toString() {
        return "LSN(ext=" + this.extent + ",off=" + this.offset + ")";
    }
}

