/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import java.util.Vector;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Coordinator;

class NestingInfo {
    CoordinatorImpl[] ancestorSeq = null;
    Vector childSet = new Vector();
    boolean removed = false;

    NestingInfo() {
    }

    NestingInfo(CoordinatorImpl[] ancestors) {
        this.ancestorSeq = (CoordinatorImpl[])ancestors.clone();
        this.removed = ancestors.length == 0;
    }

    boolean addChild(CoordinatorImpl child) {
        boolean result = this.childSet.contains(child) ^ true;
        if (result) {
            this.childSet.addElement(child);
        }
        return result;
    }

    void empty() {
        this.childSet.removeAllElements();
    }

    public void finalize() {
        if (this.childSet != null) {
            this.childSet.removeAllElements();
        }
        this.childSet = null;
        if (this.ancestorSeq != null) {
            int i2 = 0;
            while (i2 < this.ancestorSeq.length) {
                this.ancestorSeq[i2] = null;
                ++i2;
            }
            this.ancestorSeq = null;
        }
    }

    CoordinatorImpl[] getAncestors() {
        CoordinatorImpl[] result = null;
        result = (CoordinatorImpl[])this.ancestorSeq.clone();
        return result;
    }

    CoordinatorImpl getParent(boolean forgetting) {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[0];
        }
        if (forgetting) {
            this.removed = true;
        }
        return result;
    }

    CoordinatorImpl getTopLevel() {
        CoordinatorImpl result = null;
        if (this.ancestorSeq.length != 0) {
            result = this.ancestorSeq[this.ancestorSeq.length - 1];
        }
        return result;
    }

    boolean isDescendant(Coordinator other) {
        boolean result = false;
        try {
            int i2 = 0;
            while (i2 < this.ancestorSeq.length && !result) {
                result = this.ancestorSeq[i2].is_same_transaction(other);
                ++i2;
            }
        }
        catch (SystemException systemException) {
            result = false;
        }
        return result;
    }

    int numChildren() {
        return this.childSet.size();
    }

    boolean removeChild(CoordinatorImpl child) {
        boolean result = this.childSet.removeElement(child);
        return result;
    }

    boolean removeFromParent(CoordinatorImpl child) {
        boolean result = true;
        if (!this.removed) {
            CoordinatorImpl parent = this.ancestorSeq[0];
            result = parent.removeChild(child);
            this.removed = true;
        }
        return result;
    }

    boolean replyCheck() {
        boolean result = false;
        int i2 = 0;
        while (i2 < this.childSet.size() && !result) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(i2);
            result = child.isActive();
            ++i2;
        }
        return result;
    }

    void rollbackFamily() {
        while (this.childSet.size() > 0) {
            CoordinatorImpl child = (CoordinatorImpl)this.childSet.elementAt(0);
            try {
                child.rollback(true);
            }
            catch (Throwable throwable) {}
        }
    }
}

