/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class XID
implements Xid {
    private int formatID = -1;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data = new byte[128];
    private static final int XIDDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab = "0123456789ABCDEF";

    public void copy(XID from) {
        this.formatID = -1;
        if (from == null) {
            return;
        }
        if (from.formatID == -1) {
            return;
        }
        this.gtrid_length = from.gtrid_length;
        this.bqual_length = from.bqual_length;
        if (this.data != null && from.data != null) {
            System.arraycopy(from.data, 0, this.data, 0, 128);
        }
        this.formatID = from.formatID;
    }

    public void copy(otid_t from) {
        this.formatID = -1;
        if (from == null) {
            return;
        }
        if (from.formatID == -1) {
            return;
        }
        int L = from.tid.length;
        this.gtrid_length = L - from.bequal_length;
        this.bqual_length = from.bequal_length;
        if (this.data != null && from.tid != null) {
            System.arraycopy(from.tid, 0, this.data, 0, L);
        }
        this.formatID = from.formatID;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof XID)) {
            return false;
        }
        XID other = (XID)o2;
        if (this.formatID == -1 && other.formatID == -1) {
            return true;
        }
        if (this.formatID != other.formatID || this.gtrid_length != other.gtrid_length || this.bqual_length != other.bqual_length) {
            return false;
        }
        int L = this.gtrid_length + this.bqual_length;
        int i2 = 0;
        while (i2 < L) {
            if (this.data[i2] != other.data[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public byte[] getBranchQualifier() {
        byte[] bqual = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, bqual, 0, this.bqual_length);
        return bqual;
    }

    public int getFormatID() {
        return this.formatID;
    }

    public int getFormatId() {
        return this.getFormatID();
    }

    public byte[] getGlobalTransactionId() {
        return this.getGlobalTransactionIdentifier();
    }

    public byte[] getGlobalTransactionIdentifier() {
        byte[] gtrid = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, gtrid, 0, this.gtrid_length);
        return gtrid;
    }

    public int hashCode() {
        if (this.formatID == -1) {
            return -1;
        }
        return this.formatID + this.gtrid_length - this.bqual_length;
    }

    public boolean isEqualBranchQualifier(byte[] data) {
        int L;
        int n2 = L = data.length > 64 ? 64 : data.length;
        if (L != this.bqual_length) {
            return false;
        }
        int i2 = 0;
        while (i2 < L) {
            if (data[i2] != this.data[this.gtrid_length + i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean isEqualGtrid(XID xid) {
        if (this.gtrid_length != xid.gtrid_length) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.gtrid_length) {
            if (this.data[i2] != xid.data[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void setBranchQualifier(byte[] qual) {
        this.bqual_length = qual.length > 64 ? 64 : qual.length;
        System.arraycopy(qual, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public void setFormatID(int formatID) {
        this.formatID = formatID;
    }

    public String toString() {
        int L = this.gtrid_length + this.bqual_length;
        StringBuffer d10 = new StringBuffer(L + L);
        int i2 = 0;
        while (i2 < L) {
            int v2 = this.data[i2] & 0xFF;
            d10.append(hextab.charAt(v2 / 16));
            d10.append(hextab.charAt(v2 & 0xF));
            if ((i2 + 1) % 4 == 0 && i2 + 1 < L) {
                d10.append(" ");
            }
            ++i2;
        }
        String s2 = new String("{XID: formatID(" + this.formatID + "), " + "gtrid_length(" + this.gtrid_length + "), " + "bqual_length(" + this.bqual_length + "), " + "data(" + d10 + ")" + "}");
        return s2;
    }
}

