/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.VersionHelper;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final Hashtable propertiesCache = new Hashtable(11);
    private static final Hashtable factoryCache = new Hashtable(11);
    private static final Hashtable urlFactoryCache = new Hashtable(11);

    private ResourceManager() {
    }

    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader classLoader;
        try {
            classLoader = helper.getContextClassLoader();
        }
        catch (SecurityException securityException) {
            return new Hashtable(1);
        }
        Object object = classLoader != null ? classLoader : "bootstrap";
        Hashtable hashtable = propertiesCache;
        synchronized (hashtable) {
            Object object2 = (Hashtable)propertiesCache.get(object);
            if (object2 != null) {
                Hashtable hashtable2 = object2;
                Object var4_6 = null;
                return hashtable2;
            }
            try {
                Object object3;
                NamingEnumeration namingEnumeration = helper.getResources(classLoader, "jndi.properties");
                while (namingEnumeration.hasMore()) {
                    object3 = new Properties();
                    ((Properties)object3).load((InputStream)namingEnumeration.next());
                    if (object2 == null) {
                        object2 = object3;
                        continue;
                    }
                    ResourceManager.mergeTables(object2, (Hashtable)object3);
                }
                object3 = helper.getJavaHomeLibStream("jndi.properties");
                if (object3 != null) {
                    Properties properties = new Properties();
                    properties.load((InputStream)object3);
                    if (object2 == null) {
                        object2 = properties;
                    } else {
                        ResourceManager.mergeTables((Hashtable)object2, properties);
                    }
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            if (object2 == null) {
                object2 = new Hashtable(11);
            }
            propertiesCache.put(object, object2);
            Object object4 = object2;
            Object var4_7 = null;
            return object4;
        }
    }

    public static FactoryEnumeration getFactories(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        FactoryKey factoryKey = new FactoryKey(string2);
        Hashtable hashtable2 = factoryCache;
        synchronized (hashtable2) {
            Vector<Class> vector = (Vector<Class>)factoryCache.get(factoryKey);
            if (vector != null) {
                FactoryEnumeration factoryEnumeration = vector.size() == 0 ? null : new FactoryEnumeration(vector);
                Object var7_9 = null;
                return factoryEnumeration;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            vector = new Vector<Class>(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    vector.addElement(helper.loadClass(stringTokenizer.nextToken(), factoryKey.loader));
                }
                catch (Exception exception) {}
            }
            factoryCache.put(factoryKey, vector);
            FactoryEnumeration factoryEnumeration = new FactoryEnumeration(vector);
            Object var7_10 = null;
            return factoryEnumeration;
        }
    }

    public static Object getFactory(String string, Hashtable hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? String.valueOf(string4) + ":" + string3 : string3;
        FactoryKey factoryKey = new FactoryKey(String.valueOf(string2) + string4);
        Hashtable hashtable2 = urlFactoryCache;
        synchronized (hashtable2) {
            Object object = urlFactoryCache.get(factoryKey);
            if (object != null) {
                Object var7_9 = object.equals("none") ? null : object;
                Object var9_11 = null;
                return var7_9;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (object == null && stringTokenizer.hasMoreTokens()) {
                String string5 = String.valueOf(stringTokenizer.nextToken()) + string2;
                try {
                    object = helper.loadClass(string5, factoryKey.loader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string5);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string5);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                urlFactoryCache.put(factoryKey, object);
            } else {
                urlFactoryCache.put(factoryKey, "none");
            }
            Object v2 = object;
            Object var9_12 = null;
            return v2;
        }
    }

    public static Hashtable getInitialEnvironment(Hashtable hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Applet applet = (Applet)hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object = hashtable.get(stringArray[n2]);
            if (object == null) {
                if (applet != null) {
                    object = applet.getParameter(stringArray[n2]);
                }
                if (object == null) {
                    String string = object = stringArray2 != null ? stringArray2[n2] : helper.getJndiProperty(n2);
                }
                if (object != null) {
                    hashtable.put(stringArray[n2], object);
                }
            }
            ++n2;
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable hashtable, Context context, boolean bl2) throws NamingException {
        String string2;
        String string3 = string2 = hashtable != null ? (String)hashtable.get(string) : null;
        if (context == null || string2 != null && !bl2) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl2) {
            return string2;
        }
        return String.valueOf(string2) + ":" + string4;
    }

    private static Hashtable getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        Hashtable hashtable = propertiesCache;
        synchronized (hashtable) {
            Class<?> clazz = object.getClass();
            Hashtable hashtable2 = (Hashtable)propertiesCache.get(clazz);
            if (hashtable2 != null) {
                Hashtable hashtable3 = hashtable2;
                Object var3_6 = null;
                return hashtable3;
            }
            hashtable2 = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    ((Properties)hashtable2).load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, hashtable2);
            Hashtable hashtable4 = hashtable2;
            Object var3_7 = null;
            return hashtable4;
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        int n2 = 0;
        while (n2 < listProperties.length) {
            if (string == listProperties[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void mergeTables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v2 = hashtable.get(string);
            if (v2 == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!ResourceManager.isListProperty(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, String.valueOf((String)v2) + ":" + string2);
        }
    }

    private static final class FactoryKey {
        private String propVal;
        private ClassLoader loader;

        FactoryKey(String string) {
            try {
                this.loader = helper.getContextClassLoader();
            }
            catch (SecurityException securityException) {}
            this.propVal = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FactoryKey)) {
                return false;
            }
            FactoryKey factoryKey = (FactoryKey)object;
            return this.propVal.equals(factoryKey.propVal) && (this.loader == factoryKey.loader || this.loader != null && this.loader.equals(factoryKey.loader));
        }

        public int hashCode() {
            return this.propVal.hashCode() + (this.loader != null ? this.loader.hashCode() : 0);
        }
    }
}

