/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.web.security.AccessControlInfo;
import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.DefaultRequestSecurityProvider;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.deployment.SecurityRoleReference;
import org.apache.tomcat.service.http.HttpRequestAdapter;

public final class RequestSecurityProviderImpl
extends DefaultRequestSecurityProvider {
    private static RequestSecurityProviderImpl requestSecurityProvider = null;
    static /* synthetic */ Class class$com$sun$web$security$RequestSecurityProviderImpl;

    private RequestSecurityProviderImpl() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static java.security.cert.X509Certificate[] convert(X509Certificate[] certs) throws Exception {
        if (certs == null) {
            return null;
        }
        java.security.cert.X509Certificate[] javaCert = new java.security.cert.X509Certificate[certs.length];
        CertificateFactory cfactory = CertificateFactory.getInstance("X.509");
        int i2 = 0;
        while (i2 < certs.length) {
            ByteArrayInputStream bais = new ByteArrayInputStream(certs[i2].getEncoded());
            javaCert[i2] = (java.security.cert.X509Certificate)cfactory.generateCertificate(bais);
            ++i2;
        }
        return javaCert;
    }

    static java.security.cert.X509Certificate[] getCertChain(HttpServletRequest req) {
        HttpRequestAdapter sreq;
        if (req instanceof HttpServletRequestFacade && ((HttpServletRequestFacade)req).getRealRequest().getRequestAdapter() instanceof HttpRequestAdapter && (sreq = (HttpRequestAdapter)((HttpServletRequestFacade)req).getRealRequest().getRequestAdapter()).getSocket() instanceof SSLSocket) {
            try {
                return RequestSecurityProviderImpl.convert(((SSLSocket)sreq.getSocket()).getSession().getPeerCertificateChain());
            }
            catch (Exception exception) {
            }
        }
        return new java.security.cert.X509Certificate[0];
    }

    public static DefaultRequestSecurityProvider getInstance() {
        if (requestSecurityProvider == null) {
            Class clazz = class$com$sun$web$security$RequestSecurityProviderImpl != null ? class$com$sun$web$security$RequestSecurityProviderImpl : (class$com$sun$web$security$RequestSecurityProviderImpl = RequestSecurityProviderImpl.class$("com.sun.web.security.RequestSecurityProviderImpl"));
            synchronized (clazz) {
                requestSecurityProvider = new RequestSecurityProviderImpl();
            }
        }
        return requestSecurityProvider;
    }

    private String getRoleRef(Context context, String compName, String roleRef) {
        SecurityRoleReference r2;
        WebBundleDescriptor wbd = (WebBundleDescriptor)Switch.getSwitch().getDescriptorFor(context);
        if (wbd != null && (r2 = wbd.getSecurityRoleReferenceByName(compName, roleRef)) != null) {
            return r2.getSecurityRoleLink().getName();
        }
        return null;
    }

    public Principal getUserPrincipal(Context context, HttpServletRequest req) {
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null) {
            return sc.getCallerPrincipal();
        }
        return null;
    }

    public boolean isSecure(Context context, HttpServletRequest req) {
        if (req instanceof HttpServletRequestFacade && ((HttpServletRequestFacade)req).getRealRequest().getRequestAdapter() instanceof HttpRequestAdapter) {
            HttpRequestAdapter sreq = (HttpRequestAdapter)((HttpServletRequestFacade)req).getRealRequest().getRequestAdapter();
            return sreq.getSocket() instanceof SSLSocket;
        }
        return false;
    }

    public boolean isUserInRole(Context context, HttpServletRequest req, String roleRef) {
        AccessControlInfo accInfo;
        RoleMapper rmap;
        if (roleRef == null) {
            throw new IllegalArgumentException("Argument is null.");
        }
        String servname = (String)req.getAttribute("org.apache.tomcat.servlet.resolved");
        if (servname == null) {
            return false;
        }
        String rname = this.getRoleRef(context, servname, roleRef);
        if (rname != null && (rmap = RoleMapper.getRoleMapper((accInfo = AccessControlInfo.getInstance(context)).getApplicationName())) != null) {
            Enumeration e10 = rmap.getCurrentRoles();
            while (e10.hasMoreElements()) {
                Role r2 = (Role)e10.nextElement();
                if (!r2.getName().equals(rname)) continue;
                return true;
            }
        }
        return false;
    }
}

