/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlReadable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class ParentNode
extends NodeBase
implements XmlReadable {
    private NodeBase[] children;
    private int length;

    ParentNode() {
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, null);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(nodeBase.getNodeType());
        if (this.children == null) {
            this.children = new NodeBase[3];
        } else if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        nodeBase.setParentNode(this, this.length);
        this.children[this.length++] = nodeBase;
        this.mutated();
        return nodeBase;
    }

    abstract void checkChildType(int var1) throws DOMException;

    private NodeBase checkDocument(Node node) throws DOMException {
        if (node == null) {
            throw new DomEx(3);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = this.ownerDocument;
        NodeBase nodeBase = (NodeBase)node;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (document != null && document != xmlDocument) {
            throw new DomEx(4);
        }
        if (document == null) {
            nodeBase.setOwnerDocument(xmlDocument);
        }
        if (nodeBase.hasChildNodes()) {
            Node node2;
            int n2 = 0;
            while ((node2 = nodeBase.item(n2)) != null) {
                if (node2.getOwnerDocument() == null) {
                    ((NodeBase)node2).setOwnerDocument(xmlDocument);
                } else if (node2.getOwnerDocument() != xmlDocument) {
                    throw new DomEx(4);
                }
                ++n2;
            }
        }
        return nodeBase;
    }

    private void checkNotAncestor(Node node) throws DOMException {
        if (!node.hasChildNodes()) {
            return;
        }
        Node node2 = this;
        while (node2 != null) {
            if (node == node2) {
                throw new DomEx(3);
            }
            node2 = node2.getParentNode();
        }
    }

    private void consumeFragment(Node node, Node node2) throws DOMException {
        Node node3;
        ParentNode parentNode = (ParentNode)node;
        int n2 = 0;
        while ((node3 = parentNode.item(n2)) != null) {
            this.checkNotAncestor(node3);
            this.checkChildType(node3.getNodeType());
            ++n2;
        }
        while ((node3 = parentNode.item(0)) != null) {
            this.insertBefore(node3, node2);
        }
    }

    public void doneChild(NodeEx nodeEx, ParseContext parseContext) throws SAXException {
    }

    public void doneParse(ParseContext parseContext) throws SAXException {
    }

    public NodeList getElementsByTagName(String string) {
        if ("*".equals(string)) {
            string = null;
        }
        return new TagList(string);
    }

    public final Node getFirstChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public final int getIndexOf(Node node) {
        int n2 = 0;
        while (n2 < this.length) {
            if (this.children[n2] == node) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final Node getLastChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[this.length - 1];
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node2 == null) {
            return this.appendChild(node);
        }
        if (this.length == 0) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        int n2 = 0;
        while (n2 < this.length) {
            if (this.children[n2] == node2) {
                nodeBase.setParentNode(this, n2);
                System.arraycopy(this.children, n2, this.children, n2 + 1, this.length - n2);
                this.children[n2] = nodeBase;
                ++this.length;
                this.mutated();
                return node;
            }
            ++n2;
        }
        throw new DomEx(8);
    }

    public final Node item(int n2) {
        if (this.length == 0 || n2 >= this.length) {
            return null;
        }
        try {
            return this.children[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void mutated() {
        XmlDocument xmlDocument = this.ownerDocument;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (xmlDocument != null) {
            ++xmlDocument.mutationCount;
        }
    }

    void reduceWaste() {
        if (this.children == null) {
            return;
        }
        if (this.children.length - this.length > 6) {
            this.trimToSize();
        }
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = (NodeBase)node;
        int n2 = 0;
        while (n2 < this.length) {
            if (this.children[n2] == nodeBase) {
                if (n2 + 1 != this.length) {
                    System.arraycopy(this.children, n2 + 1, this.children, n2, this.length - 1 - n2);
                }
                --this.length;
                this.children[this.length] = null;
                nodeBase.setParentNode(null, -1);
                this.mutated();
                return node;
            }
            ++n2;
        }
        throw new DomEx(8);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node == null || node2 == null) {
            throw new DomEx(3);
        }
        if (this.children == null) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return this.removeChild(node2);
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        int n2 = 0;
        while (n2 < this.length) {
            if (this.children[n2] == node2) {
                nodeBase.setParentNode(this, n2);
                this.children[n2] = nodeBase;
                ((NodeBase)node2).setParentNode(null, -1);
                this.mutated();
                return node2;
            }
            ++n2;
        }
        throw new DomEx(8);
    }

    public void startParse(ParseContext parseContext) throws SAXException {
    }

    public void trimToSize() {
        if (this.length == 0) {
            this.children = null;
        } else if (this.children.length != this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        if (this.children == null) {
            return;
        }
        int n2 = 0;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.getNodeType() == 1) {
            bl2 = "preserve".equals(this.getInheritedAttribute("xml:space"));
            n2 = xmlWriteContext.getIndentLevel();
        }
        try {
            if (!bl2) {
                xmlWriteContext.setIndentLevel(n2 + 2);
            }
            int n3 = 0;
            while (n3 < this.length) {
                if (!bl2 && this.children[n3].getNodeType() != 3) {
                    xmlWriteContext.printIndent();
                    bl3 = false;
                }
                this.children[n3].writeXml(xmlWriteContext);
                ++n3;
            }
        }
        finally {
            Object var6_6 = null;
            if (!bl2) {
                xmlWriteContext.setIndentLevel(n2);
                if (!bl3) {
                    xmlWriteContext.printIndent();
                }
            }
        }
    }

    class TagList
    implements NodeList {
        private String tag;
        private int lastMutationCount;
        private int lastIndex;
        private TreeWalker lastWalker;

        TagList(String string) {
            this.tag = string;
        }

        private int getLastMutationCount() {
            XmlDocument xmlDocument = (XmlDocument)ParentNode.this.getOwnerDocument();
            return xmlDocument == null ? 0 : xmlDocument.mutationCount;
        }

        public int getLength() {
            TreeWalker treeWalker = new TreeWalker(ParentNode.this);
            Element element = null;
            int n2 = 0;
            while ((element = treeWalker.getNextElement(this.tag)) != null) {
                ++n2;
            }
            return n2;
        }

        public Node item(int n2) {
            if (n2 < 0) {
                return null;
            }
            int n3 = this.getLastMutationCount();
            if (this.lastWalker != null && (n2 < this.lastIndex || n3 != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = n3;
            }
            if (n2 == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element element = null;
            while (n2 > this.lastIndex && (element = this.lastWalker.getNextElement(this.tag)) != null) {
                ++this.lastIndex;
            }
            return element;
        }
    }
}

