/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ServletWriter;

public abstract class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspEngineContext ctxt;

    protected Compiler(JspEngineContext ctxt) {
        this.ctxt = ctxt;
    }

    public String changeEncodingIfNecessary(JspReader tmpReader) {
        while (tmpReader.skipUntil("<%@") != null) {
            tmpReader.skipSpaces();
            if (!tmpReader.matches("page")) continue;
            tmpReader.advance(4);
            tmpReader.skipSpaces();
            try {
                int loc;
                Hashtable attrs = tmpReader.parseTagAttributes();
                String ct2 = (String)attrs.get("contentType");
                if (ct2 == null || (loc = ct2.indexOf("charset=")) <= 0) continue;
                String encoding = ct2.substring(loc + 8);
                return encoding;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        int i2;
        String pkgName = this.mangler.getPackageName();
        String className = this.mangler.getClassName();
        String javaFileName = this.mangler.getJavaFileName();
        String classFileName = this.mangler.getClassFileName();
        this.ctxt.setServletClassName(className);
        this.ctxt.setServletPackageName(pkgName);
        this.ctxt.setServletJavaFileName(javaFileName);
        Constants.message("jsp.message.package_name_is", new Object[]{pkgName}, 2);
        Constants.message("jsp.message.class_name_is", new Object[]{className}, 2);
        Constants.message("jsp.message.java_file_name_is", new Object[]{javaFileName}, 2);
        Constants.message("jsp.message.class_file_name_is", new Object[]{classFileName}, 2);
        if (!this.isOutDated()) {
            return false;
        }
        String jspEncoding = "8859_1";
        String javaEncoding = "UTF8";
        JspReader tmpReader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt.getServletContext(), jspEncoding);
        String newEncode = this.changeEncodingIfNecessary(tmpReader);
        if (newEncode != null) {
            jspEncoding = newEncode;
        }
        JspReader reader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt.getServletContext(), jspEncoding);
        ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding)));
        this.ctxt.setReader(reader);
        this.ctxt.setWriter(writer);
        JspParseEventListener listener = new JspParseEventListener(this.ctxt);
        Parser p2 = new Parser(reader, listener);
        listener.beginPageProcessing();
        p2.parse();
        listener.endPageProcessing();
        writer.close();
        String classpath = this.ctxt.getClassPath();
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath + sep + this.ctxt.getOutputDir(), "-d", this.ctxt.getOutputDir(), javaFileName};
        if (javaEncoding != null && !javaEncoding.equals("")) {
            String[] args = new String[argv.length + 2];
            args[0] = "-encoding";
            args[1] = javaEncoding;
            i2 = 0;
            while (i2 < argv.length) {
                args[i2 + 2] = argv[i2];
                ++i2;
            }
            argv = args;
        }
        StringBuffer b10 = new StringBuffer();
        i2 = 0;
        while (i2 < argv.length) {
            b10.append(argv[i2]);
            b10.append(" ");
            ++i2;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{b10.toString()}, 2);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        this.javac.setOut(out);
        boolean status = this.javac.compile(argv);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException(String.valueOf(Constants.getString("jsp.error.unable.compile")) + msg);
        }
        String classFile = String.valueOf(this.ctxt.getOutputDir()) + File.separatorChar;
        if (pkgName != null && !pkgName.equals("")) {
            classFile = String.valueOf(classFile) + pkgName.replace('.', File.separatorChar) + File.separatorChar;
        }
        if (!(classFile = String.valueOf(classFile) + className + ".class").equals(classFileName)) {
            File classFileObject = new File(classFile);
            File myClassFileObject = new File(classFileName);
            if (myClassFileObject.exists()) {
                myClassFileObject.delete();
            }
            if (!classFileObject.renameTo(myClassFileObject)) {
                throw new JasperException(Constants.getString("jsp.error.unable.rename", new Object[]{classFileObject, myClassFileObject}));
            }
        }
        return true;
    }

    public abstract boolean isOutDated();

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

