/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tomcat.core.ApplicationSession;
import org.apache.tomcat.core.Constants;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.DefaultRequestSecurityProvider;
import org.apache.tomcat.core.LifecycleInterceptor;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestSecurityProvider;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.Server;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.ServerSessionManager;
import org.apache.tomcat.core.ServiceInterceptor;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.deployment.ContextParameter;
import org.apache.tomcat.deployment.ErrorPageDescriptor;
import org.apache.tomcat.deployment.InitializationParameter;
import org.apache.tomcat.deployment.JspDescriptor;
import org.apache.tomcat.deployment.MimeMapping;
import org.apache.tomcat.deployment.ServletDescriptor;
import org.apache.tomcat.deployment.WebApplicationDescriptor;
import org.apache.tomcat.deployment.WebApplicationReader;
import org.apache.tomcat.deployment.WebComponentDescriptor;
import org.apache.tomcat.deployment.WebDescriptorFactoryImpl;
import org.apache.tomcat.util.MimeMap;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.URLUtil;
import org.apache.tomcat.util.WARUtil;

public class Context {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private boolean initialized = false;
    private Server server;
    private String description = null;
    private boolean isDistributable = false;
    private String engineHeader = null;
    private Container container = new Container(this);
    private ClassLoader classLoader = null;
    private String classPath = "";
    private ServerSessionManager sessionManager = ServerSessionManager.getManager();
    private ServletContextFacade contextFacade;
    private Hashtable initializationParameters = new Hashtable();
    private Hashtable attributes = new Hashtable();
    private MimeMap mimeTypes = new MimeMap();
    private int sessionTimeOut = -1;
    private Vector welcomeFiles = new Vector();
    private Hashtable errorPages = new Hashtable();
    private Hashtable loadableServlets = new Hashtable();
    private URL docBase;
    private String path = "";
    private boolean isInvokerEnabled = false;
    private File workDir = new File(String.valueOf(System.getProperty("user.dir", ".")) + System.getProperty("file.separator") + "work");
    private boolean isWorkDirPersistent = false;
    private File warDir = null;
    private boolean isWARExpanded = false;
    private boolean isWARValidated = false;
    private Vector initInterceptors = new Vector();
    private Vector serviceInterceptors = new Vector();
    private Vector destroyInterceptors = new Vector();
    private RequestSecurityProvider rsProvider = DefaultRequestSecurityProvider.getInstance();

    public Context() {
    }

    public Context(Server server, String path) {
        this.server = server;
        this.path = path;
        this.contextFacade = new ServletContextFacade(server, this);
        Properties props = this.getProperties("core.properties");
        this.engineHeader = props.getProperty("engine.header", "Tomcat Web Server/3.0 (JSP 1.1; Servlet 2.2; Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; java.vendor=" + System.getProperty("java.vendor") + ")");
    }

    public void addDestroyInterceptor(LifecycleInterceptor interceptor) {
        this.destroyInterceptors.addElement(interceptor);
    }

    public void addInitInterceptor(LifecycleInterceptor interceptor) {
        this.initInterceptors.addElement(interceptor);
    }

    public void addServiceInterceptor(ServiceInterceptor interceptor) {
        this.serviceInterceptors.addElement(interceptor);
    }

    private void clearDir(File dir) {
        block6: {
            String[] files = dir.list();
            if (files == null) break block6;
            int i2 = 0;
            while (i2 < files.length) {
                File f2 = new File(dir, files[i2]);
                if (f2.isDirectory()) {
                    this.clearDir(f2);
                }
                try {
                    f2.delete();
                }
                catch (Exception exception) {}
                ++i2;
            }
            try {
                dir.delete();
            }
            catch (Exception exception) {}
        }
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.tomcat.jsp_classpath")) {
            return this.getClassPath();
        }
        if (name.equals("org.apache.tomcat.classloader")) {
            return this.container.getLoader();
        }
        Object o2 = this.attributes.get(name);
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassPath() {
        String cp2 = this.classPath.trim();
        String servletLoaderClassPath = this.container.getLoader().getClassPath();
        if (servletLoaderClassPath != null && servletLoaderClassPath.trim().length() > 0) {
            cp2 = String.valueOf(cp2) + (cp2.length() > 0 ? File.pathSeparator : "") + servletLoaderClassPath;
        }
        return cp2;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    Vector getDestroyInterceptors() {
        return this.destroyInterceptors;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public String getErrorPage(int errorCode) {
        return this.getErrorPage(String.valueOf(errorCode));
    }

    public String getErrorPage(String errorCode) {
        return (String)this.errorPages.get(errorCode);
    }

    ServletContextFacade getFacade() {
        return this.contextFacade;
    }

    Vector getInitInterceptors() {
        return this.initInterceptors;
    }

    public String getInitParameter(String name) {
        return (String)this.initializationParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initializationParameters.keys();
    }

    public MimeMap getMimeMap() {
        return this.mimeTypes;
    }

    public String getPath() {
        return this.path;
    }

    private Properties getProperties(String propertyFileName) {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(propertyFileName));
        }
        catch (IOException iOException) {}
        return props;
    }

    public RequestSecurityProvider getRequestSecurityProvider() {
        return this.rsProvider;
    }

    Vector getServiceInterceptors() {
        return this.serviceInterceptors;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    File getWARDir() {
        return this.warDir;
    }

    public Enumeration getWelcomeFiles() {
        return this.welcomeFiles.elements();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void handleRequest(Request request, Response response) throws IOException {
        request.setContext(this);
        request.setResponse(response);
        ServerSession session = this.sessionManager.getServerSession(request, response, false);
        if (session != null) {
            session.accessed();
            ApplicationSession appSession = session.getApplicationSession(this, false);
            if (appSession != null) {
                appSession.accessed();
            }
        }
        request.setServerSession(session);
        LookupResult result = this.container.lookupServlet(request.getLookupPath());
        request.setServletPath(result.getServletPath());
        request.setPathInfo(result.getPathInfo());
        if (result.getResolvedServlet() != null) {
            request.setAttribute("org.apache.tomcat.servlet.resolved", result.getResolvedServlet());
        } else if (result.getMappedPath() != null) {
            request.setAttribute("org.apache.tomcat.servlet.resolved", result.getMappedPath());
        } else {
            request.removeAttribute("org.apache.tomcat.servlet.resolved");
        }
        result.getWrapper().handleRequest(request.getFacade(), response.getFacade());
    }

    public synchronized void init() {
        Object is;
        if (this.initialized) {
            String msg = this.sm.getString("context.init.alreadyinit");
            throw new IllegalStateException(msg);
        }
        this.initialized = true;
        if (this.workDir != null) {
            this.setAttribute("sun.servlet.workdir", this.workDir);
            if (!this.workDir.exists()) {
                this.workDir.mkdirs();
            }
        }
        URL servletBase = this.docBase;
        if (this.docBase.getProtocol().equalsIgnoreCase("war") && this.isWARExpanded()) {
            this.warDir = new File(this.getWorkDir(), "docBase");
            if (!this.warDir.exists()) {
                this.warDir.mkdirs();
                try {
                    WARUtil.expand(this.warDir, this.getDocumentBase());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
                try {
                    servletBase = URLUtil.resolve(this.warDir.toString());
                }
                catch (Exception exception) {}
            }
        }
        this.container.setServletBase(servletBase);
        int i2 = 0;
        while (i2 < Constants.Context.CLASS_PATHS.length) {
            this.container.addClassPath(Constants.Context.CLASS_PATHS[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < Constants.Context.LIB_PATHS.length) {
            this.container.addLibPath(Constants.Context.LIB_PATHS[i3]);
            ++i3;
        }
        try {
            Class<?> webApplicationDescriptor = Class.forName("org.apache.tomcat.deployment.WebApplicationDescriptor");
            InputStream is2 = webApplicationDescriptor.getResourceAsStream("web.xml");
            String msg = this.sm.getString("context.getConfig.msg", "default");
            this.processWebApp(is2, true);
        }
        catch (Exception exception) {
            String msg = this.sm.getString("context.getConfig.e", "default");
            System.out.println(msg);
        }
        String s2 = this.docBase.toString();
        if (this.docBase.getProtocol().equalsIgnoreCase("war")) {
            if (s2.endsWith("/")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            s2 = String.valueOf(s2) + "!/";
        }
        URL webURL = null;
        try {
            webURL = new URL(String.valueOf(s2) + "WEB-INF/web.xml");
            is = webURL.openConnection().getInputStream();
            String msg = this.sm.getString("context.getConfig.msg", webURL.toString());
            this.processWebApp((InputStream)is);
        }
        catch (Exception exception) {
            is = this.sm.getString("context.getConfig.e", webURL != null ? webURL.toString() : "not available");
        }
        if (!this.isInvokerEnabled) {
            this.container.addServlet("invoker", "org.apache.tomcat.core.NoInvokerServlet");
            this.container.addMapping("invoker", "/servlet");
        }
        if (!this.loadableServlets.isEmpty()) {
            this.loadServlets();
        }
    }

    public boolean isDistributable() {
        return this.isDistributable;
    }

    public boolean isInvokerEnabled() {
        return this.isInvokerEnabled;
    }

    public boolean isWARExpanded() {
        return this.isWARExpanded;
    }

    public boolean isWARValidated() {
        return this.isWARValidated;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent;
    }

    private void loadServlets() {
        Vector<Integer> orderedKeys = new Vector<Integer>();
        Enumeration<Object> e10 = this.loadableServlets.keys();
        while (e10.hasMoreElements()) {
            Integer key = (Integer)e10.nextElement();
            int slot = -1;
            int i2 = 0;
            while (i2 < orderedKeys.size()) {
                if (key < (Integer)orderedKeys.elementAt(i2)) {
                    slot = i2;
                    break;
                }
                ++i2;
            }
            if (slot > -1) {
                orderedKeys.insertElementAt(key, slot);
                continue;
            }
            orderedKeys.addElement(key);
        }
        int i3 = 0;
        while (i3 < orderedKeys.size()) {
            Integer key = (Integer)orderedKeys.elementAt(i3);
            e10 = ((Vector)this.loadableServlets.get(key)).elements();
            while (e10.hasMoreElements()) {
                String servletName = (String)e10.nextElement();
                ServletWrapper result = this.container.getServletByName(servletName);
                if (result == null) {
                    System.out.println("Warning: we try to load an undefined servlet " + servletName);
                }
                try {
                    if (result == null) continue;
                    result.loadServlet();
                }
                catch (Exception exception) {
                    String msg = this.sm.getString("context.loadServlet.e", servletName);
                    System.out.println(msg);
                }
            }
            ++i3;
        }
    }

    private void processDescription(String description) {
        this.description = description;
    }

    private void processDistributable(boolean isDistributable) {
        this.isDistributable = isDistributable;
    }

    private void processErrorPages(Enumeration errorPages) {
        while (errorPages.hasMoreElements()) {
            ErrorPageDescriptor errorPageDescriptor = (ErrorPageDescriptor)errorPages.nextElement();
            String key = null;
            key = errorPageDescriptor.getErrorCode() > -1 ? String.valueOf(errorPageDescriptor.getErrorCode()) : errorPageDescriptor.getExceptionType();
            this.errorPages.put(key, errorPageDescriptor.getLocation());
        }
    }

    private void processInitializationParameters(Enumeration contextParameters) {
        while (contextParameters.hasMoreElements()) {
            ContextParameter contextParameter = (ContextParameter)contextParameters.nextElement();
            this.initializationParameters.put(contextParameter.getName(), contextParameter.getValue());
        }
    }

    private void processMimeMaps(Enumeration mimeMaps) {
        while (mimeMaps.hasMoreElements()) {
            MimeMapping mimeMapping = (MimeMapping)mimeMaps.nextElement();
            this.mimeTypes.addContentType(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
    }

    private void processServlets(Enumeration servlets) {
        while (servlets.hasMoreElements()) {
            int loadOnStartUp;
            Vector<Object> v2;
            Integer key;
            WebComponentDescriptor webComponentDescriptor = (WebComponentDescriptor)servlets.nextElement();
            String name = webComponentDescriptor.getCanonicalName();
            String description = webComponentDescriptor.getDescription();
            String resourceName = null;
            boolean removeResource = false;
            if (webComponentDescriptor instanceof ServletDescriptor) {
                resourceName = ((ServletDescriptor)webComponentDescriptor).getClassName();
                if (this.container.containsServletByName(name)) {
                    String msg = this.sm.getString("context.dd.dropServlet", String.valueOf(name) + "(" + resourceName + ")");
                    System.out.println(msg);
                    removeResource = true;
                    this.container.removeServletByName(name);
                }
                this.container.addServlet(name, resourceName, description);
            } else if (webComponentDescriptor instanceof JspDescriptor) {
                resourceName = ((JspDescriptor)webComponentDescriptor).getJspFileName();
                if (!resourceName.startsWith("/")) {
                    resourceName = "/" + resourceName;
                }
                if (this.container.containsJSP(resourceName)) {
                    String msg = this.sm.getString("context.dd.dropServlet", resourceName);
                    System.out.println(msg);
                    removeResource = true;
                    this.container.removeJSP(resourceName);
                }
                this.container.addJSP(name, resourceName, description);
            }
            if (removeResource) {
                Enumeration enumeration = this.loadableServlets.keys();
                while (enumeration.hasMoreElements()) {
                    key = (Integer)enumeration.nextElement();
                    v2 = (Vector<Object>)this.loadableServlets.get(key);
                    Enumeration e10 = v2.elements();
                    Vector<String> buf = new Vector<String>();
                    while (e10.hasMoreElements()) {
                        String servletName = (String)e10.nextElement();
                        if (!this.container.containsServletByName(servletName)) continue;
                        buf.addElement(servletName);
                    }
                    this.loadableServlets.put(key, buf);
                }
            }
            if ((loadOnStartUp = webComponentDescriptor.getLoadOnStartUp()) > Integer.MIN_VALUE) {
                key = new Integer(loadOnStartUp);
                v2 = this.loadableServlets.containsKey(key) ? this.loadableServlets.get(key) : new Vector();
                v2.addElement(name);
                this.loadableServlets.put(key, v2);
            }
            Enumeration enumeration = webComponentDescriptor.getInitializationParameters();
            Hashtable<String, String> initializationParameters = new Hashtable<String, String>();
            while (enumeration.hasMoreElements()) {
                InitializationParameter initializationParameter = (InitializationParameter)enumeration.nextElement();
                initializationParameters.put(initializationParameter.getName(), initializationParameter.getValue());
            }
            this.container.setServletInitParams(webComponentDescriptor.getCanonicalName(), initializationParameters);
            enumeration = webComponentDescriptor.getUrlPatterns();
            while (enumeration.hasMoreElements()) {
                String msg;
                String mapping = (String)enumeration.nextElement();
                if (!mapping.startsWith("*.") && !mapping.startsWith("/")) {
                    mapping = "/" + mapping;
                }
                if (!this.container.containsServlet(mapping) && !this.container.containsJSP(mapping)) {
                    if (this.container.containsMapping(mapping)) {
                        msg = this.sm.getString("context.dd.dropMapping", mapping);
                        System.out.println(msg);
                        this.container.removeMapping(mapping);
                    }
                    this.container.addMapping(name, mapping);
                    continue;
                }
                msg = this.sm.getString("context.dd.ignoreMapping", mapping);
                System.out.println(msg);
            }
        }
    }

    private void processSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    private void processWebApp(InputStream is) {
        this.processWebApp(is, false);
    }

    private void processWebApp(InputStream is, boolean internal) {
        block2: {
            if (is == null) break block2;
            try {
                WebApplicationDescriptor webDescriptor = new WebApplicationReader().getDescriptor(is, new WebDescriptorFactoryImpl(), this.isWARValidated());
                this.processDescription(webDescriptor.getDescription());
                this.processDistributable(webDescriptor.isDistributable());
                this.processInitializationParameters(webDescriptor.getContextParameters());
                this.processSessionTimeOut(webDescriptor.getSessionTimeout());
                this.processServlets(webDescriptor.getWebComponentDescriptors());
                this.processMimeMaps(webDescriptor.getMimeMappings());
                this.processWelcomeFiles(webDescriptor.getWelcomeFiles(), internal);
                this.processErrorPages(webDescriptor.getErrorPageDescriptors());
            }
            catch (Throwable e10) {
                String msg = "config parse: " + e10.getMessage();
                System.out.println(msg);
            }
        }
    }

    private void processWelcomeFiles(Enumeration welcomeFiles) {
        this.processWelcomeFiles(welcomeFiles, false);
    }

    private void processWelcomeFiles(Enumeration welcomeFiles, boolean internal) {
        if (!internal && !this.welcomeFiles.isEmpty() && welcomeFiles.hasMoreElements()) {
            this.welcomeFiles.removeAllElements();
        }
        while (welcomeFiles.hasMoreElements()) {
            this.welcomeFiles.addElement(welcomeFiles.nextElement());
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassPath(String classPath) {
        if (this.classPath.trim().length() > 0) {
            this.classPath = String.valueOf(this.classPath) + File.pathSeparator;
        }
        this.classPath = String.valueOf(this.classPath) + classPath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDistributable(boolean isDistributable) {
        this.isDistributable = isDistributable;
    }

    public void setDocumentBase(URL docBase) {
        String file = docBase.getFile();
        if (!file.endsWith("/")) {
            try {
                docBase = new URL(docBase.getProtocol(), docBase.getHost(), docBase.getPort(), String.valueOf(file) + "/");
            }
            catch (MalformedURLException mue) {
                System.out.println("SHOULD NEVER HAPPEN: " + mue);
            }
        }
        this.docBase = docBase;
    }

    public void setInvokerEnabled(boolean isInvokerEnabled) {
        this.isInvokerEnabled = isInvokerEnabled;
    }

    public void setIsWARExpanded(boolean isWARExpanded) {
        this.isWARExpanded = isWARExpanded;
    }

    public void setIsWARValidated(boolean isWARValidated) {
        this.isWARValidated = isWARValidated;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRequestSecurityProvider(RequestSecurityProvider rsProvider) {
        this.rsProvider = rsProvider;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public void setWorkDir(File workDir, boolean isWorkDirPersistent) {
        this.isWorkDirPersistent = isWorkDirPersistent;
        if (workDir == null) {
            workDir = this.workDir;
        }
        if (!isWorkDirPersistent) {
            this.clearDir(workDir);
        }
        this.workDir = workDir;
        this.setAttribute("javax.servlet.context.tempdir", this.workDir);
    }

    public void setWorkDir(String workDir, boolean isWorkDirPersistent) {
        File f2 = null;
        try {
            f2 = new File(workDir);
        }
        catch (Exception exception) {}
        this.setWorkDir(f2, isWorkDirPersistent);
    }

    public void shutdown() {
        this.container.shutdown();
        this.sessionManager.removeApplicationSessions(this);
        if (!this.isWorkDirPersistent) {
            this.clearDir(this.workDir);
        }
        System.out.println("Context: " + this + " down");
    }
}

