/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Hashtable;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.ServletWrapper;

public class RequestMapper {
    private Container container = null;
    private Hashtable prefixMaps = null;
    private Hashtable extensionMaps = null;
    private Hashtable pathMaps = null;
    private String servletPath = null;
    private String mapPath = null;
    private String pathInfo = null;
    private String resourceName = null;

    RequestMapper(Container container) {
        this.container = container;
    }

    private ServletWrapper getExtensionMatch(String path) {
        ServletWrapper wrapper = null;
        int i2 = path.lastIndexOf(".");
        int j2 = path.lastIndexOf("/");
        if (i2 > -1) {
            int k2;
            String extension = path.substring(i2);
            if (j2 > i2) {
                k2 = extension.indexOf("/");
                extension = extension.substring(0, k2);
            }
            if ((wrapper = (ServletWrapper)this.extensionMaps.get("*" + extension)) != null) {
                this.servletPath = path;
                if (j2 > i2) {
                    k2 = i2 + path.substring(i2).indexOf("/");
                    String s2 = path.substring(0, k2);
                    this.servletPath = s2.trim().length() == 0 ? null : s2;
                    s2 = path.substring(k2);
                    this.pathInfo = s2.trim().length() == 0 ? null : s2;
                }
            }
        }
        return wrapper;
    }

    private String getMapPath(ServletWrapper wrapper) {
        String mapPath = this.mapPath;
        if (this.servletPath.equals("/servlet") && this.pathInfo != null) {
            int i2;
            String s2 = this.pathInfo;
            if (this.pathInfo.startsWith("/")) {
                s2 = this.pathInfo.substring(1);
            }
            if ((i2 = s2.indexOf("/")) > -1) {
                s2 = s2.substring(0, i2);
            }
            mapPath = "/" + s2;
        } else if (mapPath == null && this.resourceName != null) {
            mapPath = !wrapper.getServletClass().equals("org.apache.jasper.runtime.JspServlet") ? "/" + wrapper.getServletClass() : this.resourceName;
        }
        return mapPath;
    }

    private ServletWrapper getMatch(String path) {
        ServletWrapper wrapper = null;
        wrapper = this.getPathMatch(path);
        if (wrapper == null) {
            wrapper = this.getPrefixMatch(path);
        }
        if (wrapper == null) {
            wrapper = this.getExtensionMatch(path);
        }
        wrapper = this.getResolvedServlet(wrapper);
        return wrapper;
    }

    private ServletWrapper getPathMatch(String path) {
        ServletWrapper wrapper = null;
        wrapper = (ServletWrapper)this.pathMaps.get(path);
        if (wrapper != null) {
            this.servletPath = path;
        }
        return wrapper;
    }

    private ServletWrapper getPrefixMatch(String path) {
        ServletWrapper wrapper = null;
        String s2 = path;
        while (s2.length() > 0) {
            String suffix = s2.endsWith("/") ? "*" : "/*";
            wrapper = (ServletWrapper)this.prefixMaps.get(String.valueOf(s2) + suffix);
            if (wrapper != null) {
                String t2;
                if (s2.endsWith("/")) {
                    t2 = s2.substring(0, s2.length() - 1);
                    this.servletPath = t2.trim().length() == 0 ? null : t2;
                    t2 = s2.substring(s2.length() - 1);
                    this.pathInfo = t2.trim().length() == 0 ? null : t2;
                } else {
                    t2 = s2;
                    this.servletPath = t2.trim().length() == 0 ? null : t2;
                    t2 = path.substring(s2.length(), path.length());
                    this.pathInfo = t2.trim().length() == 0 ? null : t2;
                }
                s2 = "";
                continue;
            }
            int i2 = s2.lastIndexOf("/");
            s2 = i2 > 0 ? s2.substring(0, i2) : (i2 == 0 && !s2.equals("/") ? "/" : "");
        }
        return wrapper;
    }

    private String getResolvedServlet(String path) {
        String resolvedServlet = null;
        ServletWrapper[] sw = this.container.getServletsByPath(path);
        if (sw.length > 0) {
            resolvedServlet = sw[0].getServletName();
        }
        return resolvedServlet;
    }

    private ServletWrapper getResolvedServlet(ServletWrapper wrapper) {
        if (wrapper != null) {
            String servletPath = this.servletPath;
            String pathInfo = this.pathInfo;
            boolean stillSearching = true;
            int counter = 0;
            this.resourceName = this.servletPath;
            while (stillSearching) {
                if (wrapper != null && wrapper.getPath() != null && wrapper.getServletClass() == null) {
                    this.resourceName = wrapper.getPath();
                    wrapper = this.getMatch(String.valueOf(wrapper.getPath()) + (pathInfo == null ? "" : pathInfo));
                    this.mapPath = this.servletPath;
                    if (!stillSearching || ++counter <= 5) continue;
                    stillSearching = false;
                    continue;
                }
                stillSearching = false;
            }
            this.servletPath = servletPath;
            this.pathInfo = pathInfo;
        }
        return wrapper;
    }

    LookupResult lookupServlet(String path) {
        LookupResult lookupResult = null;
        ServletWrapper wrapper = this.getMatch(path);
        if (wrapper != null) {
            this.mapPath = this.getMapPath(wrapper);
            String resolvedServlet = this.getResolvedServlet(this.mapPath);
            lookupResult = new LookupResult(wrapper, this.servletPath, this.mapPath, this.pathInfo, resolvedServlet);
        }
        return lookupResult;
    }

    void setExtensionMaps(Hashtable extensionMaps) {
        this.extensionMaps = extensionMaps;
    }

    void setPathMaps(Hashtable pathMaps) {
        this.pathMaps = pathMaps;
    }

    void setPrefixMaps(Hashtable prefixMaps) {
        this.prefixMaps = prefixMaps;
    }
}

