/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.StringManager;

public class RequestUtil {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.core");

    public static final String URLDecode(String str) throws NumberFormatException, StringIndexOutOfBoundsException {
        if (str == null) {
            return null;
        }
        StringBuffer dec = new StringBuffer();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            int laPos = strPos;
            while (laPos < strLen) {
                char laChar = str.charAt(laPos);
                if (laChar == '+' || laChar == '%') break;
                ++laPos;
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            dec.append((char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16));
            strPos += 3;
        }
        return dec.toString();
    }

    public static String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        return encoding;
    }

    public static BufferedReader getReader(Request request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        InputStreamReader r2 = new InputStreamReader((InputStream)request.getInputStream(), encoding);
        return new BufferedReader(r2);
    }

    public static String getStatusString(int status) {
        return sm.getString("sc." + status);
    }

    public static Hashtable mergeParameters(Hashtable one, Hashtable two) {
        if (one.size() == 0) {
            return two;
        }
        if (two.size() == 0) {
            return one;
        }
        Hashtable combined = (Hashtable)one.clone();
        Enumeration e10 = two.keys();
        while (e10.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e10.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (oneValue == null) {
                combinedValue = twoValue;
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            combined.put(name, combinedValue);
        }
        return combined;
    }

    public static void processCookies(Request request, Vector cookies) {
        String cookieString = request.getHeader("cookie");
        if (cookieString != null) {
            StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int i2 = token.indexOf("=");
                if (i2 <= -1) continue;
                String name = token.substring(0, i2).trim();
                String value = token.substring(i2 + 1, token.length()).trim();
                Cookie cookie = new Cookie(name, value);
                cookies.addElement(cookie);
            }
        }
    }

    public static void processFormData(String data, Hashtable parameters) {
        if (data == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = RequestUtil.unUrlDecode(pair.substring(0, pos));
            String value = RequestUtil.unUrlDecode(pair.substring(pos + 1, pair.length()));
            if (parameters.containsKey(key)) {
                String[] oldValues = (String[])parameters.get(key);
                values = new String[oldValues.length + 1];
                int i2 = 0;
                while (i2 < oldValues.length) {
                    values[i2] = oldValues[i2];
                    ++i2;
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            parameters.put(key, values);
        }
    }

    public static int readData(InputStream in, byte[] buf, int length) {
        int read = 0;
        try {
            while ((read += in.read(buf, read, length - read)) < length && read != -1) {
            }
        }
        catch (IOException iOException) {}
        return read;
    }

    public static Hashtable readFormData(Request request) {
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        if (contentType != null && contentType.equals("application/x-www-form-urlencoded")) {
            try {
                ServletInputStream is = request.getInputStream();
                Hashtable postParameters = HttpUtils.parsePostData(contentLength, is);
                return postParameters;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static String unUrlDecode(String data) {
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < data.length()) {
            char c10 = data.charAt(i2);
            switch (c10) {
                case '+': {
                    buf.append(' ');
                    break;
                }
                case '%': {
                    try {
                        buf.append((char)Integer.parseInt(data.substring(i2 + 1, i2 + 3), 16));
                        i2 += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg = "Decode error ";
                        throw new IllegalArgumentException(msg);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String rest = data.substring(i2);
                        buf.append(rest);
                        if (rest.length() != 2) break;
                        ++i2;
                        break;
                    }
                }
                default: {
                    buf.append(c10);
                    break;
                }
            }
            ++i2;
        }
        return buf.toString();
    }
}

