/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.RequestDispatcherImpl;
import org.apache.tomcat.core.Server;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.StringManager;

public class ServletContextFacade
implements ServletContext {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Server server;
    private Context context;

    ServletContextFacade(Server server, Context context) {
        this.server = server;
        this.context = context;
    }

    public Object getAttribute(String name) {
        Object o2 = this.context.getAttribute(name);
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public ServletContext getContext(String path) {
        if (!path.startsWith("/")) {
            String msg = this.sm.getString("sfcacade.context.iae", path);
            throw new IllegalArgumentException(msg);
        }
        return this.server.getContextByPath(path).getFacade();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String filename) {
        return this.context.getMimeMap().getContentTypeFor(filename);
    }

    public int getMinorVersion() {
        return 2;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            String msg = this.sm.getString("scfacade.dispatcher.iae2", name);
            throw new IllegalArgumentException(msg);
        }
        RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(this.context);
        requestDispatcher.setName(name);
        return requestDispatcher.isValid() ? requestDispatcher : null;
    }

    public Context getRealContext() {
        return this.context;
    }

    public String getRealPath(String path) {
        String realPath = null;
        path = this.normPath(path);
        try {
            URL url = this.getResource(path);
            if (url != null) {
                if (url.getProtocol().equalsIgnoreCase("war")) {
                    if (this.context.isWARExpanded()) {
                        String spec = url.getFile();
                        if (spec.startsWith("/")) {
                            spec = spec.substring(1);
                        }
                        int separator = spec.indexOf(33);
                        URL warURL = null;
                        if (separator > -1) {
                            warURL = new URL(spec.substring(0, separator++));
                        }
                        if (warURL.getProtocol().equalsIgnoreCase("file")) {
                            String s2 = String.valueOf(String.valueOf(this.context.getWorkDir())) + "/" + "docBase" + path;
                            File f2 = new File(s2);
                            String absPath = f2.getAbsolutePath();
                            realPath = FileUtil.patch(absPath);
                        } else {
                            url.getProtocol().equalsIgnoreCase("http");
                        }
                    }
                } else if (!url.getProtocol().equalsIgnoreCase("http") && url.getProtocol().equalsIgnoreCase("file")) {
                    realPath = FileUtil.patch(url.getFile());
                }
            }
        }
        catch (Exception exception) {}
        return realPath;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/")) {
            String msg = this.sm.getString("scfacade.dispatcher.iae", path);
            throw new IllegalArgumentException(msg);
        }
        RequestDispatcherImpl requestDispatcher = new RequestDispatcherImpl(this.context);
        requestDispatcher.setPath(path);
        return requestDispatcher.isValid() ? requestDispatcher : null;
    }

    public URL getResource(String path) throws MalformedURLException {
        URL url = null;
        if (path == null) {
            String msg = this.sm.getString("scfacade.getresource.npe");
            throw new NullPointerException(msg);
        }
        if (!path.equals("") && !path.startsWith("/")) {
            String msg = this.sm.getString("scfacade.getresource.iae", path);
            throw new IllegalArgumentException(msg);
        }
        URL docBase = this.context.getDocumentBase();
        LookupResult lr = this.getRealContext().getContainer().lookupServlet(path);
        String mappedPath = path;
        if (lr != null && lr.getMappedPath() != null && lr.getMappedPath().trim().length() > 0) {
            mappedPath = lr.getMappedPath();
        }
        mappedPath = mappedPath.substring(1, mappedPath.length());
        if (path.equals("")) {
            url = docBase;
        } else if (docBase.getProtocol().equalsIgnoreCase("war")) {
            if (this.context.isWARExpanded()) {
                File f2 = new File(this.context.getWARDir().toString());
                String absPath = f2.getAbsolutePath();
                if (!(absPath = FileUtil.patch(absPath)).startsWith("/")) {
                    absPath = "/" + absPath;
                }
                url = new URL("file://localhost" + absPath + "/" + mappedPath);
            } else {
                String documentBase = this.context.getDocumentBase().toString();
                if (documentBase.endsWith("/")) {
                    documentBase = documentBase.substring(0, documentBase.length() - 1);
                }
                url = new URL(String.valueOf(documentBase) + "!" + mappedPath);
            }
        } else {
            url = new URL(docBase.getProtocol(), docBase.getHost(), docBase.getPort(), String.valueOf(docBase.getFile()) + mappedPath);
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        InputStream is = null;
        try {
            URL url = this.getResource(path);
            URLConnection con = url.openConnection();
            con.connect();
            is = con.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return is;
    }

    public String getServerInfo() {
        return this.server.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServletNames() {
        Vector v2 = new Vector();
        return v2.elements();
    }

    public Enumeration getServlets() {
        Vector v2 = new Vector();
        return v2.elements();
    }

    public void log(Exception e10, String msg) {
        this.log(msg, e10);
    }

    public void log(String msg) {
        System.err.println(msg);
    }

    public void log(String msg, Throwable t2) {
        System.err.println(msg);
        t2.printStackTrace(System.err);
    }

    private String normPath(String path) {
        int i2 = -1;
        while ((i2 = path.indexOf(92)) > -1) {
            String a = path.substring(0, i2);
            String b10 = "";
            if (i2 < path.length() - 1) {
                b10 = path.substring(i2 + 1);
            }
            path = String.valueOf(a) + "/" + b10;
        }
        return path;
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }
}

