/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.deployment;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.deployment.AuthorizationConstraint;
import org.apache.tomcat.deployment.Constants;
import org.apache.tomcat.deployment.ContextParameter;
import org.apache.tomcat.deployment.EjbReference;
import org.apache.tomcat.deployment.EnvironmentEntry;
import org.apache.tomcat.deployment.ErrorPageDescriptor;
import org.apache.tomcat.deployment.InitializationParameter;
import org.apache.tomcat.deployment.JspDescriptor;
import org.apache.tomcat.deployment.LoginConfiguration;
import org.apache.tomcat.deployment.MimeMapping;
import org.apache.tomcat.deployment.ResourceReference;
import org.apache.tomcat.deployment.SecurityConstraint;
import org.apache.tomcat.deployment.SecurityRole;
import org.apache.tomcat.deployment.SecurityRoleReference;
import org.apache.tomcat.deployment.ServletDescriptor;
import org.apache.tomcat.deployment.ServletDescriptorImpl;
import org.apache.tomcat.deployment.TagLibConfig;
import org.apache.tomcat.deployment.UserDataConstraint;
import org.apache.tomcat.deployment.WebApplicationDescriptor;
import org.apache.tomcat.deployment.WebComponentDescriptor;
import org.apache.tomcat.deployment.WebDescriptorFactory;
import org.apache.tomcat.deployment.WebResourceCollection;
import org.apache.tomcat.util.XMLParser;
import org.apache.tomcat.util.XMLTree;

public class WebApplicationReader {
    private WebDescriptorFactory factory = null;
    private WebApplicationDescriptor webApplicationDescriptor = null;
    private XMLTree config = null;
    private static final boolean DefaultXMLValidation = true;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$WebApplicationDescriptor;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$ContextParameter;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$TagLibConfig;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$ErrorPageDescriptor;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$ResourceReference;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$SecurityConstraint;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$WebResourceCollection;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$AuthorizationConstraint;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$SecurityRole;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$UserDataConstraint;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$LoginConfiguration;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$EnvironmentEntry;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$EjbReference;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$MimeMapping;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$ServletDescriptor;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$JspDescriptor;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$InitializationParameter;
    static /* synthetic */ Class class$org$apache$tomcat$deployment$SecurityRoleReference;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public WebApplicationDescriptor getDescriptor(InputStream inputStream, WebDescriptorFactory factory) throws Exception {
        return this.getDescriptor(inputStream, factory, true);
    }

    public WebApplicationDescriptor getDescriptor(InputStream inputStream, WebDescriptorFactory factory, boolean validate) throws Exception {
        if (inputStream == null) {
            String msg = "null inputStream";
            throw new NullPointerException(msg);
        }
        if (factory == null) {
            String msg = "null factory";
            throw new NullPointerException(msg);
        }
        this.factory = factory;
        try {
            this.config = new XMLParser().process(inputStream, validate);
        }
        catch (Exception e10) {
            String msg = "can't read config: " + e10.getMessage();
            throw new IllegalStateException(msg);
        }
        try {
            this.webApplicationDescriptor = (WebApplicationDescriptor)factory.createDescriptor(class$org$apache$tomcat$deployment$WebApplicationDescriptor != null ? class$org$apache$tomcat$deployment$WebApplicationDescriptor : (class$org$apache$tomcat$deployment$WebApplicationDescriptor = WebApplicationReader.class$("org.apache.tomcat.deployment.WebApplicationDescriptor")));
            if (!this.config.getName().equals("web-app")) {
                String msg = "parsing error";
                throw new IllegalStateException(msg);
            }
            this.processIcon();
            this.processDisplayName();
            this.processDescription();
            this.processDistributable();
            this.processContextParameters();
            this.processServlets();
            this.processServletMappings();
            this.processSessionTimeOut();
            this.processMIMEMappings();
            this.processWelcomeFiles();
            this.processErrorPages();
            this.processResourceReferences();
            this.processSecurityConstraints();
            this.processLoginConfig();
            this.processSecurityRoles();
            this.processEnvironmentEntries();
            this.processEjbReferences();
            this.processTagLibConfigs();
            return this.webApplicationDescriptor;
        }
        catch (Throwable t2) {
            String msg = "parsing error: " + t2.getMessage();
            throw new Exception(msg);
        }
    }

    private int getSessionTimeOut(Enumeration sessionTimeOuts) {
        Integer sessionTimeOut = new Integer(-1);
        while (sessionTimeOuts.hasMoreElements()) {
            XMLTree x2 = (XMLTree)sessionTimeOuts.nextElement();
            try {
                sessionTimeOut = new Integer(x2.getValue().trim());
            }
            catch (Exception exception) {}
        }
        return sessionTimeOut;
    }

    private WebComponentDescriptor getWebComponentDescriptorByName(String name) {
        Enumeration e10 = this.webApplicationDescriptor.getWebComponentDescriptors();
        while (e10.hasMoreElements()) {
            WebComponentDescriptor next = (WebComponentDescriptor)e10.nextElement();
            if (!next.getCanonicalName().equals(name)) continue;
            return next;
        }
        throw new RuntimeException("There is no web component by the name of " + name + " here.");
    }

    private Vector parseMIMEMappings(Enumeration mimeMaps) {
        Vector<MimeMapping> mimeMappings = new Vector<MimeMapping>();
        while (mimeMaps.hasMoreElements()) {
            XMLTree x2 = (XMLTree)mimeMaps.nextElement();
            String extension = null;
            String mimeType = null;
            Enumeration enumeration = x2.getElements("extension").elements();
            while (enumeration.hasMoreElements()) {
                extension = ((XMLTree)enumeration.nextElement()).getValue().trim();
            }
            enumeration = x2.getElements("mime-type").elements();
            while (enumeration.hasMoreElements()) {
                mimeType = ((XMLTree)enumeration.nextElement()).getValue().trim();
            }
            if (extension == null || extension.length() <= 0 || mimeType == null || mimeType.length() <= 0) continue;
            try {
                MimeMapping mimeMapping = (MimeMapping)this.factory.createDescriptor(class$org$apache$tomcat$deployment$MimeMapping != null ? class$org$apache$tomcat$deployment$MimeMapping : WebApplicationReader.class$("org.apache.tomcat.deployment.MimeMapping"));
                mimeMapping.setExtension(extension);
                mimeMapping.setMimeType(mimeType);
                mimeMappings.addElement(mimeMapping);
            }
            catch (Exception exception) {}
        }
        return mimeMappings;
    }

    private Vector parseServlets(Enumeration servlets, Enumeration servletMaps) {
        Enumeration e10;
        XMLTree x2;
        Vector<WebComponentDescriptor> webComponentDescriptors = new Vector<WebComponentDescriptor>();
        while (servlets.hasMoreElements()) {
            x2 = (XMLTree)servlets.nextElement();
            String name = null;
            String clazz = null;
            e10 = x2.getElements("servlet-name").elements();
            while (e10.hasMoreElements()) {
                name = ((XMLTree)e10.nextElement()).getValue().trim();
            }
            e10 = x2.getElements("servlet-class").elements();
            while (e10.hasMoreElements()) {
                clazz = ((XMLTree)e10.nextElement()).getValue().trim();
            }
            ServletDescriptorImpl servletDescriptor = new ServletDescriptorImpl(name, clazz);
            e10 = x2.getElements("init-param").elements();
            while (e10.hasMoreElements()) {
                XMLTree x1 = (XMLTree)e10.nextElement();
                String parameterName = null;
                String parameterValue = null;
                Enumeration e12 = x1.getElements("param-name").elements();
                while (e12.hasMoreElements()) {
                    parameterName = ((XMLTree)e12.nextElement()).getValue().trim();
                }
                e12 = x1.getElements("param-value").elements();
                while (e12.hasMoreElements()) {
                    parameterValue = ((XMLTree)e12.nextElement()).getValue().trim();
                }
                InitializationParameter ip = (InitializationParameter)this.factory.createDescriptor(class$org$apache$tomcat$deployment$InitializationParameter != null ? class$org$apache$tomcat$deployment$InitializationParameter : WebApplicationReader.class$("org.apache.tomcat.deployment.InitializationParameter"));
                ip.setName(parameterName);
                ip.setValue(parameterValue);
                servletDescriptor.addInitializationParameter(ip);
            }
            webComponentDescriptors.addElement(servletDescriptor);
        }
        while (servletMaps.hasMoreElements()) {
            x2 = (XMLTree)servletMaps.nextElement();
            String servletName = null;
            String map = null;
            e10 = x2.getElements("servlet-name").elements();
            while (e10.hasMoreElements()) {
                servletName = ((XMLTree)e10.nextElement()).getValue().trim();
            }
            e10 = x2.getElements("url-pattern").elements();
            while (e10.hasMoreElements()) {
                map = ((XMLTree)e10.nextElement()).getValue().trim();
            }
            if (servletName == null || servletName.length() <= 0 || map == null || map.length() <= 0) continue;
            WebComponentDescriptor webComponentDescriptor = null;
            Enumeration enumeration = webComponentDescriptors.elements();
            while (enumeration.hasMoreElements()) {
                WebComponentDescriptor wcd = (WebComponentDescriptor)enumeration.nextElement();
                if (!wcd.getName().equals(servletName)) continue;
                webComponentDescriptor = wcd;
                break;
            }
            if (webComponentDescriptor == null) {
                webComponentDescriptor = new ServletDescriptorImpl(servletName);
                webComponentDescriptors.addElement(webComponentDescriptor);
            }
            webComponentDescriptor.addUrlPattern(map);
        }
        return webComponentDescriptors;
    }

    private Vector parseWelcomeFiles(Enumeration welcomeFiles) {
        Vector<String> welcomeFilesV = new Vector<String>();
        while (welcomeFiles.hasMoreElements()) {
            XMLTree x2 = (XMLTree)welcomeFiles.nextElement();
            welcomeFilesV.addElement(x2.getValue().trim());
        }
        return welcomeFilesV;
    }

    private void processContextParameters() {
        Enumeration enumeration = this.config.elements(Constants.CONTEXT_PARAMETER);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ContextParameter param = (ContextParameter)this.factory.createDescriptor(class$org$apache$tomcat$deployment$ContextParameter != null ? class$org$apache$tomcat$deployment$ContextParameter : WebApplicationReader.class$("org.apache.tomcat.deployment.ContextParameter"));
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                param.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            param.setName(next.getFirstElement("param-name").getValue());
            param.setValue(next.getFirstElement("param-value").getValue());
            this.webApplicationDescriptor.addContextParameter(param);
        }
    }

    private void processDescription() {
        XMLTree descriptionTree = this.config.getFirstElement(Constants.DESCRIPTION);
        if (descriptionTree != null) {
            this.webApplicationDescriptor.setDescription(descriptionTree.getValue());
        }
    }

    private void processDisplayName() {
        XMLTree displayNameTree = this.config.getFirstElement(Constants.DISPLAY_NAME);
        if (displayNameTree != null) {
            this.webApplicationDescriptor.setName(displayNameTree.getValue());
        }
    }

    private void processDistributable() {
        this.webApplicationDescriptor.setDistributable(this.config.getFirstElement(Constants.DISTRIBUTABLE) != null);
    }

    private void processEjbReferences() {
        Enumeration enumeration = this.config.elements(Constants.EJB_REFERENCE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            EjbReference ejbr = (EjbReference)this.factory.createDescriptor(class$org$apache$tomcat$deployment$EjbReference != null ? class$org$apache$tomcat$deployment$EjbReference : WebApplicationReader.class$("org.apache.tomcat.deployment.EjbReference"));
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                ejbr.setName(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            ejbr.setName(next.getFirstElement(Constants.EJB_NAME).getValue());
            ejbr.setType(next.getFirstElement(Constants.EJB_TYPE).getValue());
            ejbr.setHomeClassName(next.getFirstElement(Constants.EJB_HOME).getValue());
            ejbr.setRemoteClassName(next.getFirstElement(Constants.EJB_REMOTE).getValue());
            if (next.getFirstElement(Constants.EJB_LINK) != null) {
                ejbr.setLinkName(next.getFirstElement(Constants.EJB_LINK).getValue());
            }
            this.webApplicationDescriptor.addEjbReference(ejbr);
        }
    }

    private void processEnvironmentEntries() {
        Enumeration enumeration = this.config.elements(Constants.ENVIRONMENT_ENTRY);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            EnvironmentEntry ee2 = (EnvironmentEntry)this.factory.createDescriptor(class$org$apache$tomcat$deployment$EnvironmentEntry != null ? class$org$apache$tomcat$deployment$EnvironmentEntry : WebApplicationReader.class$("org.apache.tomcat.deployment.EnvironmentEntry"));
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                ee2.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            ee2.setName(next.getFirstElement(Constants.ENVIRONMENT_NAME).getValue());
            if (next.getFirstElement(Constants.ENVIRONMENT_VALUE) != null) {
                ee2.setValue(next.getFirstElement(Constants.ENVIRONMENT_VALUE).getValue());
            }
            ee2.setType(next.getFirstElement(Constants.ENVIRONMENT_TYPE).getValue());
            this.webApplicationDescriptor.addEnvironmentEntry(ee2);
        }
    }

    private void processErrorPages() {
        Enumeration enumeration = this.config.elements(Constants.ERROR_PAGE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ErrorPageDescriptor epd = (ErrorPageDescriptor)this.factory.createDescriptor(class$org$apache$tomcat$deployment$ErrorPageDescriptor != null ? class$org$apache$tomcat$deployment$ErrorPageDescriptor : WebApplicationReader.class$("org.apache.tomcat.deployment.ErrorPageDescriptor"));
            if (next.getFirstElement(Constants.ERROR_CODE) != null) {
                Integer errorCode = new Integer(next.getFirstElement(Constants.ERROR_CODE).getValue());
                epd.setErrorCode(errorCode);
            } else if (next.getFirstElement(Constants.EXCEPTION_TYPE) != null) {
                epd.setExceptionType(next.getFirstElement(Constants.EXCEPTION_TYPE).getValue());
            }
            epd.setLocation(next.getFirstElement(Constants.LOCATION).getValue());
            this.webApplicationDescriptor.addErrorPageDescriptor(epd);
        }
    }

    private void processIcon() {
        XMLTree iconTree = this.config.getFirstElement(Constants.ICON);
        if (iconTree != null) {
            XMLTree largeIconTree;
            XMLTree smallIconTree = iconTree.getFirstElement(Constants.SMALL_ICON);
            if (smallIconTree != null) {
                this.webApplicationDescriptor.setSmallIconUri(smallIconTree.getValue());
            }
            if ((largeIconTree = iconTree.getFirstElement(Constants.LARGE_ICON)) != null) {
                this.webApplicationDescriptor.setLargeIconUri(largeIconTree.getValue());
            }
        }
    }

    private void processLoginConfig() {
        XMLTree flTree = this.config.getFirstElement(Constants.LOGIN_CONFIG);
        if (flTree != null) {
            LoginConfiguration lc = (LoginConfiguration)this.factory.createDescriptor(class$org$apache$tomcat$deployment$LoginConfiguration != null ? class$org$apache$tomcat$deployment$LoginConfiguration : (class$org$apache$tomcat$deployment$LoginConfiguration = WebApplicationReader.class$("org.apache.tomcat.deployment.LoginConfiguration")));
            if (flTree.getFirstElement(Constants.AUTH_METHOD) != null) {
                lc.setAuthenticationMethod(flTree.getFirstElement(Constants.AUTH_METHOD).getValue());
            }
            if (flTree.getFirstElement(Constants.REALM_NAME) != null) {
                lc.setRealmName(flTree.getFirstElement(Constants.REALM_NAME).getValue());
            }
            if (flTree.getFirstElement(Constants.FORM_LOGIN_CONFIG) != null) {
                XMLTree formTree = flTree.getFirstElement(Constants.FORM_LOGIN_CONFIG);
                lc.setFormLoginPage(formTree.getFirstElement(Constants.FORM_LOGIN_PAGE).getValue());
                lc.setFormErrorPage(formTree.getFirstElement(Constants.FORM_ERROR_PAGE).getValue());
            }
            this.webApplicationDescriptor.setLoginConfiguration(lc);
        }
    }

    private void processMIMEMappings() {
        Enumeration enumeration = this.parseMIMEMappings(this.config.elements("mime-mapping")).elements();
        try {
            while (enumeration.hasMoreElements()) {
                this.webApplicationDescriptor.addMimeMapping((MimeMapping)enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            System.out.println("parser error: MIMEMappings");
        }
    }

    private void processResourceReferences() {
        Enumeration enumeration = this.config.elements(Constants.RESOURCE_REFERENCE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            ResourceReference rrd = (ResourceReference)this.factory.createDescriptor(class$org$apache$tomcat$deployment$ResourceReference != null ? class$org$apache$tomcat$deployment$ResourceReference : WebApplicationReader.class$("org.apache.tomcat.deployment.ResourceReference"));
            rrd.setName(next.getFirstElement(Constants.RESOURCE_REFERENCE_NAME).getValue());
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                rrd.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            rrd.setType(next.getFirstElement(Constants.RESOURCE_TYPE).getValue());
            rrd.setAuthorization(next.getFirstElement(Constants.RESOURCE_AUTHORIZATION).getValue());
            this.webApplicationDescriptor.addResourceReference(rrd);
        }
    }

    private void processSecurityConstraints() {
        Enumeration e10 = this.config.elements(Constants.SECURITY_CONSTRAINT);
        while (e10.hasMoreElements()) {
            XMLTree udcTree;
            XMLTree scTree = (XMLTree)e10.nextElement();
            SecurityConstraint sc = (SecurityConstraint)this.factory.createDescriptor(class$org$apache$tomcat$deployment$SecurityConstraint != null ? class$org$apache$tomcat$deployment$SecurityConstraint : WebApplicationReader.class$("org.apache.tomcat.deployment.SecurityConstraint"));
            Enumeration ee2 = scTree.elements(Constants.WEB_RESOURCE_COLLECTION);
            while (ee2.hasMoreElements()) {
                XMLTree wrcTree = (XMLTree)ee2.nextElement();
                WebResourceCollection wrc = (WebResourceCollection)this.factory.createDescriptor(class$org$apache$tomcat$deployment$WebResourceCollection != null ? class$org$apache$tomcat$deployment$WebResourceCollection : WebApplicationReader.class$("org.apache.tomcat.deployment.WebResourceCollection"));
                wrc.setName(wrcTree.getFirstElement(Constants.WEB_RESOURCE_NAME).getValue());
                if (wrcTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    wrc.setDescription(wrcTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                Enumeration eee = wrcTree.elements(Constants.URL_PATTERN);
                while (eee.hasMoreElements()) {
                    XMLTree upTree = (XMLTree)eee.nextElement();
                    wrc.addUrlPattern(upTree.getValue());
                }
                Enumeration eee2 = wrcTree.elements(Constants.HTTP_METHOD);
                while (eee2.hasMoreElements()) {
                    XMLTree hmTree = (XMLTree)eee2.nextElement();
                    wrc.addHttpMethod(hmTree.getValue());
                }
                sc.addWebResourceCollection(wrc);
            }
            XMLTree acTree = scTree.getFirstElement(Constants.AUTH_CONSTRAINT);
            if (acTree != null) {
                AuthorizationConstraint ac2 = (AuthorizationConstraint)this.factory.createDescriptor(class$org$apache$tomcat$deployment$AuthorizationConstraint != null ? class$org$apache$tomcat$deployment$AuthorizationConstraint : WebApplicationReader.class$("org.apache.tomcat.deployment.AuthorizationConstraint"));
                if (acTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    ac2.setDescription(acTree.getFirstElement(Constants.DESCRIPTION).getValue());
                    Enumeration eeee = acTree.elements(Constants.ROLE_NAME);
                    while (eeee.hasMoreElements()) {
                        XMLTree roleNameTree = (XMLTree)eeee.nextElement();
                        SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$org$apache$tomcat$deployment$SecurityRole != null ? class$org$apache$tomcat$deployment$SecurityRole : WebApplicationReader.class$("org.apache.tomcat.deployment.SecurityRole"));
                        sr.setName(roleNameTree.getValue());
                        ac2.addSecurityRole(sr);
                    }
                }
                sc.setAuthorizationConstraint(ac2);
            }
            if ((udcTree = scTree.getFirstElement(Constants.USERDATA_CONSTRAINT)) != null) {
                UserDataConstraint udc = (UserDataConstraint)this.factory.createDescriptor(class$org$apache$tomcat$deployment$UserDataConstraint != null ? class$org$apache$tomcat$deployment$UserDataConstraint : WebApplicationReader.class$("org.apache.tomcat.deployment.UserDataConstraint"));
                if (udcTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    udc.setDescription(udcTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                udc.setTransportGuarantee(udcTree.getFirstElement(Constants.TRANSPORT_GUARANTEE).getValue());
                sc.setUserDataConstraint(udc);
            }
            this.webApplicationDescriptor.addSecurityConstraint(sc);
        }
    }

    private void processSecurityRoles() {
        Enumeration enumeration = this.config.elements(Constants.SECURITY_ROLE);
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$org$apache$tomcat$deployment$SecurityRole != null ? class$org$apache$tomcat$deployment$SecurityRole : WebApplicationReader.class$("org.apache.tomcat.deployment.SecurityRole"));
            if (next.getFirstElement(Constants.DESCRIPTION) != null) {
                sr.setDescription(next.getFirstElement(Constants.DESCRIPTION).getValue());
            }
            sr.setName(next.getFirstElement(Constants.ROLE_NAME).getValue());
            this.webApplicationDescriptor.addSecurityRole(sr);
        }
    }

    private void processServletMappings() {
        Enumeration enumeration = this.config.elements("servlet-mapping");
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            WebComponentDescriptor descriptor = this.getWebComponentDescriptorByName(next.getFirstElement("servlet-name").getValue());
            descriptor.addUrlPattern(next.getFirstElement("url-pattern").getValue());
        }
    }

    private void processServlets() {
        Enumeration enumeration = this.config.elements("servlet");
        while (enumeration.hasMoreElements()) {
            XMLTree descriptionTree;
            XMLTree displayNameTree;
            XMLTree next = (XMLTree)enumeration.nextElement();
            WebComponentDescriptor descriptor = null;
            if (next.getFirstElement("servlet-class") != null) {
                descriptor = (ServletDescriptor)this.factory.createDescriptor(class$org$apache$tomcat$deployment$ServletDescriptor != null ? class$org$apache$tomcat$deployment$ServletDescriptor : WebApplicationReader.class$("org.apache.tomcat.deployment.ServletDescriptor"));
                descriptor.setClassName(next.getFirstElement("servlet-class").getValue());
            } else {
                descriptor = (JspDescriptor)this.factory.createDescriptor(class$org$apache$tomcat$deployment$JspDescriptor != null ? class$org$apache$tomcat$deployment$JspDescriptor : WebApplicationReader.class$("org.apache.tomcat.deployment.JspDescriptor"));
                ((JspDescriptor)descriptor).setJspFileName(next.getFirstElement(Constants.JSP_FILENAME).getValue());
            }
            if (next.getFirstElement(Constants.LOAD_ON_START_UP) != null) {
                Integer loadOnStartUp = new Integer(Integer.MAX_VALUE);
                try {
                    loadOnStartUp = new Integer(next.getFirstElement(Constants.LOAD_ON_START_UP).getValue());
                }
                catch (NumberFormatException numberFormatException) {}
                descriptor.setLoadOnStartUp(loadOnStartUp);
            }
            Enumeration initParamTrees = next.getElements("init-param").elements();
            while (initParamTrees.hasMoreElements()) {
                XMLTree paramTree = (XMLTree)initParamTrees.nextElement();
                Object parameterName = null;
                Object parameterValue = null;
                InitializationParameter ip = (InitializationParameter)this.factory.createDescriptor(class$org$apache$tomcat$deployment$InitializationParameter != null ? class$org$apache$tomcat$deployment$InitializationParameter : WebApplicationReader.class$("org.apache.tomcat.deployment.InitializationParameter"));
                ip.setName(paramTree.getFirstElement("param-name").getValue());
                ip.setValue(paramTree.getFirstElement("param-value").getValue());
                if (paramTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    ip.setDescription(paramTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                descriptor.addInitializationParameter(ip);
            }
            Enumeration roleRefsTree = next.getElements(Constants.SECURITY_ROLE_REFERENCE).elements();
            while (roleRefsTree.hasMoreElements()) {
                XMLTree roleRefTree = (XMLTree)roleRefsTree.nextElement();
                SecurityRoleReference srr = (SecurityRoleReference)this.factory.createDescriptor(class$org$apache$tomcat$deployment$SecurityRoleReference != null ? class$org$apache$tomcat$deployment$SecurityRoleReference : WebApplicationReader.class$("org.apache.tomcat.deployment.SecurityRoleReference"));
                if (roleRefTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    srr.setDescription(roleRefTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                SecurityRole sr = (SecurityRole)this.factory.createDescriptor(class$org$apache$tomcat$deployment$SecurityRole != null ? class$org$apache$tomcat$deployment$SecurityRole : WebApplicationReader.class$("org.apache.tomcat.deployment.SecurityRole"));
                sr.setName(roleRefTree.getFirstElement(Constants.ROLE_LINK).getValue());
                srr.setSecurityRoleLink(sr);
                srr.setRolename(roleRefTree.getFirstElement(Constants.ROLE_NAME).getValue());
                if (roleRefTree.getFirstElement(Constants.DESCRIPTION) != null) {
                    srr.setDescription(roleRefTree.getFirstElement(Constants.DESCRIPTION).getValue());
                }
                descriptor.addSecurityRoleReference(srr);
            }
            XMLTree iconTree = next.getFirstElement(Constants.ICON);
            if (iconTree != null) {
                XMLTree largeIconTree;
                XMLTree smallIconTree = iconTree.getFirstElement(Constants.SMALL_ICON);
                if (smallIconTree != null) {
                    descriptor.setSmallIconUri(smallIconTree.getValue());
                }
                if ((largeIconTree = iconTree.getFirstElement(Constants.LARGE_ICON)) != null) {
                    descriptor.setLargeIconUri(largeIconTree.getValue());
                }
            }
            if ((displayNameTree = next.getFirstElement(Constants.DISPLAY_NAME)) != null) {
                descriptor.setName(displayNameTree.getValue());
            }
            if ((descriptionTree = next.getFirstElement(Constants.DESCRIPTION)) != null) {
                descriptor.setDescription(descriptionTree.getValue());
            }
            descriptor.setCanonicalName(next.getFirstElement("servlet-name").getValue());
            this.webApplicationDescriptor.addWebComponentDescriptor(descriptor);
        }
    }

    private void processSessionTimeOut() {
        if (this.config.getFirstElement("session-config") != null) {
            this.webApplicationDescriptor.setSessionTimeout(this.getSessionTimeOut(this.config.getFirstElement("session-config").elements("session-timeout")));
        }
    }

    private void processTagLibConfigs() {
        Enumeration enumeration = this.config.elements("taglib");
        while (enumeration.hasMoreElements()) {
            XMLTree next = (XMLTree)enumeration.nextElement();
            TagLibConfig config = (TagLibConfig)this.factory.createDescriptor(class$org$apache$tomcat$deployment$TagLibConfig != null ? class$org$apache$tomcat$deployment$TagLibConfig : WebApplicationReader.class$("org.apache.tomcat.deployment.TagLibConfig"));
            config.setTagLibURI(next.getFirstElement("taglib-uri").getValue());
            config.setTagLibLocation(next.getFirstElement("taglib-location").getValue());
            this.webApplicationDescriptor.addTagLibConfig(config);
        }
    }

    private void processWelcomeFiles() {
        XMLTree wflTree = this.config.getFirstElement("welcome-file-list");
        if (wflTree != null) {
            Enumeration enumeration = wflTree.elements("welcome-file");
            while (enumeration.hasMoreElements()) {
                XMLTree next = (XMLTree)enumeration.nextElement();
                this.webApplicationDescriptor.addWelcomeFile(next.getValue());
            }
        }
    }
}

