/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestAdapterImpl;
import org.apache.tomcat.service.MessageConnector;
import org.apache.tomcat.util.BuffTool;

class Ajp22Request
extends RequestAdapterImpl {
    MessageConnector proto;
    Hashtable env_vars;

    public Ajp22Request(MessageConnector proto) {
        this.proto = proto;
    }

    public String getRemoteAddr() {
        return (String)this.env_vars.get("REMOTE_ADDR");
    }

    public String getRemoteHost() {
        return (String)this.env_vars.get("REMOTE_ADDR");
    }

    public int getServerPort() {
        String sport = (String)this.env_vars.get("SERVER_PORT");
        if (sport == null) {
            sport = "80";
        }
        return new Integer(sport);
    }

    protected int readNextRequest() throws IOException {
        this.in = new BufferedServletInputStream(this);
        this.env_vars = new Hashtable();
        int rd = this.proto.readPacket();
        if (rd <= 0) {
            return -1;
        }
        byte[] buff = this.proto.buff;
        int pos = 0;
        int reqType = BuffTool.getInt(buff, pos);
        int envCount = BuffTool.getInt(buff, pos += 2);
        pos += 2;
        int i2 = 0;
        while (i2 < envCount) {
            int nlen = BuffTool.getInt(buff, pos);
            String n2 = BuffTool.getString(buff, pos + 2, nlen);
            int vlen = BuffTool.getInt(buff, pos += 3 + nlen);
            String v2 = BuffTool.getString(buff, pos + 2, vlen);
            pos += 3 + vlen;
            this.env_vars.put(n2, v2);
            ++i2;
        }
        int hCount = BuffTool.getInt(buff, pos);
        pos += 2;
        int i3 = 0;
        while (i3 < hCount) {
            int nlen = BuffTool.getInt(buff, pos);
            String n3 = BuffTool.getString(buff, pos + 2, nlen);
            int vlen = BuffTool.getInt(buff, pos += 3 + nlen);
            String v3 = BuffTool.getString(buff, pos + 2, vlen);
            pos += 3 + vlen;
            this.headers.putHeader(n3.toLowerCase(), v3);
            ++i3;
        }
        this.setInternalVars();
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        return 0;
    }

    public void recycle() {
        super.recycle();
    }

    private void setInternalVars() {
        String hostHeader;
        this.method = (String)this.env_vars.get("REQUEST_METHOD");
        this.protocol = (String)this.env_vars.get("SERVER_PROTOCOL");
        this.requestURI = (String)this.env_vars.get("REQUEST_URI");
        this.queryString = (String)this.env_vars.get("QUERY_STRING");
        if (this.requestURI == null) {
            this.requestURI = "xxx";
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
        if ((hostHeader = this.getHeader("host")) != null) {
            int i2 = hostHeader.indexOf(58);
            if (i2 > -1) {
                hostHeader = hostHeader.substring(0, i2);
            }
            this.serverName = hostHeader;
        } else {
            this.serverName = "localhost";
        }
    }
}

