/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.connector.AJP12RequestAdapter;
import org.apache.tomcat.service.connector.AJP12ResponseAdapter;
import org.apache.tomcat.util.StringManager;

public class Ajp12ConnectionHandler
implements TcpConnectionHandler {
    StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    ContextManager contextM;

    public Object[] init() {
        return null;
    }

    public void processConnection(TcpConnection connection, Object[] theData) {
        try {
            Socket socket = connection.getSocket();
            socket.setSoLinger(true, 100);
            Request request = new Request();
            AJP12RequestAdapter reqA = new AJP12RequestAdapter(socket);
            Response response = new Response();
            AJP12ResponseAdapter resA = new AJP12ResponseAdapter();
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            request.setRequestAdapter(reqA);
            response.setResponseAdapter(resA);
            resA.setOutputStream(socket.getOutputStream());
            request.setResponse(response);
            response.setRequest(request);
            reqA.readNextRequest();
            if (response.getStatus() >= 400) {
                response.finish();
                socket.close();
                return;
            }
            int contentLength = request.getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)request.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(request, response);
            response.finish();
            socket.close();
        }
        catch (Exception e10) {
            System.out.println("HANDLER THREAD PROBLEM: " + e10);
            e10.printStackTrace();
        }
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setContextManager(ContextManager contextM) {
        this.contextM = contextM;
    }
}

