/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.ResponseAdapter;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;

public class HttpResponseAdapter
implements ResponseAdapter {
    protected OutputStream sout;
    protected StringBuffer statusSB = new StringBuffer();
    protected StringBuffer headersSB = new StringBuffer();
    static final String encoding = "ISO-8859-1";
    static final byte[] CRLF = new byte[]{13, 10};

    public void addHeader(String name, String value) throws IOException {
        this.headersSB.setLength(0);
        this.headersSB.append(name).append(": ").append(value).append("\r\n");
        this.sout.write(this.headersSB.toString().getBytes(encoding));
    }

    public void addMimeHeaders(MimeHeaders headers) throws IOException {
        this.headersSB.setLength(0);
        int size = headers.size();
        int i2 = 0;
        while (i2 < size) {
            MimeHeaderField h2 = headers.getField(i2);
            this.headersSB.append(h2).append("\r\n");
            ++i2;
        }
        this.sout.write(this.headersSB.toString().getBytes(encoding));
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.sout.write(buffer, pos, count);
    }

    public void endHeaders() throws IOException {
        this.sout.write(CRLF, 0, 2);
    }

    public void endResponse() throws IOException {
        this.sout.flush();
    }

    public ServletOutputStream getServletOutputStream() throws IOException {
        return null;
    }

    public void recycle() {
        this.sout = null;
        this.statusSB.setLength(0);
        this.headersSB.setLength(0);
    }

    public void setOutputStream(OutputStream os) {
        this.sout = os;
    }

    public void setStatus(int status, String message) throws IOException {
        this.statusSB.append("HTTP/1.0 ").append(status);
        if (message != null) {
            this.statusSB.append(" ").append(message);
        }
        this.statusSB.append("\r\n");
        this.sout.write(this.statusSB.toString().getBytes(encoding));
        this.statusSB.setLength(0);
    }
}

