/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import org.apache.tomcat.util.StringManager;

public class Ascii {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];

    static {
        int i2 = 0;
        while (i2 < 256) {
            Ascii.toUpper[i2] = (byte)i2;
            Ascii.toLower[i2] = (byte)i2;
            ++i2;
        }
        int lc = 97;
        while (lc <= 122) {
            int uc = lc + 65 - 97;
            Ascii.toUpper[lc] = (byte)uc;
            Ascii.toLower[uc] = (byte)lc;
            Ascii.isAlpha[lc] = true;
            Ascii.isAlpha[uc] = true;
            Ascii.isLower[lc] = true;
            Ascii.isUpper[uc] = true;
            ++lc;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        int d10 = 48;
        while (d10 <= 57) {
            Ascii.isDigit[d10] = true;
            ++d10;
        }
    }

    public static boolean isAlpha(int c10) {
        return isAlpha[c10 & 0xFF];
    }

    public static boolean isDigit(int c10) {
        return isDigit[c10 & 0xFF];
    }

    public static boolean isLower(int c10) {
        return isLower[c10 & 0xFF];
    }

    public static boolean isUpper(int c10) {
        return isUpper[c10 & 0xFF];
    }

    public static boolean isWhite(int c10) {
        return isWhite[c10 & 0xFF];
    }

    public static int parseInt(byte[] b10, int off, int len) throws NumberFormatException {
        byte c10;
        if (b10 == null || len <= 0 || !Ascii.isDigit(c10 = b10[off++])) {
            StringManager sm = StringManager.getManager("org.apache.tomcat.util");
            String msg = sm.getString("ascii.parseInit.nfe", (Object)b10);
            throw new NumberFormatException(msg);
        }
        int n2 = c10 - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c10 = b10[off++])) {
                StringManager sm = StringManager.getManager("org.apache.tomcat.util");
                String msg = sm.getString("ascii.parseInit.nfe", (Object)b10);
                throw new NumberFormatException(msg);
            }
            n2 = n2 * 10 + c10 - 48;
        }
        return n2;
    }

    public static int toLower(int c10) {
        return toLower[c10 & 0xFF] & 0xFF;
    }

    public static int toUpper(int c10) {
        return toUpper[c10 & 0xFF] & 0xFF;
    }
}

