/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MessageString;
import org.apache.tomcat.util.StringManager;

public class MimeHeaderField {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    protected final MessageString name = new MessageString();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected final HttpDate dateValue = new HttpDate(0L);
    protected int type = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public int getBytes(byte[] buf, int buf_offset) {
        int start_pt = buf_offset;
        buf_offset += this.name.getBytes(buf, buf_offset);
        buf[buf_offset++] = 58;
        buf[buf_offset++] = 32;
        switch (this.type) {
            case 1: {
                buf_offset += this.value.getBytes(buf, buf_offset);
                break;
            }
            case 2: {
                buf_offset += this.intGetBytes(this.intValue, buf, buf_offset);
                break;
            }
            case 3: {
                buf_offset += this.dateValue.getBytes(buf, buf_offset, HttpDate.DATELEN);
                break;
            }
        }
        buf[buf_offset++] = 13;
        buf[buf_offset++] = 10;
        return buf_offset - start_pt;
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 3: {
                return this.dateValue.getTime();
            }
            case 1: {
                return this.value.toDate(this.dateValue);
            }
        }
        String msg = this.sm.getString("mimeHeaderField.date.iae");
        throw new IllegalArgumentException(msg);
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
        }
        String msg = this.sm.getString("mimeHeaderField.int.nfe");
        throw new NumberFormatException(msg);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return this.dateValue.toString();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int intGetBytes(int target, byte[] buf, int offset) {
        power = 1000000000;
        bytes_emitted = 0;
        if (target != 0) ** GOTO lbl11
        buf[offset] = MimeHeaderField.charval[0];
        return 1;
lbl-1000:
        // 1 sources

        {
            this_digit = target / power;
            if (this_digit != 0 || bytes_emitted > 0) {
                buf[offset + bytes_emitted++] = MimeHeaderField.charval[this_digit];
            }
            target %= power;
            power /= 10;
lbl11:
            // 2 sources

            ** while (power > 0)
        }
lbl12:
        // 1 sources

        return bytes_emitted;
    }

    public boolean nameEquals(String s2) {
        return this.name.equalsIgnoreCase(s2);
    }

    public boolean nameEquals(byte[] b10, int off, int len) {
        return this.name.equalsIgnoreCase(b10, off, len);
    }

    public void parse(byte[] b10, int off, int len) throws IllegalArgumentException {
        byte c10;
        int start = off;
        while ((c10 = b10[off++]) != 58 && c10 != 32) {
            if (c10 != 10) continue;
            String msg = this.sm.getString("mimeHeaderField.header.iae");
            throw new IllegalArgumentException(msg);
        }
        this.setName(b10, start, off - start - 1);
        while (c10 == 32) {
            c10 = b10[off++];
        }
        if (c10 != 58) {
            String msg = this.sm.getString("mimeHeaderField.header.iae");
            throw new IllegalArgumentException(msg);
        }
        while ((c10 = b10[off++]) == 32) {
        }
        this.setValue(b10, off - 1, len - (off - start - 1));
    }

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.type = 0;
    }

    public void setDateValue() {
        this.dateValue.setTime();
        this.type = 3;
    }

    public void setDateValue(long t2) {
        this.dateValue.setTime(t2);
        this.type = 3;
    }

    public void setIntValue(int i2) {
        this.intValue = i2;
        this.type = 2;
    }

    public void setName(String s2) {
        this.name.setString(s2);
    }

    public void setName(byte[] b10, int off, int len) {
        this.name.setBytes(b10, off, len);
    }

    public void setValue(String s2) {
        this.value.setString(s2);
        this.type = 1;
    }

    public void setValue(byte[] b10, int off, int len) {
        this.value.setBytes(b10, off, len);
        this.type = 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name.toString());
        sb.append(": ");
        switch (this.type) {
            case 1: {
                sb.append(this.value.toString());
                break;
            }
            case 2: {
                sb.append(this.intValue);
                break;
            }
            case 3: {
                sb.append(this.dateValue.toString());
                break;
            }
        }
        return sb.toString();
    }

    public void write(ServletOutputStream out) throws IOException {
        this.name.write(out);
        out.print(": ");
        switch (this.type) {
            case 1: {
                this.value.write(out);
                out.println();
                break;
            }
            case 2: {
                out.println(this.intValue);
                break;
            }
            case 3: {
                this.dateValue.write(out);
                out.println();
                break;
            }
            default: {
                out.println();
            }
        }
    }
}

