/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeadersEnumerator;
import org.apache.tomcat.util.StringManager;

public class MimeHeaders {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private byte[] buf;

    public MimeHeaders() {
        this(512);
    }

    public MimeHeaders(int len) {
        this.buf = new byte[len];
    }

    public void addDateHeader(String name) {
        this.addHeader(name).setDateValue();
    }

    public void addDateHeader(String name, long t2) {
        this.addHeader(name).setDateValue(t2);
    }

    protected MimeHeaderField addHeader(String name) {
        MimeHeaderField mh = this.putHeader();
        mh.setName(name);
        return mh;
    }

    public void addHeader(String name, String s2) {
        this.addHeader(name).setValue(s2);
    }

    public void addIntHeader(String name, int i2) {
        this.addHeader(name).setIntValue(i2);
    }

    public void appendHeader(String name, String s2) {
        MimeHeaderField mh = this.putHeader();
        mh.setName(name);
        mh.setValue(s2);
    }

    public void clear() {
        int i2 = 0;
        while (i2 < this.count) {
            this.headers[i2].reset();
            ++i2;
        }
        this.count = 0;
    }

    public boolean containsHeader(String name) {
        return this.find(name) != null;
    }

    public void dump(PrintStream out) {
        int i2 = 0;
        while (i2 < this.count) {
            out.println(this.headers[i2]);
            ++i2;
        }
    }

    protected MimeHeaderField find(String name) {
        int i2 = 0;
        while (i2 < this.count) {
            if (this.headers[i2].nameEquals(name)) {
                return this.headers[i2];
            }
            ++i2;
        }
        return null;
    }

    public int getAll(byte[] buf, int buf_offset) {
        int start_pt = buf_offset;
        int i2 = 0;
        while (i2 < this.count) {
            buf_offset += this.headers[i2].getBytes(buf, buf_offset);
            ++i2;
        }
        return buf_offset - start_pt;
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getDateValue() : -1L;
    }

    public MimeHeaderField getField(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2] : null;
    }

    public int getFieldCount(String name) {
        int retval = 0;
        int i2 = 0;
        while (i2 < this.count) {
            if (this.headers[i2].nameEquals(name)) {
                ++retval;
            }
            ++i2;
        }
        return retval;
    }

    public String getHeader(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getValue() : null;
    }

    public String getHeader(String name) {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getValue() : null;
    }

    public String getHeaderName(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getName() : null;
    }

    public String[] getHeaders(String name) {
        Vector values = this.getHeadersVector(name);
        if (values.size() > 0) {
            String[] retval = new String[values.size()];
            int i2 = 0;
            while (i2 < retval.length) {
                retval[i2] = (String)values.elementAt(i2);
                ++i2;
            }
            return retval;
        }
        return null;
    }

    public Vector getHeadersVector(String name) {
        Vector<String> values = new Vector<String>();
        int i2 = 0;
        while (i2 < this.count) {
            if (this.headers[i2].nameEquals(name)) {
                values.addElement(this.headers[i2].getValue());
            }
            ++i2;
        }
        return values;
    }

    public int getIntHeader(String name) throws NumberFormatException {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getIntValue() : -1;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putDateHeader(String name) {
        this.putHeader(name).setDateValue();
    }

    public void putDateHeader(String name, long t2) {
        this.putHeader(name).setDateValue(t2);
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mh;
        int len = this.headers.length;
        if (this.count >= len) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    protected MimeHeaderField putHeader(String name) {
        if (this.containsHeader(name)) {
            this.removeHeader(name);
        }
        return this.addHeader(name);
    }

    public void putHeader(String name, String s2) {
        this.putHeader(name).setValue(s2);
    }

    public void putIntHeader(String name, int i2) {
        this.putHeader(name).setIntValue(i2);
    }

    public void read(ServletInputStream in) throws IOException {
        byte[] b10 = this.count == 0 ? this.buf : new byte[this.buf.length];
        int off = 0;
        while (true) {
            int start = off;
            while (true) {
                int len;
                if ((len = b10.length - off) > 0 && (len = in.readLine(b10, off, len)) == -1) {
                    String msg = this.sm.getString("mimeHeader.connection.ioe");
                    throw new IOException(msg);
                }
                if (len == 0 || b10[(off += len) - 1] == 10) break;
                byte[] tmp = new byte[b10.length * 2];
                System.arraycopy(b10, 0, tmp, 0, b10.length);
                b10 = tmp;
            }
            if (--off > start && b10[off - 1] == 13) {
                --off;
            }
            if (off == start) break;
            this.putHeader().parse(b10, start, off - start);
        }
    }

    public void removeHeader(String name) {
        int i2 = 0;
        while (i2 < this.count) {
            if (this.headers[i2].nameEquals(name)) {
                MimeHeaderField mh = this.headers[i2];
                mh.reset();
                this.headers[i2] = this.headers[this.count - 1];
                this.headers[this.count - 1] = mh;
                --this.count;
                --i2;
            }
            ++i2;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int i2 = 0;
        while (i2 < this.count) {
            sb.append("{");
            sb.append(this.headers[i2].toString());
            sb.append("}");
            if (i2 < this.count - 1) {
                sb.append(",");
            }
            ++i2;
        }
        sb.append("}");
        return sb.toString();
    }

    public void write(ServletOutputStream out) throws IOException {
        int i2 = 0;
        while (i2 < this.count) {
            this.headers[i2].write(out);
            ++i2;
        }
        out.println();
    }
}

