/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.Names;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.javac.SourceClass;
import sun.tools.util.CommandLine;

public class Main
implements Constants {
    String sourcePathArg;
    String sysClassPathArg;
    String extDirsArg;
    String classPathString;
    File destDir;
    int flags;
    long tm;
    Vector classes;
    boolean nowrite;
    boolean nocompile;
    boolean keepGenerated;
    boolean status;
    String[] generatorArgs;
    Vector generators;
    Class environmentClass = class$sun$rmi$rmic$BatchEnvironment != null ? class$sun$rmi$rmic$BatchEnvironment : (class$sun$rmi$rmic$BatchEnvironment = Main.class$("sun.rmi.rmic.BatchEnvironment"));
    boolean iiopGeneration = false;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;
    private static ResourceBundle resourcesExt;
    static /* synthetic */ Class class$sun$rmi$rmic$BatchEnvironment;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$sun$tools$java$ClassPath;
    static /* synthetic */ Class class$sun$rmi$rmic$Main;

    static {
        resourcesExt = null;
    }

    public Main(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
    }

    protected Generator addGenerator(String string) {
        Generator generator;
        String string2 = Main.getString("generator.class." + string);
        if (string2 == null) {
            this.error("rmic.missing.property", string);
            return null;
        }
        try {
            generator = (Generator)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            this.error("rmic.cannot.instantiate", string2);
            return null;
        }
        this.generators.addElement(generator);
        Class clazz = class$sun$rmi$rmic$BatchEnvironment != null ? class$sun$rmi$rmic$BatchEnvironment : (class$sun$rmi$rmic$BatchEnvironment = Main.class$("sun.rmi.rmic.BatchEnvironment"));
        String string3 = Main.getString("generator.env." + string);
        if (string3 != null) {
            try {
                clazz = Class.forName(string3);
                if (this.environmentClass.isAssignableFrom(clazz)) {
                    this.environmentClass = clazz;
                } else if (!clazz.isAssignableFrom(this.environmentClass)) {
                    this.error("rmic.cannot.use.both", this.environmentClass.getName(), clazz.getName());
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.error("rmic.class.not.found", string3);
                return null;
            }
        }
        if (string.equals("iiop")) {
            this.iiopGeneration = true;
        }
        return generator;
    }

    protected boolean checkGeneratorArg(String[] stringArray, int n2) {
        boolean bl2 = true;
        if (stringArray[n2].startsWith("-")) {
            String string = stringArray[n2].substring(1).toLowerCase();
            int n3 = 0;
            while (n3 < this.generatorArgs.length) {
                if (string.equalsIgnoreCase(this.generatorArgs[n3])) {
                    Generator generator = this.addGenerator(string);
                    if (generator == null) {
                        return false;
                    }
                    bl2 = generator.parseArgs(stringArray, this);
                    break;
                }
                ++n3;
            }
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized boolean compile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.classes.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    public void compileAllClasses(BatchEnvironment batchEnvironment) throws ClassNotFound, IOException, InterruptedException {
        boolean bl2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        do {
            bl2 = true;
            Enumeration enumeration = batchEnvironment.getClasses();
            while (enumeration.hasMoreElements()) {
                ClassDeclaration classDeclaration = (ClassDeclaration)enumeration.nextElement();
                bl2 = this.compileClass(classDeclaration, byteArrayOutputStream, batchEnvironment);
            }
        } while (!bl2);
    }

    public boolean compileClass(ClassDeclaration classDeclaration, ByteArrayOutputStream byteArrayOutputStream, BatchEnvironment batchEnvironment) throws ClassNotFound, IOException, InterruptedException {
        boolean bl2 = true;
        batchEnvironment.flushErrors();
        switch (classDeclaration.getStatus()) {
            case 0: {
                if (!batchEnvironment.dependencies()) break;
            }
            case 3: {
                bl2 = false;
                batchEnvironment.loadDefinition(classDeclaration);
                if (classDeclaration.getStatus() != 4) break;
            }
            case 4: {
                if (classDeclaration.getClassDefinition().isInsideLocal()) break;
                if (this.nocompile) {
                    throw new IOException("Compilation required, but -Xnocompile option in effect");
                }
                bl2 = false;
                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition((Environment)batchEnvironment);
                sourceClass.check((Environment)batchEnvironment);
                classDeclaration.setDefinition((ClassDefinition)sourceClass, 5);
            }
            case 5: {
                Object object;
                File file;
                SourceClass sourceClass = (SourceClass)classDeclaration.getClassDefinition((Environment)batchEnvironment);
                if (sourceClass.getError()) {
                    classDeclaration.setDefinition((ClassDefinition)sourceClass, 6);
                    break;
                }
                bl2 = false;
                byteArrayOutputStream.reset();
                sourceClass.compile((OutputStream)byteArrayOutputStream);
                classDeclaration.setDefinition((ClassDefinition)sourceClass, 6);
                sourceClass.cleanup((Environment)batchEnvironment);
                if (sourceClass.getError() || this.nowrite) break;
                String string = classDeclaration.getName().getQualifier().toString().replace('.', File.separatorChar);
                String string2 = String.valueOf(classDeclaration.getName().getFlatName().toString().replace('.', '$')) + ".class";
                if (this.destDir != null) {
                    if (string.length() > 0) {
                        file = new File(this.destDir, string);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        file = new File(file, string2);
                    } else {
                        file = new File(this.destDir, string2);
                    }
                } else {
                    object = (ClassFile)sourceClass.getSource();
                    if (object.isZipped()) {
                        batchEnvironment.error(0L, "cant.write", object.getPath());
                        break;
                    }
                    file = new File(object.getPath());
                    file = new File(file.getParent(), string2);
                }
                try {
                    object = new FileOutputStream(file.getPath());
                    byteArrayOutputStream.writeTo((OutputStream)object);
                    ((FileOutputStream)object).close();
                    if (!batchEnvironment.verbose()) break;
                    this.output(Main.getText("rmic.wrote", file.getPath()));
                }
                catch (IOException iOException) {
                    batchEnvironment.error(0L, "cant.write", file.getPath());
                }
                break;
            }
        }
        return bl2;
    }

    public boolean doCompile() {
        Object object;
        BatchEnvironment batchEnvironment;
        block19: {
            batchEnvironment = this.getEnv();
            batchEnvironment.flags |= this.flags;
            batchEnvironment.majorVersion = (short)45;
            batchEnvironment.minorVersion = (short)3;
            String string = Main.getText("rmic.no.memory");
            String string2 = Main.getText("rmic.stack.overflow");
            try {
                int n2 = this.classes.size() - 1;
                while (n2 >= 0) {
                    object = Identifier.lookup((String)((String)this.classes.elementAt(n2)));
                    object = batchEnvironment.resolvePackageQualifiedName((Identifier)object);
                    object = Names.mangleClass(object);
                    ClassDeclaration classDeclaration = batchEnvironment.getClassDeclaration((Identifier)object);
                    try {
                        ClassDefinition classDefinition = classDeclaration.getClassDefinition((Environment)batchEnvironment);
                        int n3 = 0;
                        while (n3 < this.generators.size()) {
                            Generator generator = (Generator)this.generators.elementAt(n3);
                            generator.generate(batchEnvironment, classDefinition, this.destDir);
                            ++n3;
                        }
                    }
                    catch (ClassNotFound classNotFound) {
                        batchEnvironment.error(0L, "rmic.class.not.found", object);
                    }
                    --n2;
                }
                if (!this.nocompile) {
                    this.compileAllClasses(batchEnvironment);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                batchEnvironment.output(string);
                return false;
            }
            catch (StackOverflowError stackOverflowError) {
                batchEnvironment.output(string2);
                return false;
            }
            catch (Error error) {
                if (batchEnvironment.nerrors == 0 || batchEnvironment.dump()) {
                    error.printStackTrace();
                    batchEnvironment.error(0L, "fatal.error");
                }
            }
            catch (Exception exception) {
                if (batchEnvironment.nerrors != 0 && !batchEnvironment.dump()) break block19;
                exception.printStackTrace();
                batchEnvironment.error(0L, "fatal.exception");
            }
        }
        batchEnvironment.flushErrors();
        boolean bl2 = true;
        if (batchEnvironment.nerrors > 0) {
            object = "";
            object = batchEnvironment.nerrors > 1 ? Main.getText("rmic.errors", batchEnvironment.nerrors) : Main.getText("rmic.1error");
            if (batchEnvironment.nwarnings > 0) {
                object = batchEnvironment.nwarnings > 1 ? String.valueOf(object) + ", " + Main.getText("rmic.warnings", batchEnvironment.nwarnings) : String.valueOf(object) + ", " + Main.getText("rmic.1warning");
            }
            this.output((String)object);
            bl2 = false;
        } else if (batchEnvironment.nwarnings > 0) {
            if (batchEnvironment.nwarnings > 1) {
                this.output(Main.getText("rmic.warnings", batchEnvironment.nwarnings));
            } else {
                this.output(Main.getText("rmic.1warning"));
            }
        }
        if (!this.keepGenerated) {
            batchEnvironment.deleteGeneratedFiles();
        }
        if (batchEnvironment.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        batchEnvironment.shutdown();
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.extDirsArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.classes = null;
        this.generatorArgs = null;
        this.generators = null;
        this.environmentClass = null;
        this.program = null;
        this.out = null;
        return bl2;
    }

    public void error(String string) {
        this.output(Main.getText(string));
    }

    public void error(String string, String string2) {
        this.output(Main.getText(string, string2));
    }

    public void error(String string, String string2, String string3) {
        this.output(Main.getText(string, string2, string3));
    }

    protected String[] getArray(String string, boolean bl2) {
        String[] stringArray = null;
        String string2 = Main.getString(string);
        if (string2 == null) {
            if (bl2) {
                this.error("rmic.resource.not.found", string);
                return null;
            }
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n\r", false);
        int n2 = stringTokenizer.countTokens();
        stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    public File getDestinationDir() {
        return this.destDir;
    }

    public BatchEnvironment getEnv() {
        ClassPath classPath = BatchEnvironment.createClassPath(this.classPathString);
        BatchEnvironment batchEnvironment = null;
        try {
            Class[] classArray = new Class[]{class$java$io$OutputStream != null ? class$java$io$OutputStream : (class$java$io$OutputStream = Main.class$("java.io.OutputStream")), class$sun$tools$java$ClassPath != null ? class$sun$tools$java$ClassPath : (class$sun$tools$java$ClassPath = Main.class$("sun.tools.java.ClassPath")), class$sun$rmi$rmic$Main != null ? class$sun$rmi$rmic$Main : (class$sun$rmi$rmic$Main = Main.class$("sun.rmi.rmic.Main"))};
            Object[] objectArray = new Object[]{this.out, classPath, this};
            Constructor constructor = this.environmentClass.getConstructor(classArray);
            batchEnvironment = (BatchEnvironment)((Object)constructor.newInstance(objectArray));
            batchEnvironment.reset();
        }
        catch (Exception exception) {
            this.error("rmic.cannot.instantiate", this.environmentClass.getName());
        }
        return batchEnvironment;
    }

    public static String getString(String string) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        if (resourcesExt != null) {
            try {
                return resourcesExt.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getText(String string) {
        String string2 = Main.getString(string);
        if (string2 == null) {
            string2 = "no text found: \"" + string + "\"";
        }
        return string2;
    }

    public static String getText(String string, int n2) {
        return Main.getText(string, Integer.toString(n2), null, null);
    }

    public static String getText(String string, String string2) {
        return Main.getText(string, string2, null, null);
    }

    public static String getText(String string, String string2, String string3) {
        return Main.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        String string5 = Main.getString(string);
        if (string5 == null) {
            string5 = "no text found: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        Object[] objectArray = new String[]{string2 != null ? string2.toString() : "null", string3 != null ? string3.toString() : "null", string4 != null ? string4.toString() : "null"};
        return MessageFormat.format(string5, objectArray);
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmic");
            resourcesInitialized = true;
            try {
                resourcesExt = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmicext");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("fatal: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, "rmic");
        System.exit(main.compile(stringArray) ? 0 : 1);
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseArgs(String[] stringArray) {
        this.sourcePathArg = null;
        this.sysClassPathArg = null;
        this.extDirsArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.classes = new Vector();
        this.nowrite = false;
        this.nocompile = false;
        this.keepGenerated = false;
        this.generatorArgs = this.getArray("generator.args", true);
        if (this.generatorArgs == null) {
            return false;
        }
        this.generators = new Vector();
        try {
            stringArray = CommandLine.parse((String[])stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("rmic.cant.read", fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                if (stringArray[n2].equals("-g")) {
                    this.flags &= 0xFFFFBFFF;
                    this.flags |= 0x3000;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-O")) {
                    this.flags &= 0xFFFFEFFF;
                    this.flags &= 0xFFFFDFFF;
                    this.flags |= 0x4020;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-nowarn")) {
                    this.flags &= 0xFFFFFFFB;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-debug")) {
                    this.flags |= 2;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-depend")) {
                    this.flags |= 0x20;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-verbose")) {
                    this.flags |= 1;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-nowrite")) {
                    this.nowrite = true;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-Xnocompile")) {
                    this.nocompile = true;
                    this.keepGenerated = true;
                    stringArray[n2] = null;
                } else if (stringArray[n2].equals("-keep") || stringArray[n2].equals("-keepgenerated")) {
                    this.keepGenerated = true;
                    stringArray[n2] = null;
                } else {
                    if (stringArray[n2].equals("-show")) {
                        this.error("rmic.option.unsupported", "-show");
                        this.usage();
                        return false;
                    }
                    if (stringArray[n2].equals("-classpath")) {
                        if (n2 + 1 >= stringArray.length) {
                            this.error("rmic.option.requires.argument", "-classpath");
                            this.usage();
                            return false;
                        }
                        if (this.classPathString != null) {
                            this.error("rmic.option.already.seen", "-classpath");
                            this.usage();
                            return false;
                        }
                        stringArray[n2] = null;
                        this.classPathString = stringArray[++n2];
                        stringArray[n2] = null;
                    } else if (stringArray[n2].equals("-sourcepath")) {
                        if (n2 + 1 >= stringArray.length) {
                            this.error("rmic.option.requires.argument", "-sourcepath");
                            this.usage();
                            return false;
                        }
                        if (this.sourcePathArg != null) {
                            this.error("rmic.option.already.seen", "-sourcepath");
                            this.usage();
                            return false;
                        }
                        stringArray[n2] = null;
                        this.sourcePathArg = stringArray[++n2];
                        stringArray[n2] = null;
                    } else if (stringArray[n2].equals("-bootclasspath")) {
                        if (n2 + 1 >= stringArray.length) {
                            this.error("rmic.option.requires.argument", "-bootclasspath");
                            this.usage();
                            return false;
                        }
                        if (this.sysClassPathArg != null) {
                            this.error("rmic.option.already.seen", "-bootclasspath");
                            this.usage();
                            return false;
                        }
                        stringArray[n2] = null;
                        this.sysClassPathArg = stringArray[++n2];
                        stringArray[n2] = null;
                    } else if (stringArray[n2].equals("-extdirs")) {
                        if (n2 + 1 >= stringArray.length) {
                            this.error("rmic.option.requires.argument", "-extdirs");
                            this.usage();
                            return false;
                        }
                        if (this.extDirsArg != null) {
                            this.error("rmic.option.already.seen", "-extdirs");
                            this.usage();
                            return false;
                        }
                        stringArray[n2] = null;
                        this.extDirsArg = stringArray[++n2];
                        stringArray[n2] = null;
                    } else if (stringArray[n2].equals("-d")) {
                        if (n2 + 1 >= stringArray.length) {
                            this.error("rmic.option.requires.argument", "-d");
                            this.usage();
                            return false;
                        }
                        if (this.destDir != null) {
                            this.error("rmic.option.already.seen", "-d");
                            this.usage();
                            return false;
                        }
                        stringArray[n2] = null;
                        this.destDir = new File(stringArray[++n2]);
                        stringArray[n2] = null;
                        if (!this.destDir.exists()) {
                            this.error("rmic.no.such.directory", this.destDir.getPath());
                            this.usage();
                            return false;
                        }
                    } else if (!this.checkGeneratorArg(stringArray, n2)) {
                        this.usage();
                        return false;
                    }
                }
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null) {
                if (stringArray[n3].startsWith("-")) {
                    this.error("rmic.no.such.option", stringArray[n3]);
                    this.usage();
                    return false;
                }
                this.classes.addElement(stringArray[n3]);
            }
            ++n3;
        }
        if (this.generators.size() == 0) {
            this.addGenerator("default");
        }
        return true;
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }
}

