/*
 * Decompiled with CFR 0.152.
 */
package iDSS;

import iDSS.GridManager;
import iDSS.LCGridManager;
import iDSS.Status;
import iDSS.VerticalSlider;
import iDSS.beans2.StatusJBean;
import iDSS.disp.DisplayFrame;
import iDSS.grids.Grid;
import iDSS.grids.LCGrid2;
import iDSS.sim.Simulation;
import iDSS.slr.ScenarioList;
import iDSS.sm.SurvivalModelsList;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TidalModelsList;
import iDSS.tidalData.TidalStationsLocal;
import iDSS.utils.CustomVector;
import iDSS.utils.IDSSAppConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ModelSetupTree
extends JFrame
implements PropertyChangeListener {
    private DefaultTreeModel treeModel;
    private DisplayFrame rootPanel;
    private JScrollPane panelView;
    private JScrollPane treeView;
    private JSplitPane splitPane;
    private boolean playWithLineStyle = false;
    private String lineStyle = "Angled";
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Model Setup Tree");
    private DefaultMutableTreeNode dem;
    private DefaultMutableTreeNode landcover;
    private DefaultMutableTreeNode tidalData;
    private DefaultMutableTreeNode isostaticMovement;
    private DefaultMutableTreeNode vegetationModel;
    private DefaultMutableTreeNode slrScenario;
    private DefaultMutableTreeNode modelStatus;
    private DefaultMutableTreeNode simStatus;
    private CustomVector visibleVector;
    private CustomVector demRemoteVector;
    private CustomVector landcoverRemoteVector;
    private CustomVector tidalDataLocalStationsVector;
    private CustomVector vmRemoteVector;
    private CustomVector isostaticVector;
    private CustomVector slrRemoteVector;
    private CustomVector tidalModelsListVector;
    private CustomVector statusVector;
    private CustomVector simVector;
    private GridManager demRemoteGM;
    private LCGridManager landcoverRemoteGM;
    private TidalStationsLocal tidalDataLocalStations;
    private TidalModelsList tidalModelsList;
    private VerticalSlider isostaticMovementSlider;
    private SurvivalModelsList smList;
    private ScenarioList scenarioList;
    private Status status;
    private StatusJBean statusJBean;
    private Simulation simulation;
    private DefaultMutableTreeNode demRemote;
    private DefaultMutableTreeNode landcoverRemote;
    private DefaultMutableTreeNode tidalDataLocal;
    private DefaultMutableTreeNode vegetationModelRemote;
    private DefaultMutableTreeNode isostaticMovementLocal;
    private DefaultMutableTreeNode slrRemote;
    private DefaultMutableTreeNode tidalModels;
    private DefaultMutableTreeNode statusLocal;
    private DefaultMutableTreeNode simLocal;

    public ModelSetupTree(String string, int n, int n2) {
        super(string);
        this.treeModel = new DefaultTreeModel(this.top);
        this.createNodes();
        final JTree jTree = new JTree(this.treeModel);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (defaultMutableTreeNode.isLeaf()) {
                    CustomVector customVector = (CustomVector)object;
                    ModelSetupTree.this.removeAllFromModelView();
                    ModelSetupTree.this.addToModelView(customVector);
                    ModelSetupTree.this.visibleVector = customVector;
                } else {
                    ModelSetupTree.this.removeAllFromModelView();
                    ModelSetupTree.this.addToModelView(ModelSetupTree.this.rootPanel);
                }
                if (IDSSAppConstants.debug) {
                    System.out.println(object.toString());
                }
            }
        });
        if (this.playWithLineStyle) {
            jTree.putClientProperty("JTree.lineStyle", this.lineStyle);
        }
        this.treeView = new JScrollPane(jTree);
        this.panelView = new JScrollPane();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(this.treeView);
        this.splitPane.setBottomComponent(this.panelView);
        Dimension dimension = new Dimension(100, 50);
        this.panelView.setMinimumSize(dimension);
        this.treeView.setMinimumSize(dimension);
        this.splitPane.setDividerLocation(100);
        this.splitPane.setPreferredSize(new Dimension(n, n2));
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.initialize();
        ((Component)this).setSize(new Dimension(n, n2));
        ((Component)this).setVisible(true);
    }

    public void createNodes() {
        this.rootPanel = new DisplayFrame("Text : rootPanel", true, true, true, true, null);
        this.demRemoteVector = new CustomVector("modelSetupDemRemote");
        this.demRemoteGM = new GridManager();
        this.demRemoteVector.add(this.demRemoteGM);
        this.demRemote = new DefaultMutableTreeNode(this.demRemoteVector);
        this.landcoverRemoteVector = new CustomVector("modelSetupLandcoverRemote");
        this.landcoverRemoteGM = new LCGridManager();
        this.landcoverRemoteVector.add(this.landcoverRemoteGM);
        this.landcoverRemote = new DefaultMutableTreeNode(this.landcoverRemoteVector);
        this.tidalDataLocalStationsVector = new CustomVector("modelSetupTidalDataLocal");
        this.tidalDataLocalStations = new TidalStationsLocal("modelSetupTidalDataLocal");
        this.tidalDataLocalStationsVector.add(this.tidalDataLocalStations);
        this.tidalDataLocal = new DefaultMutableTreeNode(this.tidalDataLocalStationsVector);
        this.tidalModelsListVector = new CustomVector("Defined Tidal Models");
        this.tidalModelsList = new TidalModelsList("Defined Tidal Models");
        this.tidalModelsListVector.add(this.tidalModelsList);
        this.tidalModels = new DefaultMutableTreeNode(this.tidalModelsListVector);
        this.vmRemoteVector = new CustomVector("modelSetupVegetationModelRemote");
        this.smList = new SurvivalModelsList("Defined Survival Models");
        this.vmRemoteVector.add(this.smList);
        this.vegetationModelRemote = new DefaultMutableTreeNode(this.vmRemoteVector);
        this.isostaticVector = new CustomVector("modelSetupIsostaticLocal");
        this.isostaticMovementSlider = new VerticalSlider("Select Isostatic Movement", -50, 50, 0, "mm/year", null);
        this.isostaticVector.add(this.isostaticMovementSlider);
        this.isostaticMovementLocal = new DefaultMutableTreeNode(this.isostaticVector);
        this.slrRemoteVector = new CustomVector("modelSetupSlrRemote");
        this.scenarioList = new ScenarioList("SLREJB");
        this.slrRemoteVector.add(this.scenarioList);
        this.slrRemote = new DefaultMutableTreeNode(this.slrRemoteVector);
        this.statusVector = new CustomVector("modelSetupStatus");
        this.status = new Status();
        this.statusVector.add(this.status);
        this.statusLocal = new DefaultMutableTreeNode(this.statusVector);
        this.dem = new DefaultMutableTreeNode("Digital Elevation Model");
        this.top.add(this.dem);
        this.landcover = new DefaultMutableTreeNode("Landcover Types");
        this.top.add(this.landcover);
        this.tidalData = new DefaultMutableTreeNode("Tidal Data");
        this.top.add(this.tidalData);
        this.isostaticMovement = new DefaultMutableTreeNode("Isostatic Movement");
        this.top.add(this.isostaticMovement);
        this.vegetationModel = new DefaultMutableTreeNode("Vegetation Models");
        this.top.add(this.vegetationModel);
        this.slrScenario = new DefaultMutableTreeNode("SLR Scenario");
        this.top.add(this.slrScenario);
        this.modelStatus = new DefaultMutableTreeNode("modelSetupStatus");
        this.top.add(this.modelStatus);
        this.dem.add(this.demRemote);
        this.landcover.add(this.landcoverRemote);
        this.tidalData.add(this.tidalDataLocal);
        this.tidalData.add(this.tidalModels);
        this.vegetationModel.add(this.vegetationModelRemote);
        this.isostaticMovement.add(this.isostaticMovementLocal);
        this.slrScenario.add(this.slrRemote);
        this.modelStatus.add(this.statusLocal);
    }

    public void createSimNode(Grid grid, LCGrid2 lCGrid2, Hashtable hashtable, int n, ClientDataSet clientDataSet) {
        System.out.println("ModelSetupTree.createSimNode(), Checking contents of model parameters");
        if (grid == null) {
            System.out.println("dem is null");
        }
        if (lCGrid2 == null) {
            System.out.println("lc is null");
        }
        if (hashtable == null) {
            System.out.println("tm is null");
        }
        System.out.println("isostatic = " + n);
        if (clientDataSet == null) {
            System.out.println("slr is null");
        }
        JOptionPane.showMessageDialog(null, "ModelSetupTree.createSimNode(), proceedWithSimulation", "Information", 1);
        this.simVector = new CustomVector("Simulation");
        this.simulation = new Simulation(grid, lCGrid2, hashtable, n, clientDataSet);
        Thread thread = new Thread(this.simulation);
        thread.start();
        this.simVector.add(this.simulation);
        this.simLocal = new DefaultMutableTreeNode(this.simVector);
        this.simStatus = new DefaultMutableTreeNode("Simulation");
        this.treeModel.insertNodeInto(this.simStatus, this.top, this.top.getChildCount());
        this.treeModel.reload(this.top);
        this.treeModel.insertNodeInto(this.simLocal, this.simStatus, this.simStatus.getChildCount());
        this.treeModel.reload(this.simStatus);
        this.treeModel.reload(this.simLocal);
        this.simulation.removePropertyChangeListener(this);
        this.simulation.addPropertyChangeListener(this);
    }

    private void addToModelView(CustomVector customVector) {
        System.out.println("ModelSetupTree.addToModelView(v), " + customVector.toLongString());
        int n = 0;
        while (n < customVector.size()) {
            DisplayFrame displayFrame = (DisplayFrame)customVector.elementAt(n);
            this.addToModelView(displayFrame);
            ++n;
        }
    }

    private void addToModelView(DisplayFrame displayFrame) {
        this.firePropertyChange("addToModelView", null, displayFrame);
    }

    private void removeFromModelView(DisplayFrame displayFrame) {
        this.firePropertyChange("removeFromModelView", null, displayFrame);
    }

    private void removeAllFromModelView() {
        this.firePropertyChange("removeAllFromModelView", new Integer(0), new Integer(1));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            object = (DisplayFrame)propertyChangeEvent.getNewValue();
            this.addToModelView((DisplayFrame)object);
            this.visibleVector.add(object);
        }
        if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            object = (DisplayFrame)propertyChangeEvent.getNewValue();
            this.removeFromModelView((DisplayFrame)object);
            this.visibleVector.remove(object);
        }
        if (propertyChangeEvent.getPropertyName().equals("addGridToModel")) {
            object = (Vector)propertyChangeEvent.getNewValue();
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), null, object);
        }
        if (propertyChangeEvent.getPropertyName().equals("setTidalModel")) {
            object = (Vector)propertyChangeEvent.getNewValue();
            this.tidalModelsList.addTM((Vector)object);
        }
        if (propertyChangeEvent.getPropertyName().equals("setAllTidalModels")) {
            object = String.valueOf(((Hashtable)propertyChangeEvent.getNewValue()).size());
            this.statusJBean.setTidalModels((String)object);
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("setIsostaticMovement")) {
            object = propertyChangeEvent.getNewValue().toString();
            this.statusJBean.setIsoMov((String)object);
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("setSLRScenario")) {
            object = (ClientDataSet)propertyChangeEvent.getNewValue();
            String string = ((ClientDataSet)object).getStationName();
            this.statusJBean.setSlrScen(string);
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("setAllSurvivalModels")) {
            this.statusJBean.setVegMod("Done");
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("proceedWithSimulation")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            JOptionPane.showMessageDialog(null, "ModelSetupTree.propertyChange(), proceedWithSimulation", "Information", 1);
        }
    }

    private void initialize() {
        this.demRemoteGM.removePropertyChangeListener(this);
        this.demRemoteGM.addPropertyChangeListener(this);
        this.landcoverRemoteGM.removePropertyChangeListener(this);
        this.landcoverRemoteGM.addPropertyChangeListener(this);
        this.tidalDataLocalStations.removePropertyChangeListener(this);
        this.tidalDataLocalStations.addPropertyChangeListener(this);
        this.tidalModelsList.removePropertyChangeListener(this);
        this.tidalModelsList.addPropertyChangeListener(this);
        this.isostaticMovementSlider.removePropertyChangeListener(this);
        this.isostaticMovementSlider.addPropertyChangeListener(this);
        this.smList.removePropertyChangeListener(this);
        this.smList.addPropertyChangeListener(this);
        this.scenarioList.removePropertyChangeListener(this);
        this.scenarioList.addPropertyChangeListener(this);
        this.status.removePropertyChangeListener(this);
        this.status.addPropertyChangeListener(this);
    }

    public void setStatusBean(StatusJBean statusJBean) {
        this.statusJBean = statusJBean;
        this.statusJBean.addPropertyChangeListener(this.status);
        this.statusJBean.getStatus();
    }

    public void setClassTypes(Vector vector) {
        if (vector != null) {
            this.smList.setClassTypes(vector);
        }
    }
}

