/*
 * Decompiled with CFR 0.152.
 */
package iDSS.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DatabaseAccess {
    private Connection aConnection;
    private String aQuery;
    Statement aStatement;
    ResultSet aResultSet;
    String url;

    public DatabaseAccess(String string, String string2, String string3, String string4, String string5) {
        this.aQuery = string;
        this.url = string2;
        String string6 = string3;
        String string7 = string4;
        try {
            Class.forName(string5);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.constructor()\n" + classNotFoundException.getMessage(), "ClassNotFoundException", 0);
        }
        try {
            this.aConnection = DriverManager.getConnection(this.url, null, null);
            System.out.println("Connection established to the database " + this.url);
        }
        catch (SQLException sQLException) {
            System.err.println("==> SQLException: ");
            JOptionPane.showMessageDialog(null, "DatabaseAccess.constructor()\n" + sQLException.getMessage() + "\n" + sQLException.getSQLState() + "\n" + sQLException.getErrorCode(), "SQLException", 0);
            return;
        }
        try {
            this.aStatement = this.aConnection.createStatement();
            this.aResultSet = this.aStatement.executeQuery(this.aQuery);
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.constructor()\n" + sQLException.getMessage(), "SQLException", 0);
        }
    }

    public ResultSet getResultSet() {
        return this.aResultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getVector(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            boolean bl = this.aResultSet.next();
            if (!bl) {
                JOptionPane.showMessageDialog(null, "DatabaseAccess.getVector()\nResultSet contained no records", "No record", 1);
                return null;
            }
            while (true) {
                if (!this.aResultSet.next()) {
                    return vector;
                }
                vector.add(this.aResultSet.getString(string));
            }
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.getVector()\n" + sQLException.getMessage(), "SQLException", 0);
        }
        return vector;
    }

    public Vector getColumnNamesVector() {
        Vector<String> vector = new Vector<String>();
        try {
            ResultSetMetaData resultSetMetaData = this.aResultSet.getMetaData();
            System.out.println("Column count = " + resultSetMetaData.getColumnCount());
            int n = 1;
            while (n <= resultSetMetaData.getColumnCount()) {
                vector.addElement(resultSetMetaData.getColumnName(n));
                System.out.println("Column name = " + resultSetMetaData.getColumnName(n));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.getColumnNamesVector()\n" + sQLException.getMessage(), "SQLException", 0);
            return null;
        }
        return vector;
    }

    public Vector getRowDataVector() {
        Vector<Vector> vector = new Vector<Vector>();
        try {
            ResultSetMetaData resultSetMetaData = this.aResultSet.getMetaData();
            while (this.aResultSet.next()) {
                vector.addElement(this.getNextRow(this.aResultSet, resultSetMetaData));
            }
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.getRowDataVector()\n" + sQLException.getMessage(), "SQLException", 0);
            return null;
        }
        return vector;
    }

    private Vector getNextRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        Vector<Object> vector = new Vector<Object>();
        int n = 1;
        while (n <= resultSetMetaData.getColumnCount()) {
            switch (resultSetMetaData.getColumnType(n)) {
                case 12: {
                    vector.addElement(resultSet.getString(n));
                    break;
                }
                case 1: {
                    vector.addElement(resultSet.getString(n));
                    break;
                }
                case 4: {
                    vector.addElement(new Long(resultSet.getInt(n)));
                    break;
                }
                case 8: {
                    vector.addElement(new Double(resultSet.getDouble(n)));
                    break;
                }
                case 6: {
                    vector.addElement(new Float(resultSet.getFloat(n)));
                    break;
                }
                case 93: {
                    vector.addElement(Timestamp.valueOf(resultSet.getString(n)));
                    break;
                }
                default: {
                    System.out.println("Type was: " + resultSetMetaData.getColumnTypeName(n) + "," + resultSetMetaData.getColumnType(n));
                }
            }
            ++n;
        }
        return vector;
    }

    public void shutDown() {
        try {
            this.aConnection.close();
            System.out.println("Database connection to " + this.url + " closed.");
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, "DatabaseAccess.shutDown()\n" + sQLException.getMessage(), "SQLException", 0);
        }
    }

    public static void main(String[] stringArray) {
        String string = "Select * from stationList";
        System.out.println("query = " + string);
        DatabaseAccess databaseAccess = new DatabaseAccess(string, "jdbc:mysql://localhost:3306/tideDBLocal", null, null, "org.gjt.mm.mysql.Driver");
        Vector vector = databaseAccess.getVector("stationName");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
        databaseAccess.shutDown();
    }
}

