/*
 * Decompiled with CFR 0.152.
 */
package iDSS.disp;

import iDSS.disp.DisplayFrame;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class DocumentDisplay
extends DisplayFrame
implements HyperlinkListener {
    private JEditorPane aHTMLPane = new JEditorPane();
    private JScrollPane aScrollPane;

    public DocumentDisplay(String string, String string2) {
        super(string, true, true, true, true, null);
        this.setDisplayPane();
        try {
            this.aHTMLPane.setPage(string2);
        }
        catch (IOException iOException) {
            System.out.println("IOException, " + iOException);
            System.exit(0);
        }
        this.aScrollPane = new JScrollPane(this.aHTMLPane);
        this.getContentPane().add(this.aScrollPane);
        this.pack();
        this.setVisible(true);
    }

    public DocumentDisplay(String string, Vector vector, String string2) {
        super(string, true, true, true, true, null);
        this.aHTMLPane.addHyperlinkListener(this);
        this.setDisplayPane();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            this.aHTMLPane.setText(this.aHTMLPane.getText() + string3);
            ++n;
        }
        this.aScrollPane = new JScrollPane(this.aHTMLPane);
        this.getContentPane().add(this.aScrollPane);
        this.pack();
        this.setVisible(true);
    }

    public DocumentDisplay(String string, StringBuffer stringBuffer, String string2) {
        super(string, true, true, true, true, null);
        this.setDisplayPane();
        this.aHTMLPane.setText(stringBuffer.toString());
        this.aScrollPane = new JScrollPane(this.aHTMLPane);
        this.getContentPane().add(this.aScrollPane);
        this.pack();
        this.setVisible(true);
    }

    private void setDisplayPane() {
        this.aHTMLPane.setMinimumSize(new Dimension(300, 300));
        this.aHTMLPane.setPreferredSize(new Dimension(300, 300));
        this.aHTMLPane.setSize(new Dimension(300, 300));
        this.aHTMLPane.setEditable(false);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

