/*
 * Decompiled with CFR 0.152.
 */
package iDSS.gView;

import iDSS.disp.DisplayFrame;
import iDSS.disp.DocumentDisplay;
import iDSS.disp.ImageDisplay;
import iDSS.gView.AnimationFrame;
import iDSS.gridDisp.GridDisplay;
import iDSS.gridDisp.SurfaceColor;
import iDSS.grids.Grid;
import iDSS.grids.Grid2;
import iDSS.grids.GridCell;
import iDSS.grids.LCGrid2;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.FileNameDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GridViewControl
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private JTable gridsTable;
    private JButton drawButton;
    private JButton runButton;
    private JButton newButton;
    private JButton disposeButton;
    private JButton describeButton;
    private JComboBox dataCategoryCombo;
    public static final int INSTANT = 1;
    public static final int SUMMARY = 2;
    public static final int HISTORY = 3;
    private int gridsType;
    private boolean ALLOW_ROW_SELECTION = true;
    private Vector gridsListVector;
    private String currentFileName;
    private String currentName;
    private Vector currentRow;
    private final int MINIMUM_IMAGE_SIZE = 400;

    public GridViewControl(int n, String string) {
        super(string, false, true, false, true, null);
        Serializable serializable;
        this.gridsType = n;
        this.gridsListVector = new Vector();
        Vector<String> vector = new Vector<String>();
        vector.add("Grid File Name");
        Vector vector2 = new Vector();
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        this.gridsTable = new JTable(generalTableModel);
        this.gridsTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        JScrollPane jScrollPane = new JScrollPane(this.gridsTable, 20, 30);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Grids for viewing"));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        this.drawButton = new JButton("Draw");
        this.drawButton.setActionCommand("draw");
        this.drawButton.addActionListener(this);
        this.drawButton.setEnabled(false);
        this.runButton = new JButton("Run");
        this.runButton.setActionCommand("run");
        this.runButton.addActionListener(this);
        this.runButton.setEnabled(false);
        this.newButton = new JButton("New");
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(this);
        this.disposeButton = new JButton("Dispose");
        this.disposeButton.setActionCommand("dispose");
        this.disposeButton.addActionListener(this);
        this.disposeButton.setEnabled(false);
        this.describeButton = new JButton("Describe");
        this.describeButton.setActionCommand("describe");
        this.describeButton.addActionListener(this);
        this.describeButton.setEnabled(false);
        if (n == 2) {
            serializable = GridCell.getParametersVector();
            this.dataCategoryCombo = new JComboBox(serializable);
        } else if (n == 3) {
            serializable = GridCell.getParametersVector();
            this.dataCategoryCombo = new JComboBox(serializable);
        }
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        ((Container)serializable).add(this.describeButton);
        ((Container)serializable).add(this.runButton);
        ((Container)serializable).add(this.newButton);
        ((Container)serializable).add(this.disposeButton);
        if (n == 2 || n == 3) {
            ((Container)serializable).add(this.dataCategoryCombo);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel);
        this.getContentPane().add((Component)serializable);
        this.setBackground(Color.lightGray);
        this.pack();
        this.setVisible(true);
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.gridsTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        GridViewControl.this.drawButton.setEnabled(false);
                        GridViewControl.this.disposeButton.setEnabled(false);
                        GridViewControl.this.describeButton.setEnabled(false);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        GridViewControl.this.drawButton.setEnabled(true);
                        GridViewControl.this.disposeButton.setEnabled(true);
                        GridViewControl.this.describeButton.setEnabled(true);
                        GridViewControl.this.currentFileName = (String)GridViewControl.this.gridsTable.getValueAt(n, 0);
                        GridViewControl.this.currentRow = new Vector();
                        GridViewControl.this.currentRow.add(GridViewControl.this.currentFileName);
                    }
                }
            });
        } else {
            this.gridsTable.setRowSelectionAllowed(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("describe")) {
            File file = new File(this.currentFileName);
            Grid grid = null;
            if (this.gridsType == 1) {
                grid = Grid.readGridObject(file);
            } else if (this.gridsType == 2) {
                String string = (String)this.dataCategoryCombo.getSelectedItem();
                Grid2 grid2 = Grid2.readGrid2Object(file);
                grid = grid2.getGrid(string);
            }
            if (grid != null) {
                this.describeGrid(grid);
            }
        } else if (actionEvent.getActionCommand().equals("new")) {
            this.getNewGrid();
        } else if (actionEvent.getActionCommand().equals("dispose")) {
            this.removeFromGrids();
        } else if (actionEvent.getActionCommand().equals("run")) {
            this.runAnimation();
        }
    }

    private SurfaceColor getDefaultSC() {
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        Vector<Double> vector3 = new Vector<Double>();
        Vector<Double> vector4 = new Vector<Double>();
        vector.add(new Double(0.0));
        vector.add(new Double(1.8));
        vector.add(new Double(3.6));
        vector.add(new Double(5.4));
        vector.add(new Double(7.2));
        vector2.add(new Double(0.0));
        vector2.add(new Double(0.2));
        vector2.add(new Double(1.0));
        vector2.add(new Double(0.2));
        vector2.add(new Double(0.0));
        vector3.add(new Double(0.25));
        vector3.add(new Double(0.0));
        vector3.add(new Double(0.0));
        vector3.add(new Double(0.0));
        vector3.add(new Double(0.0));
        vector4.add(new Double(0.0));
        vector4.add(new Double(0.25));
        vector4.add(new Double(0.5));
        vector4.add(new Double(0.75));
        vector4.add(new Double(1.0));
        SurfaceColor surfaceColor = new SurfaceColor("Grids Animation", vector, vector2, vector3, vector4);
        return surfaceColor;
    }

    private void runAnimation() {
        Vector<Vector> vector = new Vector<Vector>();
        if (this.gridsType == 1) {
            Object object;
            double d = 9999.0;
            double d2 = -9999.0;
            int n = 0;
            while (n < this.gridsListVector.size()) {
                object = (File)this.gridsListVector.elementAt(n);
                Grid grid = Grid.readGridObject((File)object);
                d = Math.min(d, grid.getZMin());
                d2 = Math.max(d2, grid.getZMax());
                ++n;
            }
            object = new SurfaceColor("Flood Grids", d, d2, SurfaceColor.FLOOD);
            int n2 = 0;
            while (n2 < this.gridsListVector.size()) {
                File file = (File)this.gridsListVector.elementAt(n2);
                Grid grid = Grid.readGridObject(file);
                Vector vector2 = this.writeImgFiles((SurfaceColor)object, grid);
                vector.add(vector2);
                ++n2;
            }
            this.addAnimationToDesktop("Frames of instant flood grids", vector, (SurfaceColor)object);
        } else if (this.gridsType == 2) {
            Object object;
            String string = (String)this.dataCategoryCombo.getSelectedItem();
            double d = 9999.0;
            double d3 = -9999.0;
            if (string == "highestDepthOfFlooding") {
                int n = 0;
                while (n < this.gridsListVector.size()) {
                    object = (File)this.gridsListVector.elementAt(n);
                    Grid2 grid2 = Grid2.readGrid2Object((File)object);
                    Grid grid = grid2.getGrid(string);
                    d = Math.min(d, grid.getZMin());
                    d3 = Math.max(d3, grid.getZMax());
                    ++n;
                }
            }
            SurfaceColor surfaceColor = new SurfaceColor("Flood Grids", d, d3, SurfaceColor.FLOOD);
            object = new SurfaceColor("Probability Grids", 0.0, 1.0, SurfaceColor.DEM);
            double d4 = 3.1536E10;
            SurfaceColor surfaceColor2 = new SurfaceColor("Time Length", SurfaceColor.TIMECOLORSCHEMEUPTOAYEAR);
            int n = 0;
            while (n < this.gridsListVector.size()) {
                File file = (File)this.gridsListVector.elementAt(n);
                Grid2 grid2 = Grid2.readGrid2Object(file);
                Grid grid = grid2.getGrid(string);
                Vector vector3 = null;
                vector3 = string == "highestDepthOfFlooding" ? this.writeImgFiles(surfaceColor, grid) : (string == "minimumProbabilityOfSurvival" ? this.writeImgFiles((SurfaceColor)object, grid) : this.writeImgFiles(surfaceColor2, grid));
                vector.add(vector3);
                ++n;
            }
            if (string == "highestDepthOfFlooding") {
                this.addAnimationToDesktop("Frames of yearly summary", vector, surfaceColor);
            } else if (string == "minimumProbabilityOfSurvival") {
                this.addAnimationToDesktop("Frames of yearly summary", vector, (SurfaceColor)object);
            } else {
                this.addAnimationToDesktop("Frames of yearly summary", vector, surfaceColor2);
            }
        } else if (this.gridsType == 3) {
            String string = (String)this.dataCategoryCombo.getSelectedItem();
            SurfaceColor surfaceColor = this.getDefaultSC();
            int n = 0;
            while (n < this.gridsListVector.size()) {
                File file = (File)this.gridsListVector.elementAt(n);
                LCGrid2 lCGrid2 = LCGrid2.readLCGrid2Object(file);
                Enumeration enumeration = lCGrid2.getYears();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        Integer n3 = (Integer)enumeration.nextElement();
                        Grid grid = lCGrid2.getGrid(string, n3);
                        Vector vector4 = this.writeImgFiles(surfaceColor, grid);
                        vector.add(vector4);
                    }
                }
                ++n;
            }
        }
    }

    private Vector writeImgFiles(SurfaceColor surfaceColor, Grid grid) {
        Object object;
        BufferedImage bufferedImage = grid.getImage(surfaceColor);
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getWidth() < 400 && bufferedImage.getHeight() < 400) {
            int n = Math.max(bufferedImage.getWidth(), bufferedImage.getHeight());
            int n2 = 400 / n;
            bufferedImage2 = new BufferedImage(bufferedImage.getWidth() * n2, bufferedImage.getHeight() * n2, 1);
            object = bufferedImage2.getGraphics();
            ((Graphics)object).drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        } else {
            bufferedImage2 = bufferedImage;
        }
        File file = new File("g:\\iDSSTemp");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, FileNameDialog.getTempImgFileName());
        file2.deleteOnExit();
        if (file2.exists()) {
            file2.delete();
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage2, "png", file2);
        }
        catch (IIOException iIOException) {
            System.out.println("GridViewColtrol.writeImgFiles(), " + iIOException.toString());
        }
        object = new Vector();
        ((Vector)object).add(file2);
        ((Vector)object).add(grid.getName());
        return object;
    }

    private void addAnimationToDesktop(String string, Vector vector, SurfaceColor surfaceColor) {
        AnimationFrame animationFrame = new AnimationFrame(string, vector);
        animationFrame.removePropertyChangeListener(this);
        animationFrame.addPropertyChangeListener(this);
        this.addToDesktop(animationFrame);
        Dimension dimension = animationFrame.getSize();
        dimension.width += 100;
        animationFrame.setSize(dimension.width, dimension.height);
        ImageDisplay imageDisplay = new ImageDisplay("Legend", surfaceColor.getLegendWidth(), surfaceColor.getLegendHeight());
        this.addToDesktop(imageDisplay);
        surfaceColor.drawLegend(imageDisplay);
    }

    private void drawSummaryGrid(Grid2 grid2) {
        String string = (String)this.dataCategoryCombo.getSelectedItem();
        Grid grid = grid2.getGrid(string);
        this.drawGrid(grid);
    }

    private void drawGrid(Grid grid) {
        if (!grid.isRead()) {
            grid.read();
        }
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        Vector<Double> vector3 = new Vector<Double>();
        Vector<Double> vector4 = new Vector<Double>();
        vector.add(new Double(0.0));
        vector.add(new Double(1.8));
        vector.add(new Double(3.6));
        vector.add(new Double(5.4));
        vector.add(new Double(7.2));
        vector2.add(new Double(0.0));
        vector2.add(new Double(0.2));
        vector2.add(new Double(1.0));
        vector2.add(new Double(0.2));
        vector2.add(new Double(0.0));
        vector3.add(new Double(1.0));
        vector3.add(new Double(0.75));
        vector3.add(new Double(0.5));
        vector3.add(new Double(0.25));
        vector3.add(new Double(0.0));
        vector4.add(new Double(0.0));
        vector4.add(new Double(0.25));
        vector4.add(new Double(0.5));
        vector4.add(new Double(0.75));
        vector4.add(new Double(1.0));
        SurfaceColor surfaceColor = new SurfaceColor(grid.getName(), vector, vector2, vector3, vector4);
        GridDisplay gridDisplay = new GridDisplay(grid.getName());
        grid.draw(gridDisplay, surfaceColor);
        this.addToDesktop(gridDisplay);
        System.out.println("sc.getLegendWidth(),sc.getLegendHeight() : " + surfaceColor.getLegendWidth() + ", " + surfaceColor.getLegendHeight());
        ImageDisplay imageDisplay = new ImageDisplay(grid.getName() + ":Legend", surfaceColor.getLegendWidth(), surfaceColor.getLegendHeight());
        this.addToDesktop(imageDisplay);
        surfaceColor.drawLegend(imageDisplay);
    }

    public void getNewGrid() {
        Object object;
        File file = null;
        if (this.currentFileName != null) {
            object = new File(this.currentFileName);
            file = ((File)object).getParentFile();
        }
        if ((object = FileNameDialog.getInputFileNames("Pick new Grid...", file, null)) != null) {
            int n = 0;
            while (n < ((Object)object).length) {
                Object object2 = object[n];
                if (object2 != null && ((File)object2).exists()) {
                    this.addToGrids((File)object2);
                } else {
                    System.out.println("GridManager.getNewGrid(), file is null");
                }
                ++n;
            }
        }
    }

    private void addToDesktop(DisplayFrame displayFrame) {
        if (displayFrame == null) {
            System.out.println("GridViewControl.addToDesktop(), panel is null");
        }
        this.firePropertyChange("addToModelView", null, displayFrame);
    }

    public void addToGrids(File file) {
        if (!this.gridsListVector.contains(file)) {
            this.gridsListVector.add(file);
            GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
            Vector<String> vector = new Vector<String>();
            vector.add(file.toString());
            generalTableModel.addRow(vector);
            this.gridsTable.setModel(generalTableModel);
            if (this.gridsListVector.size() > 0) {
                this.runButton.setEnabled(true);
            } else {
                this.runButton.setEnabled(false);
            }
        }
    }

    private void removeFromGrids() {
        this.drawButton.setEnabled(false);
        this.disposeButton.setEnabled(false);
        File file = new File(this.currentFileName);
        this.gridsListVector.remove(file);
        GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
        generalTableModel.removeRow(this.currentRow);
        this.gridsTable.setModel(generalTableModel);
        if (this.gridsListVector.size() > 0) {
            this.runButton.setEnabled(true);
        } else {
            this.runButton.setEnabled(false);
        }
    }

    private void describeGrid(Grid grid) {
        DocumentDisplay documentDisplay = new DocumentDisplay("Describing :" + grid.getName(), grid.showdescription(), "text/HTML");
        this.addToDesktop(documentDisplay);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

