/*
 * Decompiled with CFR 0.152.
 */
package iDSS.gridDisp;

import iDSS.disp.DisplayFrame;
import iDSS.gridDisp.AboutAction;
import iDSS.gridDisp.DrawingPanel2;
import iDSS.gridDisp.InfoAction;
import iDSS.gridDisp.JLFAbstractAction;
import iDSS.gridDisp.ZoomInAction;
import iDSS.gridDisp.ZoomOutAction;
import iDSS.utils.IDSSAppConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class GridDisplay
extends DisplayFrame
implements ActionListener {
    private DrawingPanel2 drawingArea;
    private int drawingAreaX = 400;
    private int drawingAreaY = 400;
    private InfoAction infoAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private AboutAction aboutAction;
    private Vector actions;
    private JTextField coordsTextField;
    private JLabel statusLabel;
    private MouseHandler mouseHandler;
    private JPopupMenu popup;

    public GridDisplay(String string) {
        super(string, true, true, true, true, null);
        this.initActions();
        this.statusLabel = this.createStatusBar();
        this.mouseHandler = new MouseHandler(this.statusLabel);
        this.setJMenuBar(this.createMenu());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.popup = this.createPopupMenu();
        this.coordsTextField = new JTextField(20);
        this.pack();
        this.setVisible(true);
    }

    private void initActions() {
        this.actions = new Vector();
        this.infoAction = new InfoAction();
        this.registerAction(this.infoAction);
        this.zoomInAction = new ZoomInAction();
        this.registerAction(this.zoomInAction);
        this.zoomOutAction = new ZoomOutAction();
        this.registerAction(this.zoomOutAction);
        this.aboutAction = new AboutAction();
        this.registerAction(this.aboutAction);
    }

    private void registerAction(JLFAbstractAction jLFAbstractAction) {
        jLFAbstractAction.addActionListener(this);
        this.actions.addElement(jLFAbstractAction);
    }

    private JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('V');
        JMenuItem jMenuItem = jMenu.add(this.zoomInAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenuItem = jMenu.add(this.zoomOutAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenuItem = jMenu.add(this.infoAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        JMenu jMenu2 = new JMenu("About");
        jMenu2.setMnemonic('A');
        jMenuItem = jMenu2.add(this.aboutAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = jToolBar.add(this.zoomInAction);
        jButton.addMouseListener(this.mouseHandler);
        jButton = jToolBar.add(this.zoomOutAction);
        jButton.addMouseListener(this.mouseHandler);
        jButton = jToolBar.add(this.infoAction);
        jButton.addMouseListener(this.mouseHandler);
        jToolBar.addSeparator();
        jButton = jToolBar.add(this.aboutAction);
        jButton.addMouseListener(this.mouseHandler);
        return jToolBar;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(this.zoomInAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenuItem = jPopupMenu.add(this.zoomOutAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jMenuItem = jPopupMenu.add(this.infoAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        jPopupMenu.addSeparator();
        jMenuItem = jPopupMenu.add(this.aboutAction);
        jMenuItem.addMouseListener(this.mouseHandler);
        return jPopupMenu;
    }

    private JPanel createPanel() {
        this.coordsTextField = new JTextField(50);
        this.drawingArea = new DrawingPanel2(this.drawingAreaX, this.drawingAreaY);
        JScrollPane jScrollPane = new JScrollPane(this.drawingArea);
        this.drawingArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GridDisplay.this.popup.show(GridDisplay.this.drawingArea, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GridDisplay.this.popup.show(GridDisplay.this.drawingArea, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(this.drawingAreaX, this.drawingAreaY));
        jPanel.add((Component)this.coordsTextField, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JLabel createStatusBar() {
        this.statusLabel = new JLabel("...");
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder());
        return this.statusLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.aboutAction.getActionCommand())) {
            JOptionPane.showMessageDialog(this, this.aboutAction.getLongDescription(), this.aboutAction.getShortDescription(), 1);
        } else if (string.equals(this.zoomInAction.getActionCommand()) || string.equals(this.zoomOutAction.getActionCommand()) || string.equals(this.infoAction.getActionCommand())) {
            // empty if block
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("GridDisplay test");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GridDisplay gridDisplay = new GridDisplay("GridDisplay");
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        jDesktopPane.add(gridDisplay);
        jFrame.setContentPane(jDesktopPane);
        jFrame.pack();
        ((Component)jFrame).setSize(500, 400);
        ((Component)jFrame).setVisible(true);
    }

    public BufferedImage getCanvas() {
        return this.drawingArea.getCanvas();
    }

    public void refreshCanvas(BufferedImage bufferedImage) {
        if (IDSSAppConstants.debug) {
            System.out.println("GridDisplay.refreshCanvas()");
        }
        this.drawingArea.refreshCanvas(bufferedImage);
    }

    private class MouseHandler
    extends MouseAdapter {
        private JLabel label;

        public MouseHandler(JLabel jLabel) {
            this.setLabel(jLabel);
        }

        private void setLabel(JLabel jLabel) {
            this.label = jLabel;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Action action;
            if (mouseEvent.getSource() instanceof AbstractButton && (action = (abstractButton = (AbstractButton)mouseEvent.getSource()).getAction()) != null) {
                String string = (String)action.getValue("LongDescription");
                this.label.setText(string);
            }
        }
    }
}

