/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sm;

import iDSS.disp.DisplayFrame;
import iDSS.gridDisp.DrawingPanel2;
import iDSS.sm.SurvivalModel;
import iDSS.utils.StringHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExponentialSurvivalModel
implements SurvivalModel,
Serializable,
ActionListener {
    private double rateOfDescent;
    private double criticalFloodingDepth;
    private long criticalTimeInMillis;
    private String modelName = "Exponential Model";
    private PropertyChangeSupport pcs;
    private Vector textFieldsVector;
    private DisplayFrame internalFrame;

    public ExponentialSurvivalModel() {
        this.criticalTimeInMillis = 0L;
        this.rateOfDescent = 0.0;
        this.criticalFloodingDepth = 0.0;
        this.pcs = new PropertyChangeSupport(this);
    }

    public ExponentialSurvivalModel(long l, double d, double d2) {
        this.criticalTimeInMillis = l > 0L ? l : 0L;
        this.rateOfDescent = d > 0.0 ? d : 0.0;
        this.criticalFloodingDepth = d2 >= 0.0 ? d2 : 0.0;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.modelName;
    }

    public void setCriticalTime(long l) {
        this.criticalTimeInMillis = l;
    }

    public long getCriticalTime() {
        return this.criticalTimeInMillis;
    }

    public void setRateOfDescent(double d) {
        this.rateOfDescent = d;
    }

    public double getRateOfDescent() {
        return this.rateOfDescent;
    }

    public void setCriticalFloodingDepth(double d) {
        this.criticalFloodingDepth = d;
    }

    public double getCriticalFloodingDepth(Timestamp timestamp) {
        return this.criticalFloodingDepth;
    }

    public double getProbability(long l, double d, Timestamp timestamp) {
        double d2 = Math.exp((double)(this.criticalTimeInMillis - l) * this.rateOfDescent);
        d2 = Math.min(1.0, d2);
        return d2;
    }

    public DisplayFrame showDetails(boolean bl) {
        this.internalFrame = new DisplayFrame(this.modelName, false, true, false, true, null);
        DrawingPanel2 drawingPanel2 = new DrawingPanel2(300, 150);
        ExponentialSurvivalModel.drawModel(drawingPanel2);
        JLabel jLabel = new JLabel("Critical flooding length (days):");
        JLabel jLabel2 = new JLabel("Rate of descent of probability:");
        JLabel jLabel3 = new JLabel("Cirtical flood depth (depth units):");
        JTextField jTextField = new JTextField(String.valueOf((double)this.criticalTimeInMillis / 8.64E7), 10);
        JTextField jTextField2 = new JTextField(String.valueOf(this.rateOfDescent), 10);
        JTextField jTextField3 = new JTextField(String.valueOf(this.criticalFloodingDepth), 10);
        jTextField.setEditable(bl);
        jTextField2.setEditable(bl);
        jTextField3.setEditable(bl);
        this.textFieldsVector = new Vector();
        this.textFieldsVector.add(jTextField);
        this.textFieldsVector.add(jTextField2);
        this.textFieldsVector.add(jTextField3);
        JButton jButton = new JButton("Accept");
        jButton.setEnabled(bl);
        jButton.setActionCommand("accept");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.add(jLabel2);
        jPanel.add(jTextField2);
        jPanel.add(jLabel3);
        jPanel.add(jTextField3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        this.internalFrame.getContentPane().setLayout(new BoxLayout(this.internalFrame.getContentPane(), 1));
        this.internalFrame.getContentPane().add(drawingPanel2);
        this.internalFrame.getContentPane().add(jPanel);
        this.internalFrame.getContentPane().add(jPanel2);
        this.internalFrame.pack();
        this.internalFrame.setVisible(true);
        return this.internalFrame;
    }

    public static void drawModel(DrawingPanel2 drawingPanel2) {
        BufferedImage bufferedImage = drawingPanel2.getCanvas();
        Graphics graphics = bufferedImage.getGraphics();
        int n = drawingPanel2.getCanvasX();
        int n2 = drawingPanel2.getCanvasY();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
        int n3 = 35;
        int n4 = n - 2 * n3;
        int n5 = n2 - 2 * n3;
        int n6 = 3;
        graphics.setColor(Color.black);
        graphics.drawLine(n3, n3, n3, n2 - n3);
        graphics.drawLine(n3, n2 - n3, n - n3, n2 - n3);
        graphics.drawLine(n3, n3 + n5 / 3, n3 + n4 / 3, n3 + n5 / 3);
        graphics.drawArc(n3 + n4 / 3, n3 - n5 / 3, n4 * 4 / 3, n5 * 4 / 3, 180, 90);
        graphics.drawLine(n3 + n4, n3 + n5, n3 + n4, n3 + n5 - n6);
        graphics.drawLine(n3 + n4 / 3, n3 + n5, n3 + n4 / 3, n3 + n5 - n6);
        graphics.drawString("0", n3 - 2, n3 + n5 + 15);
        graphics.drawString("Critical time", n3 + n4 / 3 - 10, n3 + n5 + 15);
        graphics.drawString("365", n3 + n4 - 10, n3 + n5 + 15);
        graphics.drawString("0", n3 - 15, n3 + n5 + 2);
        graphics.drawString("1", n3 - 15, n3 + n5 / 3 + 2);
        graphics.drawString("Days of the year", n3, n3 + n5 + 30);
        graphics.drawString("Probability of survival", n3, n3 - 5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("accept")) {
            JTextField jTextField = (JTextField)this.textFieldsVector.elementAt(0);
            double d = Double.parseDouble(jTextField.getText()) * 24.0 * 60.0 * 60.0 * 1000.0;
            long l = Math.round(d);
            jTextField = (JTextField)this.textFieldsVector.elementAt(1);
            double d2 = Double.parseDouble(jTextField.getText());
            jTextField = (JTextField)this.textFieldsVector.elementAt(2);
            double d3 = Double.parseDouble(jTextField.getText());
            this.setCriticalTime(l);
            this.setRateOfDescent(d2);
            this.setCriticalFloodingDepth(d3);
            this.pcs.firePropertyChange("setSurvivalModel", null, this.getCopy());
            this.pcs.firePropertyChange("removeFromModelView", null, this.internalFrame);
        }
    }

    public SurvivalModel getCopy() {
        Timestamp timestamp = null;
        ExponentialSurvivalModel exponentialSurvivalModel = new ExponentialSurvivalModel(this.getCriticalTime(), this.getRateOfDescent(), this.getCriticalFloodingDepth(timestamp));
        return exponentialSurvivalModel;
    }

    public Hashtable getParameters() {
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
        hashtable.put("criticalTimeInMillis", new Long(this.criticalTimeInMillis));
        hashtable.put("rateOfDescent", new Double(this.rateOfDescent));
        hashtable.put("criticalFloodingDepth", new Double(this.criticalFloodingDepth));
        return hashtable;
    }

    public void setParameters(Hashtable hashtable) {
        this.criticalTimeInMillis = StringHandler.stringToLong((String)hashtable.get("criticalTimeInMillis"));
        this.rateOfDescent = StringHandler.stringToDouble((String)hashtable.get("rateOfDescent"));
        this.criticalFloodingDepth = StringHandler.stringToDouble((String)hashtable.get("criticalFloodingDepth"));
    }
}

