/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sm;

import iDSS.disp.DisplayFrame;
import iDSS.gridDisp.DrawingPanel2;
import iDSS.sm.SurvivalModel;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.ConfigData;
import iDSS.utils.FileNameDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class TimeVariantSurvivalModel
implements SurvivalModel,
Serializable,
PropertyChangeListener,
ActionListener {
    private Hashtable models = new Hashtable();
    private Hashtable timestamps = new Hashtable();
    private String modelName = "Timevariant Model";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JComboBox modelsCombo;
    private DrawingPanel2 picturePanel;
    private JButton defineButton;
    private JButton detailsButton;
    private JButton disposeButton;
    private JButton acceptButton;
    private JButton userSMButton;
    private int currentMonth;
    private int currentDay;
    private String currentModel;
    private JTable table;
    private Calendar modelCalendar = Calendar.getInstance();
    private JScrollPane tableScrollPane;
    private DisplayFrame internalFrame;

    public TimeVariantSurvivalModel() {
        this.modelCalendar.set(1970, 0, 1, 0, 0, 0);
    }

    public void setModels(Hashtable hashtable) {
        this.models = hashtable;
    }

    public void setTimestamps(Hashtable hashtable) {
        this.timestamps = hashtable;
    }

    public void setModelCalendar(Calendar calendar) {
        this.modelCalendar = calendar;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return this.modelName;
    }

    private long getYearinMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, 0, 0, 0);
        long l = calendar.getTime().getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(1971, 0, 1, 0, 0, 0);
        long l2 = calendar2.getTime().getTime();
        long l3 = l2 - l;
        return l3;
    }

    private Timestamp switchYear(Timestamp timestamp, Timestamp timestamp2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n = calendar.get(1);
        Timestamp timestamp3 = this.switchYear(n, timestamp2);
        return timestamp3;
    }

    private Timestamp switchYear(int n, Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.set(1, n);
        Timestamp timestamp2 = new Timestamp(calendar.getTime().getTime());
        return timestamp2;
    }

    private Vector getBoundingModels(Timestamp timestamp) {
        Timestamp timestamp2;
        long l;
        Vector<Object> vector = new Vector<Object>();
        Timestamp timestamp3 = this.switchYear(1970, timestamp);
        Timestamp timestamp4 = null;
        Timestamp timestamp5 = null;
        SurvivalModel survivalModel = null;
        SurvivalModel survivalModel2 = null;
        long l2 = l = this.getYearinMillis();
        Enumeration enumeration = this.models.keys();
        while (enumeration.hasMoreElements()) {
            timestamp2 = (Timestamp)enumeration.nextElement();
            long l3 = ((Date)timestamp3).getTime() - ((Date)timestamp2).getTime();
            long l4 = -l3;
            if (l3 <= l && l3 >= 0L) {
                l = l3;
                timestamp4 = timestamp2;
            }
            if (l4 > l2 || l4 < 0L) continue;
            l2 = l4;
            timestamp5 = timestamp2;
        }
        if (timestamp4 == null && timestamp5 != null) {
            timestamp4 = timestamp5;
        } else if (timestamp4 != null && timestamp5 == null) {
            timestamp5 = timestamp4;
        }
        if (timestamp4 != null && timestamp5 != null) {
            survivalModel = (SurvivalModel)this.models.get(timestamp4);
            survivalModel2 = (SurvivalModel)this.models.get(timestamp5);
            timestamp2 = this.switchYear(timestamp, timestamp4);
            Timestamp timestamp6 = this.switchYear(timestamp, timestamp5);
            vector.add(timestamp4);
            vector.add(timestamp5);
            vector.add(survivalModel);
            vector.add(survivalModel2);
        } else {
            System.out.println("else, no bounding time found!");
        }
        return vector;
    }

    public double getCriticalFloodingDepth(Timestamp timestamp) {
        Vector vector = this.getBoundingModels(timestamp);
        Timestamp timestamp2 = (Timestamp)vector.elementAt(0);
        Timestamp timestamp3 = (Timestamp)vector.elementAt(1);
        SurvivalModel survivalModel = (SurvivalModel)vector.elementAt(2);
        SurvivalModel survivalModel2 = (SurvivalModel)vector.elementAt(3);
        double d = survivalModel.getCriticalFloodingDepth(timestamp2);
        double d2 = survivalModel.getCriticalFloodingDepth(timestamp3);
        Timestamp timestamp4 = this.switchYear(1970, timestamp);
        double d3 = this.interpolate(timestamp2, timestamp3, d, d2, timestamp4);
        return d3;
    }

    public double getProbability(long l, double d, Timestamp timestamp) {
        Vector vector = this.getBoundingModels(timestamp);
        Timestamp timestamp2 = (Timestamp)vector.elementAt(0);
        Timestamp timestamp3 = (Timestamp)vector.elementAt(1);
        SurvivalModel survivalModel = (SurvivalModel)vector.elementAt(2);
        SurvivalModel survivalModel2 = (SurvivalModel)vector.elementAt(3);
        double d2 = survivalModel.getProbability(l, d, timestamp2);
        double d3 = survivalModel2.getProbability(l, d, timestamp3);
        Timestamp timestamp4 = this.switchYear(1970, timestamp);
        double d4 = this.interpolate(timestamp2, timestamp3, d2, d3, timestamp4);
        return d4;
    }

    private double interpolate(Timestamp timestamp, Timestamp timestamp2, double d, double d2, Timestamp timestamp3) {
        double d3;
        long l = ((Date)timestamp).getTime();
        long l2 = ((Date)timestamp2).getTime();
        long l3 = ((Date)timestamp3).getTime();
        if (l == l2) {
            d3 = d;
        } else {
            double d4 = l3 - l;
            double d5 = l2 - l;
            d3 = (d2 - d) * d4 / d5 + d;
        }
        return d3;
    }

    private JComboBox getMonthCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 1;
        while (n <= 12) {
            String string = String.valueOf(n);
            jComboBox.addItem(string);
            ++n;
        }
        return jComboBox;
    }

    private JComboBox getDayCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 1;
        while (n < 32) {
            String string = String.valueOf(n);
            jComboBox.addItem(string);
            ++n;
        }
        return jComboBox;
    }

    private Vector getModels() {
        Vector vector = new Vector();
        Enumeration enumeration = this.timestamps.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Timestamp timestamp = (Timestamp)this.timestamps.get(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            Integer n = new Integer(calendar.get(2) + 1);
            Integer n2 = new Integer(calendar.get(5));
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(n);
            vector2.add(n2);
            vector2.add(string);
            vector.add(vector2);
        }
        return vector;
    }

    public DisplayFrame showDetails(boolean bl) {
        bl = true;
        boolean bl2 = true;
        Vector<String> vector = new Vector<String>();
        vector.add("Month");
        vector.add("Day");
        vector.add("Name");
        Vector vector2 = this.getModels();
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        generalTableModel.setEditableColumn(0);
        generalTableModel.setEditableColumn(1);
        this.table = new JTable(generalTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getMonthCombo()));
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new DefaultCellEditor(this.getDayCombo()));
        this.tableScrollPane = new JScrollPane(this.table, 20, 30);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Defined SurvivalModels"));
        jPanel.add(this.tableScrollPane);
        this.modelsCombo = new JComboBox(ConfigData.readURLProperties("config", "smModels.prop", this.getClass()));
        this.defineButton = new JButton("Define");
        this.detailsButton = new JButton("Details");
        this.disposeButton = new JButton("Dispose");
        this.acceptButton = new JButton("Accept");
        this.defineButton.setEnabled(bl);
        this.detailsButton.setEnabled(false);
        this.disposeButton.setEnabled(false);
        this.acceptButton.setEnabled(bl);
        this.defineButton.setActionCommand("define");
        this.detailsButton.setActionCommand("details");
        this.disposeButton.setActionCommand("dispose");
        this.acceptButton.setActionCommand("accept");
        this.defineButton.addActionListener(this);
        this.detailsButton.addActionListener(this);
        this.disposeButton.addActionListener(this);
        this.acceptButton.addActionListener(this);
        this.userSMButton = new JButton("Get User Defined Models");
        this.userSMButton.setActionCommand("getUserSMButtonCommand");
        this.userSMButton.addActionListener(this);
        int n = 5;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.modelsCombo);
        jPanel2.add(this.defineButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.userSMButton);
        jPanel3.add(this.detailsButton);
        jPanel3.add(this.disposeButton);
        jPanel3.add(this.acceptButton);
        this.internalFrame = new DisplayFrame(this.modelName, false, true, false, true, null);
        this.internalFrame.setBackground(Color.lightGray);
        this.internalFrame.getContentPane().setLayout(new BoxLayout(this.internalFrame.getContentPane(), 1));
        this.internalFrame.getContentPane().add(jPanel);
        this.internalFrame.getContentPane().add(jPanel2);
        this.internalFrame.getContentPane().add(jPanel3);
        this.internalFrame.pack();
        this.internalFrame.setVisible(true);
        if (bl2) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        TimeVariantSurvivalModel.this.detailsButton.setEnabled(false);
                        TimeVariantSurvivalModel.this.disposeButton.setEnabled(false);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        TimeVariantSurvivalModel.this.detailsButton.setEnabled(true);
                        TimeVariantSurvivalModel.this.disposeButton.setEnabled(true);
                        TimeVariantSurvivalModel.this.currentMonth = Integer.parseInt(TimeVariantSurvivalModel.this.table.getValueAt(n, 0).toString()) - 1;
                        TimeVariantSurvivalModel.this.currentDay = Integer.parseInt(TimeVariantSurvivalModel.this.table.getValueAt(n, 1).toString());
                        TimeVariantSurvivalModel.this.currentModel = (String)TimeVariantSurvivalModel.this.table.getValueAt(n, 2);
                        System.out.println(TimeVariantSurvivalModel.this.currentModel);
                    }
                }
            });
        } else {
            this.table.setRowSelectionAllowed(false);
        }
        return this.internalFrame;
    }

    private void addToTable(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.addRow(vector);
        this.table.setModel(generalTableModel);
        int n = this.table.getRowCount() - 1;
        this.table.setRowSelectionInterval(n, n);
        JViewport jViewport = this.tableScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n2 = this.table.getRowHeight();
        Point point2 = new Point(point.x, point.y + n2);
        jViewport.setViewPosition(point2);
        this.tableScrollPane.setViewport(jViewport);
    }

    private void removeFromTable(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.removeRow(vector);
        this.table.setModel(generalTableModel);
    }

    public void setCriticalFloodingDepth(double d) {
    }

    public double getProbability(double d, double d2) {
        return 0.0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("define")) {
            this.defineAModel();
        } else if (string.equals("details")) {
            this.viewModelDetails();
        } else if (string.equals("dispose")) {
            this.removeModel();
        } else if (string.equals("accept")) {
            this.acceptModel();
        } else if (actionEvent.getActionCommand().equals("getUserSMButtonCommand")) {
            this.getUserSM();
        }
    }

    private void getUserSM() {
        File file = FileNameDialog.getInputFileName("Select User SM File", null, null);
        Vector vector = new Vector();
        if (file != null && (vector = ConfigData.readProperties(file)) != null) {
            String string;
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                this.modelsCombo.addItem(string);
                ++n;
            }
            string = ".";
            File file2 = file.getParentFile();
            if (file2 != null) {
                string = file2.toString();
            }
            System.out.println("TimeVariantSurvivalModel.getUserSM(), smPath: " + string);
            ConfigData.addToClassPath(string);
        }
    }

    private void acceptModel() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        Vector vector = generalTableModel.getRowsVector();
        Hashtable<Timestamp, SurvivalModel> hashtable = new Hashtable<Timestamp, SurvivalModel>();
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            int n2 = Integer.parseInt(vector2.elementAt(0).toString()) - 1;
            int n3 = Integer.parseInt(vector2.elementAt(1).toString());
            String string = (String)vector2.elementAt(2);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, n2, n3, 0, 0, 0);
            Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
            Timestamp timestamp2 = (Timestamp)this.timestamps.get(string);
            SurvivalModel survivalModel = (SurvivalModel)this.models.get(timestamp2);
            hashtable.put(timestamp, survivalModel);
            this.timestamps.remove(string);
            this.timestamps.put(string, timestamp);
            ++n;
        }
        this.models = hashtable;
        this.pcs.firePropertyChange("setSurvivalModel", null, this.getCopy());
        this.pcs.firePropertyChange("removeFromModelView", null, this.internalFrame);
    }

    public SurvivalModel getCopy() {
        Object object;
        Object object2;
        Cloneable cloneable;
        Hashtable<Cloneable, Object> hashtable = new Hashtable<Cloneable, Object>();
        Enumeration enumeration = this.models.keys();
        while (enumeration.hasMoreElements()) {
            cloneable = (Timestamp)enumeration.nextElement();
            object2 = (SurvivalModel)this.models.get(cloneable);
            object = object2.getCopy();
            hashtable.put(cloneable, object);
        }
        cloneable = new Hashtable();
        object2 = this.timestamps.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            Timestamp timestamp = (Timestamp)this.timestamps.get(object);
            ((Hashtable)cloneable).put(object, timestamp);
        }
        object = new TimeVariantSurvivalModel();
        ((TimeVariantSurvivalModel)object).setModels(hashtable);
        ((TimeVariantSurvivalModel)object).setTimestamps((Hashtable)cloneable);
        ((TimeVariantSurvivalModel)object).setModelCalendar(this.modelCalendar);
        return object;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("setSurvivalModel")) {
            SurvivalModel survivalModel = (SurvivalModel)propertyChangeEvent.getNewValue();
            if (survivalModel != null || survivalModel instanceof SurvivalModel) {
                this.setSurvivalModel(survivalModel);
            } else {
                JOptionPane.showMessageDialog(null, "x,Failed to receive Survivalodel", "Error", 0);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private void setSurvivalModel(SurvivalModel survivalModel) {
        Vector<Object> vector = new Vector<Object>();
        int n = this.modelCalendar.get(2) + 1;
        int n2 = this.modelCalendar.get(5);
        vector.add(new Integer(n));
        vector.add(new Integer(n2));
        String string = survivalModel.getName() + ":" + String.valueOf(n) + "/" + String.valueOf(n2);
        vector.add(string);
        this.addToTable(vector);
        Timestamp timestamp = new Timestamp(this.modelCalendar.getTime().getTime());
        this.models.put(timestamp, survivalModel);
        this.timestamps.put(string, timestamp);
        JOptionPane.showMessageDialog(null, "x,Successfully received Survivalodel for \n" + string, "Information", 1);
        this.modelCalendar.set(5, ++n2);
    }

    private void defineAModel() {
        try {
            String string = (String)this.modelsCombo.getSelectedItem();
            SurvivalModel survivalModel = (SurvivalModel)Class.forName(string).newInstance();
            survivalModel.addPropertyChangeListener(this);
            this.pcs.firePropertyChange("addToModelView", null, survivalModel.showDetails(true));
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "ClassNotFoundException\n" + classNotFoundException.toString(), "Error", 0);
        }
        catch (InstantiationException instantiationException) {
            JOptionPane.showMessageDialog(null, "InstantiationException\n" + instantiationException.toString(), "Error", 0);
        }
        catch (IllegalAccessException illegalAccessException) {
            JOptionPane.showMessageDialog(null, "IllegalAccessException\n" + illegalAccessException.toString(), "Error", 0);
        }
    }

    private void viewModelDetails() {
        System.out.println("currentModel : " + this.currentModel);
        Timestamp timestamp = (Timestamp)this.timestamps.get(this.currentModel);
        SurvivalModel survivalModel = (SurvivalModel)this.models.get(timestamp);
        if (survivalModel != null) {
            this.pcs.firePropertyChange("addToModelView", null, survivalModel.showDetails(false));
        } else {
            JOptionPane.showMessageDialog(null, "No model defined for " + this.currentMonth + "/" + this.currentDay, "Information", 1);
            Enumeration enumeration = this.models.keys();
            System.out.println("TimeVariantSurvivalModel.viewModelDetails(), list of models hashtable:");
            while (enumeration.hasMoreElements()) {
                Timestamp timestamp2 = (Timestamp)enumeration.nextElement();
                SurvivalModel survivalModel2 = (SurvivalModel)this.models.get(timestamp2);
                System.out.println(timestamp2.toString() + " : " + survivalModel2.getName());
            }
            System.out.println("Your timestamp is " + timestamp.toString());
        }
    }

    private void removeModel() {
        System.out.println("currentModel : " + this.currentModel);
        Timestamp timestamp = (Timestamp)this.timestamps.get(this.currentModel);
        System.out.println("hashTimestamp : " + timestamp.toString());
        if (timestamp != null) {
            SurvivalModel survivalModel = (SurvivalModel)this.models.get(timestamp);
            if (survivalModel != null) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(new Integer(this.currentMonth + 1));
                vector.add(new Integer(this.currentDay));
                vector.add(this.currentModel);
                this.removeFromTable(vector);
                this.models.remove(timestamp);
                this.timestamps.remove(this.currentModel);
            } else {
                System.out.println("sm = null");
            }
        } else {
            System.out.println("hashTimestamp = null");
            Enumeration enumeration = this.timestamps.keys();
            System.out.println("timestamps listing:");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Timestamp timestamp2 = (Timestamp)this.timestamps.get(string);
                System.out.println(string + " : " + timestamp2.toString());
            }
        }
    }

    public Hashtable getParameters() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }

    public void setParameters(Hashtable hashtable) {
    }
}

