/*
 * Decompiled with CFR 0.152.
 */
package iDSS.xyGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class GraphAxis {
    String axisName;
    Vector axisLabels;
    int axisStartX;
    int axisStartY;
    int axisEndX;
    int axisEndY;
    Color axisColor;
    int ticLength;

    public GraphAxis(String string, Vector vector, int n, int n2, int n3, int n4, Color color) {
        this.axisName = string;
        this.axisLabels = vector;
        this.axisStartX = n;
        this.axisStartY = n2;
        this.axisEndX = n3;
        this.axisEndY = n4;
        this.axisColor = color == null ? Color.black : color;
        this.ticLength = Math.min((n3 - n) / 100, (n4 - n2) / 100);
        this.ticLength = Math.max(this.ticLength, 7);
        System.out.println("axisName,axisStartX,axisStartY,axisEndX,axisEndY\n" + this.axisName + ", " + this.axisStartX + ", " + this.axisStartY + ", " + this.axisEndX + ", " + this.axisEndY);
    }

    public void drawXAxis(Graphics graphics) {
        System.out.println("In GraphAxis drawXAxis()");
        graphics.setColor(this.axisColor);
        graphics.drawLine(this.axisStartX, this.axisStartY, this.axisEndX, this.axisEndY);
        int n = this.axisLabels.size();
        int n2 = (this.axisEndX - this.axisStartX) / (n - 1);
        int n3 = 0;
        while (n3 < n) {
            graphics.drawLine(this.axisStartX + n3 * n2, this.axisStartY, this.axisStartX + n3 * n2, this.axisStartY - this.ticLength);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            graphics.drawString((String)this.axisLabels.elementAt(n4), this.axisStartX + n4 * n2 - n2 / 5, this.axisStartY + 2 * this.ticLength);
            ++n4;
        }
        Font font = graphics.getFont();
        graphics.setFont(new Font(font.getName(), 1, font.getSize()));
        graphics.drawString(this.axisName, this.axisStartX, this.axisStartY + 4 * this.ticLength);
        graphics.setFont(font);
    }

    public void drawYAxis(Graphics graphics) {
        System.out.println("In GraphAxis drawYAxis()");
        graphics.setColor(this.axisColor);
        graphics.drawLine(this.axisStartX, this.axisStartY, this.axisEndX, this.axisEndY);
        int n = this.axisLabels.size();
        int n2 = Math.abs(this.axisEndY - this.axisStartY) / (n - 1);
        int n3 = 0;
        while (n3 < n) {
            graphics.drawLine(this.axisStartX, this.axisStartY - n3 * n2, this.axisStartX + this.ticLength, this.axisStartY - n3 * n2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            graphics.drawString((String)this.axisLabels.elementAt(n4), this.axisStartX - 5 * this.ticLength, this.axisStartY - n4 * n2);
            ++n4;
        }
        Font font = graphics.getFont();
        graphics.setFont(new Font(font.getName(), 1, font.getSize()));
        graphics.drawString(this.axisName, this.axisStartX, this.axisEndY - 2 * this.ticLength);
        graphics.setFont(font);
    }

    public void setName(String string) {
        this.axisName = string;
    }

    public void addName(String string) {
        this.axisName = this.axisName + ", " + string;
    }

    public String getName() {
        return this.axisName;
    }

    public void setLabels(Vector vector) {
        this.axisLabels = vector;
    }

    public Vector getLabels() {
        return this.axisLabels;
    }
}

