/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.Locator;
import com.sun.corba.ee.ActivationIDL.LocatorHelper;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.internal.Activation.InitialNamingImpl;
import com.sun.corba.ee.internal.Activation.NameServiceStartThread;
import com.sun.corba.ee.internal.Activation.POAIdMapImpl;
import com.sun.corba.ee.internal.Activation.RepositoryImpl;
import com.sun.corba.ee.internal.Activation.ServerManagerImpl;
import com.sun.corba.ee.internal.CosNaming.BootstrapServer;
import com.sun.corba.ee.internal.CosNaming.TransientNameService;
import com.sun.corba.ee.internal.POA.POAORB;
import com.sun.corba.ee.internal.core.ServerGIOP;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContext;

public class ORBD {
    protected File dbDir;
    private String dbDirName;
    protected InitialNamingImpl ins;
    protected Locator locator;
    protected Activator activator;
    protected RepositoryImpl repository;
    static final int DefaultActivationPort = 1049;
    static final String DefaultDbDir = "orb.db";
    static final String InitialObjectsDb = "initial.db";
    private static String[][] orbServers = new String[][]{{"1", "", "com.sun.corba.ee.internal.CosNaming.TransientNameServer", "", "", ""}};

    protected POAORB createORB(String[] stringArray) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("com.sun.corba.ee.internal.POA.ORBServerPort", properties.getProperty("com.sun.corba.ee.internal.Activation.Port", Integer.toString(1049)));
        ((Hashtable)properties).put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.internal.POA.POAORB");
        return (POAORB)ORB.init(stringArray, properties);
    }

    protected boolean createSystemDirs(String string) {
        File file;
        boolean bl2 = false;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("file.separator");
        this.dbDir = new File(properties.getProperty("com.sun.corba.ee.internal.Activation.DbDir", String.valueOf(properties.getProperty("user.dir")) + string2 + string));
        this.dbDirName = this.dbDir.getAbsolutePath();
        ((Hashtable)properties).put("com.sun.corba.ee.internal.Activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
            bl2 = true;
        }
        if (!(file = new File(this.dbDir, "logs")).exists()) {
            file.mkdir();
        }
        return bl2;
    }

    protected Activator getActivator() {
        return this.activator;
    }

    protected File getDbDir() {
        return this.dbDir;
    }

    protected String getDbDirName() {
        return this.dbDirName;
    }

    protected Locator getLocator() {
        return this.locator;
    }

    protected RepositoryImpl getRepository() {
        return this.repository;
    }

    protected InitialNamingImpl initializeBootNaming(POAORB pOAORB) {
        Properties properties = new Properties();
        String string = System.getProperty("file.separator");
        File file = new File(this.dbDir, String.valueOf(string) + InitialObjectsDb);
        int n2 = pOAORB.getORBInitialPort();
        BootstrapServer bootstrapServer = new BootstrapServer(pOAORB, n2, file, properties);
        bootstrapServer.start();
        InitialNamingImpl initialNamingImpl = new InitialNamingImpl(pOAORB, bootstrapServer);
        return initialNamingImpl;
    }

    protected void installOrbServers(RepositoryImpl repositoryImpl, Activator activator) {
        int n2 = 0;
        while (n2 < orbServers.length) {
            try {
                String[] stringArray = orbServers[n2];
                ServerDef serverDef = new ServerDef(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                int n3 = Integer.valueOf(orbServers[n2][0]);
                repositoryImpl.registerServer(serverDef, n3);
                activator.activate(n3);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        ORBD oRBD = new ORBD();
        oRBD.run(stringArray);
    }

    private void run(String[] stringArray) {
        try {
            POAORB pOAORB = this.createORB(stringArray);
            if (pOAORB.orbdDebugFlag) {
                System.out.println("ORBD begins initialization.");
            }
            boolean bl2 = this.createSystemDirs(DefaultDbDir);
            this.startActivationObjects(pOAORB);
            if (bl2) {
                this.installOrbServers(this.getRepository(), this.getActivator());
            }
            if (pOAORB.orbdDebugFlag) {
                System.out.println("ORBD is ready.");
            }
            NameServiceStartThread nameServiceStartThread = new NameServiceStartThread(pOAORB, this.dbDir, this.ins);
            nameServiceStartThread.start();
            pOAORB.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void startActivationObjects(POAORB pOAORB) throws Exception {
        this.ins = this.initializeBootNaming(pOAORB);
        POAIdMapImpl pOAIdMapImpl = new POAIdMapImpl(pOAORB, this.dbDir, pOAORB.orbdDebugFlag);
        this.ins.bind("POAIdMapper", pOAIdMapImpl, false);
        this.repository = new RepositoryImpl(pOAORB, this.dbDir, pOAORB.orbdDebugFlag);
        this.ins.bind("ServerRepository", this.repository, false);
        ServerGIOP serverGIOP = pOAORB.getServerGIOP();
        serverGIOP.initEndpoints();
        int n2 = serverGIOP.getDefaultEndpoint().getPort();
        ServerManagerImpl serverManagerImpl = new ServerManagerImpl(pOAORB, (short)n2, this.repository, this.getDbDirName(), pOAORB.orbdDebugFlag);
        this.locator = LocatorHelper.narrow(serverManagerImpl);
        this.ins.bind("ServerLocator", this.locator, false);
        this.activator = ActivatorHelper.narrow(serverManagerImpl);
        this.ins.bind("ServerActivator", this.activator, false);
        TransientNameService transientNameService = new TransientNameService(pOAORB);
        NamingContext namingContext = transientNameService.initialNamingContext();
        this.ins.bind("NameService", namingContext, false);
    }
}

