/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.RepositoryNameParser;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

class RepositoryContext
implements Context {
    public static final String REPOSITORY_NAME = "com.sun.enterprise.repository.name";
    public static final String REPOSITORY_DIR = "com.sun.enterprise.repository.dir";
    Hashtable myEnv;
    private Properties bindings;
    private static final boolean debug = false;
    static NameParser myParser = new RepositoryNameParser();
    private static final String DEFAULT_NAMETABLE_DIR = "config/";
    private static final String DEFAULT_NAME = "default";
    private static final String FILE_EXT = ".properties";

    RepositoryContext(Hashtable environment) {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.resurrectTable();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (((Hashtable)this.bindings).get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        ((Hashtable)this.bindings).put(name, obj);
        this.store();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void close() throws NamingException {
        this.store();
        this.myEnv = null;
        this.bindings = null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    static String getFilePath(String dirName, String filename) {
        String path = String.valueOf(filename) + FILE_EXT;
        if (path != null) {
            String fname = FileUtil.getAbsolutePath(String.valueOf(dirName) + path);
            File f2 = new File(fname);
            if (!f2.exists()) {
                path = "default.properties";
            }
        } else {
            path = "default.properties";
        }
        return FileUtil.getAbsolutePath(String.valueOf(dirName) + path);
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public static String getRepositoryName(String fname) {
        String filepath = RepositoryContext.getFilePath(DEFAULT_NAMETABLE_DIR, fname);
        int fileIndex = filepath.lastIndexOf(File.separator);
        String filename = null;
        filename = fileIndex > 0 ? filepath.substring(fileIndex + 1) : filepath;
        int extIndex = filename.lastIndexOf(FILE_EXT);
        String fwithoutext = extIndex > 0 ? filename.substring(0, extIndex) : filename;
        return fwithoutext;
    }

    private String getStoragePath() {
        String dirName = (String)this.myEnv.get(REPOSITORY_DIR);
        if (dirName == null) {
            dirName = DEFAULT_NAMETABLE_DIR;
        }
        return RepositoryContext.getFilePath(dirName, (String)this.myEnv.get(REPOSITORY_NAME));
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new RepNames(((Hashtable)this.bindings).keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(String.valueOf(name) + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new RepBindings(((Hashtable)this.bindings).keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(String.valueOf(name) + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new RepositoryContext(this.myEnv);
        }
        Object answer = ((Hashtable)this.bindings).get(name);
        if (answer == null) {
            throw new NameNotFoundException(String.valueOf(name) + " not found");
        }
        return answer;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    private static void print(Hashtable ht) {
        Enumeration en2 = ht.keys();
        while (en2.hasMoreElements()) {
            Object key = en2.nextElement();
            Object v2 = ht.get(key);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        ((Hashtable)this.bindings).put(name, obj);
        this.store();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (((Hashtable)this.bindings).get(newname) != null) {
            throw new NameAlreadyBoundException(String.valueOf(newname) + " is already bound");
        }
        Object oldBinding = ((Hashtable)this.bindings).remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(String.valueOf(oldname) + " not bound");
        }
        ((Hashtable)this.bindings).put(newname, oldBinding);
        this.store();
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    private void resurrectTable() {
        this.bindings = new Properties();
        try {
            File f2 = new File(this.getStoragePath());
            if (f2.exists()) {
                this.bindings.load(new FileInputStream(f2));
            }
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    private void store() {
        try {
            if (this.bindings != null) {
                FileOutputStream fos = new FileOutputStream(this.getStoragePath());
                this.bindings.store(fos, "Repository resource mapping");
                fos.close();
            }
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public void unbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        ((Hashtable)this.bindings).remove(name);
        this.store();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    class RepNames
    implements NamingEnumeration {
        Enumeration names;

        RepNames(Enumeration names) {
            this.names = names;
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = ((Hashtable)RepositoryContext.this.bindings).get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;

        RepBindings(Enumeration names) {
            this.names = names;
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, ((Hashtable)RepositoryContext.this.bindings).get(name));
            }
            return null;
        }
    }
}

