/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.backend.DeploymentSessionImpl;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProgressPanel
extends JDialog
implements NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ProgressPanel != null ? class$com$sun$enterprise$tools$deployment$ui$ProgressPanel : (class$com$sun$enterprise$tools$deployment$ui$ProgressPanel = ProgressPanel.class$("com.sun.enterprise.tools.deployment.ui.ProgressPanel")));
    private JTextArea progressTextArea = new JTextArea("");
    private JScrollPane scrollPane;
    private JScrollBar scrollBar;
    private JPanel buttonsPanel = new JPanel();
    private JProgressBar ejbBar;
    private JProgressBar webBar;
    private JProgressBar applicationBar;
    private DeploymentSessionImpl session = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ProgressPanel;

    public ProgressPanel(Frame owner, int ejbs, int webComponents) {
        super(owner, true);
        super.dialogInit();
        super.setTitle(localStrings.getLocalString("progresspanel.deployment_progress", "Deployment Progress"));
        if (owner != null) {
            int x2 = owner.getBounds().x + owner.getBounds().width / 6;
            int y2 = owner.getBounds().y + owner.getBounds().height / 6;
            int width = (int)((double)owner.getBounds().width / 1.5);
            int height = (int)((double)owner.getBounds().height / 1.5);
            ((Component)this).setBounds(x2, y2, width, height);
        } else {
            ((Component)this).setBounds(0, 0, 200, 200);
        }
        this.initializeWidgets(ejbs, webComponents);
    }

    public void cancelAction() {
        if (this.session != null) {
            this.session.setCancelled(true, true);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void done() {
        this.buttonsPanel.removeAll();
        JButton okButton = new JButton(localStrings.getLocalString("progresspanel.ok", "OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ((Component)ProgressPanel.this).setVisible(false);
            }
        });
        this.buttonsPanel.add(okButton);
        this.buttonsPanel.doLayout();
        this.buttonsPanel.validate();
        this.buttonsPanel.repaint();
    }

    private void initializeWidgets(int ejbs, int webComponents) {
        this.progressTextArea.setEnabled(false);
        this.progressTextArea.setSelectionColor(((Component)this).getBackground());
        this.progressTextArea.setBackground(((Component)this).getBackground());
        this.progressTextArea.setLineWrap(false);
        this.progressTextArea.setWrapStyleWord(false);
        this.progressTextArea.setDisabledTextColor(Color.black);
        JPanel displayPanel = UIUtils.createBorderedPanel(localStrings.getLocalString("progresspanel.progress", "Progress"), null);
        JPanel p2 = null;
        this.getContentPane().setLayout(new BorderLayout());
        JButton cancelButton = new JButton(localStrings.getLocalString("progresspanel.cancel", "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ProgressPanel.this.cancelAction();
            }
        });
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.add(cancelButton);
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel, 0));
        displayPanel.setLayout(new GridLayout(1, 1));
        this.scrollPane = new JScrollPane(this.progressTextArea);
        this.scrollBar = this.scrollPane.getVerticalScrollBar();
        displayPanel.add(this.scrollPane);
        int ejbLength = 3;
        int webLength = webComponents;
        int applicationLength = ejbLength + webLength + 5;
        if (webComponents > 0) {
            this.webBar = UIUtils.createVerticalProgressBar(0, webLength, Color.cyan);
            this.webBar.setValue(0);
            this.webBar.setBorderPainted(true);
            p2 = UIUtils.createBorderedPanel(" ", new BorderLayout());
            p2.add("North", new JLabel(UIUtils.getImageIconFor(UIUtils.WEB_BUNDLE_ICON)));
            p2.add("Center", this.webBar);
            eastPanel.add(p2);
        }
        if (ejbs > 0) {
            this.ejbBar = UIUtils.createVerticalProgressBar(0, ejbLength, Color.blue);
            this.ejbBar.setValue(0);
            this.ejbBar.setBorderPainted(true);
            p2 = UIUtils.createBorderedPanel(" ", new BorderLayout());
            p2.add("Center", this.ejbBar);
            p2.add("North", new JLabel(UIUtils.getImageIconFor(UIUtils.EJB_BUNDLE_ICON)));
            eastPanel.add(p2);
        }
        this.applicationBar = UIUtils.createVerticalProgressBar(0, applicationLength, Color.green);
        this.applicationBar.setValue(0);
        this.applicationBar.setBorderPainted(true);
        p2 = UIUtils.createBorderedPanel(" ", new BorderLayout());
        p2.add("Center", this.applicationBar);
        p2.add("North", new JLabel(UIUtils.getImageIconFor(UIUtils.APPLICATION_ICON)));
        eastPanel.add(p2);
        this.getContentPane().add("South", this.buttonsPanel);
        this.getContentPane().add("Center", displayPanel);
        this.getContentPane().add("West", eastPanel);
    }

    public static void main(String[] args) {
        Frame f2 = new Frame();
        ((Component)f2).setBounds(0, 0, 400, 400);
        f2.show();
        ProgressPanel p2 = new ProgressPanel(f2, 5, 3);
        p2.show();
    }

    public void notification(NotificationEvent ne) {
        if (ne.getSource() instanceof DeploymentSessionImpl) {
            this.session = (DeploymentSessionImpl)ne.getSource();
            if (ne.getType().equals("Status Changed")) {
                this.progressTextArea.append(String.valueOf(this.session.getStatusMessage()) + "\n");
                this.scrollBar.setValue(this.scrollBar.getMaximum());
            }
            if (ne.getType().equals("Error")) {
                Exception e10 = this.session.getException();
                this.progressTextArea.append("\n" + this.session.getStatusMessage() + "\n");
                this.scrollBar.setValue(this.scrollBar.getMaximum());
                this.session.setCancelled(true, false);
            }
            if (ne.getType().equals("Ejb Code Generation complete") || ne.getType().equals("Ejb Compilation complete")) {
                this.ejbBar.setValue(this.ejbBar.getValue() + 1);
                this.applicationBar.setValue(this.applicationBar.getValue() + 1);
            }
            if (ne.getType().equals("Web Component Deployed")) {
                this.webBar.setValue(this.webBar.getValue() + 1);
                this.applicationBar.setValue(this.applicationBar.getValue() + 1);
            }
            if (ne.getType().equals("Application Transferred")) {
                this.applicationBar.setValue(this.applicationBar.getValue() + 1);
            }
            if (ne.getType().equals("Server JARs made")) {
                this.applicationBar.setValue(this.applicationBar.getValue() + 1);
            }
            if (ne.getType().equals("Client JARs made")) {
                this.applicationBar.setValue(this.applicationBar.getValue() + 1);
            }
            if (ne.getType().equals("Done Deploying")) {
                this.applicationBar.setValue(this.applicationBar.getMaximum());
            }
            if (ne.getType().equals("Client Code Saved")) {
                this.applicationBar.setValue(this.applicationBar.getMaximum());
            }
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void notificationEjb(int i2) {
        this.ejbBar.setValue(i2);
        this.validate();
    }

    public void notificationTransferDone() {
    }

    public void notificationWebComponent(int j2) {
        this.webBar.setValue(j2);
        this.validate();
    }
}

