/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wand;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class Wizard
extends JDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$Wizard != null ? class$com$sun$enterprise$tools$deployment$ui$Wizard : (class$com$sun$enterprise$tools$deployment$ui$Wizard = Wizard.class$("com.sun.enterprise.tools.deployment.ui.Wizard")));
    private static String SLIM_WIZARD_IMAGE = "wizard_generic_sliver.gif";
    private Vector components = new Vector();
    private Hashtable titles = new Hashtable();
    private Hashtable descriptions = new Hashtable();
    private Hashtable subTitles = new Hashtable();
    private int currentState = 0;
    protected boolean gotToEnd = false;
    private String doneLabelString = localStrings.getLocalString("wizard.finish", "Finish");
    private String frameTitle;
    private JDialog dialog;
    protected JPanel buttonsPanel;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton helpButton;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$Wizard;

    protected Wizard(Frame owner) {
        super(owner, true);
        super.dialogInit();
        this.dialog = this;
        this.setupLayout();
        this.doCentering();
    }

    public Wizard(Vector components, Frame owner) {
        this(owner);
        this.setComponents(components);
    }

    static /* synthetic */ int access$0(Wizard $0) {
        return $0.currentState;
    }

    public void addComponent(JComponent component, String title) {
        this.components.addElement(component);
        this.titles.put(component, title);
    }

    public void addComponent(JComponent component, String subTitle, String description) {
        this.components.addElement(component);
        this.subTitles.put(component, subTitle);
        this.descriptions.put(component, description);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public boolean didComplete() {
        return this.gotToEnd;
    }

    private void doCentering() {
        Frame owner = (Frame)super.getOwner();
        if (owner != null) {
            int x2 = owner.getBounds().x + this.getBounds().width / 4;
            int y2 = owner.getBounds().y + this.getBounds().height / 4;
            int width = owner.getBounds().width / 2;
            int height = owner.getBounds().height / 2;
            ((Component)this).setBounds(x2, y2, width, height);
        }
    }

    public void finishAction() {
        this.gotToEnd = true;
        this.currentState = 0;
        ((Component)this).setVisible(false);
    }

    protected JComponent getCurrentComponent() {
        return (JComponent)this.components.elementAt(this.currentState);
    }

    String getCurrentDescription() {
        Object description = this.descriptions.get(this.getCurrentComponent());
        if (description != null) {
            return (String)description;
        }
        return "";
    }

    String getCurrentSubTitle() {
        Object subTitle = this.subTitles.get(this.getCurrentComponent());
        if (subTitle != null) {
            return (String)subTitle;
        }
        return "";
    }

    String getCurrentTitle() {
        Object title = this.titles.get(this.getCurrentComponent());
        return (String)title;
    }

    protected int getIndexOf(JComponent component) {
        return this.components.indexOf(component);
    }

    public void goBackward() {
        Wand wandBeingLeft;
        JComponent componentBeingLeft = this.getCurrentComponent();
        if (this.getCurrentComponent() instanceof Wand && !(wandBeingLeft = (Wand)((Object)componentBeingLeft)).canLeaveBackward()) {
            return;
        }
        if (componentBeingLeft instanceof TableInspector) {
            ((TableInspector)((Object)componentBeingLeft)).editingStopped();
        }
        --this.currentState;
        this.refresh();
    }

    public void goForward() {
        Wand wandBeingLeft;
        JComponent componentBeingLeft = this.getCurrentComponent();
        if (this.getCurrentComponent() instanceof Wand && !(wandBeingLeft = (Wand)((Object)componentBeingLeft)).canLeaveForward()) {
            return;
        }
        if (componentBeingLeft instanceof TableInspector) {
            ((TableInspector)((Object)componentBeingLeft)).editingStopped();
        }
        ++this.currentState;
        this.refresh();
    }

    private void refresh() {
        this.updateFrameTitle();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        if (this.currentState == 0) {
            this.backButton.setEnabled(false);
        } else if (this.currentState == this.components.size() - 1) {
            this.nextButton.setEnabled(false);
            this.finishButton.setEnabled(true);
        }
        boolean isFirstPanel = this.getCurrentDescription() == null || this.getCurrentDescription().equals("");
        this.getContentPane().removeAll();
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        wrapperPanel.add((Component)mainPanel, "Center");
        wrapperPanel.add((Component)this.buttonsPanel, "South");
        if (!isFirstPanel) {
            JTextArea wandTitle = new JTextArea(this.getCurrentDescription());
            wandTitle.setEditable(false);
            wandTitle.setLineWrap(true);
            wandTitle.setWrapStyleWord(true);
            wandTitle.setBackground(UIManager.getColor("Panel.background"));
            UIUtils.makeFontPlain(wandTitle);
            wandTitle.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
            mainPanel.add("North", wandTitle);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(Box.createRigidArea(new Dimension(5, 5)), "East");
            panel.add((Component)new UIUtils.ImagePanel(UIUtils.getImageIconFor(SLIM_WIZARD_IMAGE).getImage()), "Center");
            wrapperPanel.add((Component)panel, "West");
        }
        mainPanel.add("Center", this.getCurrentComponent());
        this.getContentPane().add("Center", wrapperPanel);
        this.getContentPane().validate();
    }

    protected void setComponents(Vector components) {
        this.components = components;
    }

    protected void setCurrentState(int currentState) {
        this.currentState = currentState;
    }

    protected void setDoneLabelString(String doneLabelString) {
        this.doneLabelString = doneLabelString;
    }

    public void setTitle(String s2) {
        this.frameTitle = s2;
        super.setTitle(s2);
    }

    private void setupLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.helpButton = new JButton(localStrings.getLocalString("wizard.help", "Help"));
        JButton cancelButton = new JButton(localStrings.getLocalString("wizard.cancel", "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                Wizard.this.currentState = 0;
                Wizard.this.dialog.dispose();
            }
        });
        this.backButton = new JButton(localStrings.getLocalString("wizard.back", "< Back"));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                Wizard.this.goBackward();
            }
        });
        this.nextButton = new JButton(localStrings.getLocalString("wizard.next", "Next >"));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                Wizard.this.goForward();
            }
        });
        this.finishButton = new JButton(this.doneLabelString);
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                Wizard.this.finishAction();
            }
        });
        this.buttonsPanel = new JPanel(new BorderLayout());
        this.buttonsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        Box helpBox = Box.createHorizontalBox();
        Box navBox = Box.createHorizontalBox();
        helpBox.add(Box.createHorizontalStrut(25));
        helpBox.add(this.helpButton);
        helpBox.add(Box.createHorizontalStrut(15));
        navBox.add(Box.createHorizontalStrut(15));
        navBox.add(cancelButton);
        navBox.add(Box.createHorizontalStrut(7));
        navBox.add(this.backButton);
        navBox.add(this.nextButton);
        navBox.add(Box.createHorizontalStrut(20));
        navBox.add(this.finishButton);
        navBox.add(Box.createHorizontalStrut(20));
        this.buttonsPanel.add((Component)helpBox, "West");
        this.buttonsPanel.add((Component)navBox, "East");
        this.buttonsPanel.add((Component)new ButtonLine(), "North");
    }

    public void show() {
        this.refresh();
        super.show();
    }

    protected void updateFrameTitle() {
        super.setTitle(String.valueOf(this.frameTitle) + " - " + this.getCurrentSubTitle());
    }

    static class ButtonLine
    extends JPanel {
        public ButtonLine() {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 5));
        }

        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.setColor(Color.black);
            g2.drawLine(0, 0, this.getWidth() - 1, 0);
        }
    }
}

