/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class JarCheckImpl
implements JarCheck {
    private static final EjbCheckMgrImpl ejbCheckMgr = new EjbCheckMgrImpl();
    private static final WebCheckMgrImpl webCheckMgr = new WebCheckMgrImpl();
    private static final AppCheckMgrImpl appCheckMgr = new AppCheckMgrImpl();
    private static final AppClientCheckMgrImpl appClientCheckMgr = new AppClientCheckMgrImpl();
    boolean debug = Verifier.getDebug();
    boolean passed = true;

    public boolean check(Descriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (descriptor instanceof EjbBundleDescriptor) {
            if (this.debug) {
                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.EjbBundleDescriptor", "-instance of EjbBundleDescriptor: [ {0} ]", new Object[]{descriptor}));
                System.out.println("[ " + descriptor + " ]");
            }
            this.setStatus(ejbCheckMgr.check((EjbBundleDescriptor)descriptor));
        } else if (descriptor instanceof WebBundleDescriptor) {
            if (this.debug) {
                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.WebBundleDescriptor", "-instance of WebBundleDescriptor: [ {0} ]", new Object[]{descriptor}));
                System.out.println("[ " + descriptor + " ]");
            }
            this.setStatus(webCheckMgr.check((WebBundleDescriptor)descriptor));
        } else if (descriptor instanceof Application) {
            if (this.debug) {
                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.Application", "-instance of Application: [ {0} ]", new Object[]{descriptor.getName()}));
                System.out.println("[ " + descriptor + " ]");
            }
            this.setStatus(appCheckMgr.check((Application)descriptor));
        } else if (descriptor instanceof ApplicationClientDescriptor) {
            if (this.debug) {
                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug.ApplicationClient", "-instance of Application Client: [ {0} ]", new Object[]{descriptor}));
                System.out.println("[ " + descriptor + " ]");
            }
            this.setStatus(appClientCheckMgr.check((ApplicationClientDescriptor)descriptor));
        }
        return this.passed;
    }

    public static AppCheckMgrImpl getAppCheckMgrImpl() {
        return appCheckMgr;
    }

    public static AppClientCheckMgrImpl getAppClientCheckMgrImpl() {
        return appClientCheckMgr;
    }

    public static EjbCheckMgrImpl getEjbCheckMgrImpl() {
        return ejbCheckMgr;
    }

    public static WebCheckMgrImpl getWebCheckMgrImpl() {
        return webCheckMgr;
    }

    void setStatus(boolean status) {
        if (this.passed) {
            this.passed = status;
        }
    }
}

