/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class AppClientEjbRefNamePrefixed
implements AppClientCheck {
    boolean debug = Verifier.getDebug();

    public Result check(ApplicationClientDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean oneWarning = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                String ejbRefName = nextEjbReference.getName();
                if (ejbRefName.startsWith("ejb/")) {
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] is prefixed with recommended string \"ejb/\" within application client [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
                    continue;
                }
                if (!oneWarning) {
                    oneWarning = true;
                }
                result.addWarningDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: [ {0} ] is not prefixed with recommended string \"ejb/\" within application client [ {1} ]", new Object[]{ejbRefName, descriptor.getName()}));
            }
            if (oneWarning) {
                result.setStatus(2);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

