/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarContainsXMLFile
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        ZipFile jarFile = null;
        try {
            try {
                File applicationJarFile = Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName());
                jarFile = new JarFile(applicationJarFile);
                ZipEntry deploymentEntry = ((JarFile)jarFile).getEntry(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                if (deploymentEntry != null) {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Found deployment descriptor xml file [ {0} ]", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                } else {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: No deployment descriptor xml file found, looking for [ {0} ]", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
                }
                jarFile.close();
            }
            catch (FileNotFoundException ex2) {
                Verifier.debug(ex2);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: File not found trying to read deployment descriptor file [ {0} ]", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            }
            catch (IOException ex3) {
                Verifier.debug(ex3);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: IO Error trying to read deployment descriptor file [ {0} ]", new Object[]{EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY}));
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            jarFile.close();
        }
        catch (Exception exception) {}
        return result;
    }
}

