/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

class TcpConnector
implements MsgConnector {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    OutputStream out;
    InputStream in;
    MsgBuffer msg;

    public TcpConnector(Socket socket) throws IOException {
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.msg = new MsgBuffer(8192);
    }

    public MsgBuffer getMsgBuffer() {
        this.msg.reset();
        return this.msg;
    }

    public int receive(MsgBuffer msg) throws IOException {
        byte[] b10 = msg.getBuff();
        int rd = this.in.read(b10, 0, 4);
        if (rd <= 0) {
            return rd;
        }
        int len = msg.checkIn();
        rd = this.in.read(b10, 4, len);
        if (rd != len) {
            System.out.println("Incomplete read, deal with it " + len + " " + rd);
        }
        return rd;
    }

    public void send(MsgBuffer msg) throws IOException {
        msg.end();
        byte[] b10 = msg.getBuff();
        int len = msg.getLen();
        this.out.write(b10, 0, len);
    }
}

