/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.ChunkStream;
import com.sun.imageio.plugins.png.IDATOutputStream;
import com.sun.imageio.plugins.png.PNGImageReader;
import com.sun.imageio.plugins.png.PNGMetadata;
import com.sun.imageio.plugins.png.RowFilter;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class PNGImageWriter
extends ImageWriter {
    ImageOutputStream stream = null;
    PNGMetadata metadata = null;
    int numBands;
    int bpp;
    int bitShift = 0;
    RowFilter rowFilter = new RowFilter();
    byte[] prevRow = null;
    byte[] currRow = null;
    byte[][] filteredRows = null;
    private static int[] allowedProgressivePasses = new int[]{1, 7};

    public PNGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(false, false, true, false, null, null, this.getLocale());
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        PNGMetadata pNGMetadata = new PNGMetadata();
        pNGMetadata.initialize(imageTypeSpecifier);
        return pNGMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata instanceof PNGMetadata) {
            return (PNGMetadata)((PNGMetadata)iIOMetadata).clone();
        }
        return new PNGMetadata(iIOMetadata);
    }

    private void write_magic() throws IOException {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.stream.write(byArray);
    }

    private void write_IHDR() throws IOException {
        ChunkStream chunkStream = new ChunkStream(PNGImageReader.IHDR_TYPE, this.stream);
        chunkStream.writeInt(this.metadata.IHDR_width);
        chunkStream.writeInt(this.metadata.IHDR_height);
        chunkStream.writeByte(this.metadata.IHDR_bitDepth);
        chunkStream.writeByte(this.metadata.IHDR_colorType);
        if (this.metadata.IHDR_compressionMethod != 0) {
            throw new IIOException("Only compression method 0 is defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_compressionMethod);
        if (this.metadata.IHDR_filterMethod != 0) {
            throw new IIOException("Only filter method 0 is defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_filterMethod);
        if (this.metadata.IHDR_interlaceMethod < 0 || this.metadata.IHDR_interlaceMethod > 1) {
            throw new IIOException("Only interlace methods 0 (node) and 1 (adam7) are defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_interlaceMethod);
        chunkStream.finish();
    }

    private void write_cHRM() throws IOException {
        if (this.metadata.cHRM_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.cHRM_TYPE, this.stream);
            chunkStream.writeInt(this.metadata.cHRM_whitePointX);
            chunkStream.writeInt(this.metadata.cHRM_whitePointY);
            chunkStream.writeInt(this.metadata.cHRM_redX);
            chunkStream.writeInt(this.metadata.cHRM_redY);
            chunkStream.writeInt(this.metadata.cHRM_greenX);
            chunkStream.writeInt(this.metadata.cHRM_greenY);
            chunkStream.writeInt(this.metadata.cHRM_blueX);
            chunkStream.writeInt(this.metadata.cHRM_blueY);
            chunkStream.finish();
        }
    }

    private void write_gAMA() throws IOException {
        if (this.metadata.gAMA_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.gAMA_TYPE, this.stream);
            chunkStream.writeInt(this.metadata.gAMA_gamma);
            chunkStream.finish();
        }
    }

    private void write_iCCP() throws IOException {
        if (this.metadata.iCCP_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.iCCP_TYPE, this.stream);
            chunkStream.writeBytes(this.metadata.iCCP_profileName);
            chunkStream.writeByte(0);
            chunkStream.writeByte(this.metadata.iCCP_compressionMethod);
            chunkStream.write(this.metadata.iCCP_compressedProfile);
            chunkStream.finish();
        }
    }

    private void write_sBIT() throws IOException {
        if (this.metadata.sBIT_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.sBIT_TYPE, this.stream);
            int n = this.metadata.IHDR_colorType;
            if (this.metadata.sBIT_colorType != n) {
                this.processWarningOccurred(0, "sBIT metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 0 || n == 4) {
                chunkStream.writeByte(this.metadata.sBIT_grayBits);
            } else if (n == 2 || n == 3 || n == 6) {
                chunkStream.writeByte(this.metadata.sBIT_redBits);
                chunkStream.writeByte(this.metadata.sBIT_greenBits);
                chunkStream.writeByte(this.metadata.sBIT_blueBits);
            }
            if (n == 4 || n == 6) {
                chunkStream.writeByte(this.metadata.sBIT_alphaBits);
            }
            chunkStream.finish();
        }
    }

    private void write_sRGB() throws IOException {
        if (this.metadata.sRGB_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.sRGB_TYPE, this.stream);
            chunkStream.writeByte(this.metadata.sRGB_renderingIntent);
            chunkStream.finish();
        }
    }

    private void write_PLTE() throws IOException {
        if (this.metadata.PLTE_present) {
            if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
                this.processWarningOccurred(0, "A PLTE chunk may not appear in a gray or gray alpha image.\nThe chunk will not be written");
                return;
            }
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.PLTE_TYPE, this.stream);
            int n = this.metadata.PLTE_red.length;
            byte[] byArray = new byte[n * 3];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                byArray[n2++] = this.metadata.PLTE_red[n3];
                byArray[n2++] = this.metadata.PLTE_green[n3];
                byArray[n2++] = this.metadata.PLTE_blue[n3];
                ++n3;
            }
            chunkStream.write(byArray);
            chunkStream.finish();
        }
    }

    private void write_hIST() throws IOException, IIOException {
        if (this.metadata.hIST_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.hIST_TYPE, this.stream);
            if (!this.metadata.PLTE_present) {
                throw new IIOException("hIST chunk without PLTE chunk!");
            }
            chunkStream.writeChars(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
            chunkStream.finish();
        }
    }

    private void write_tRNS() throws IOException, IIOException {
        if (this.metadata.tRNS_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.tRNS_TYPE, this.stream);
            int n = this.metadata.IHDR_colorType;
            if (this.metadata.tRNS_colorType != n) {
                this.processWarningOccurred(0, "tRNS metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 3) {
                if (!this.metadata.PLTE_present) {
                    throw new IIOException("tRNS chunk without PLTE chunk!");
                }
                chunkStream.write(this.metadata.tRNS_alpha);
            } else if (n == 0) {
                chunkStream.writeShort(this.metadata.tRNS_gray);
            } else if (n == 2) {
                chunkStream.writeShort(this.metadata.tRNS_red);
                chunkStream.writeShort(this.metadata.tRNS_green);
                chunkStream.writeShort(this.metadata.tRNS_blue);
            } else {
                throw new IIOException("tRNS chunk for color type 4 or 6!");
            }
            chunkStream.finish();
        }
    }

    private void write_bKGD() throws IOException {
        if (this.metadata.bKGD_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.bKGD_TYPE, this.stream);
            int n = this.metadata.IHDR_colorType;
            if (this.metadata.bKGD_colorType != (n & 3)) {
                this.processWarningOccurred(0, "bKGD metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 3) {
                chunkStream.writeByte(this.metadata.bKGD_index);
            } else if (n == 0 || n == 4) {
                chunkStream.writeShort(this.metadata.bKGD_gray);
            } else {
                chunkStream.writeShort(this.metadata.bKGD_red);
                chunkStream.writeShort(this.metadata.bKGD_green);
                chunkStream.writeShort(this.metadata.bKGD_blue);
            }
            chunkStream.finish();
        }
    }

    private void write_pHYs() throws IOException {
        if (this.metadata.pHYs_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.pHYs_TYPE, this.stream);
            chunkStream.writeInt(this.metadata.pHYs_pixelsPerUnitXAxis);
            chunkStream.writeInt(this.metadata.pHYs_pixelsPerUnitYAxis);
            chunkStream.writeByte(this.metadata.pHYs_unitSpecifier);
            chunkStream.finish();
        }
    }

    private void write_sPLT() throws IOException {
        if (this.metadata.sPLT_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.sPLT_TYPE, this.stream);
            chunkStream.writeBytes(this.metadata.sPLT_paletteName);
            chunkStream.writeByte(0);
            chunkStream.writeByte(this.metadata.sPLT_sampleDepth);
            int n = this.metadata.sPLT_red.length;
            if (this.metadata.sPLT_sampleDepth == 8) {
                int n2 = 0;
                while (n2 < n) {
                    chunkStream.writeByte(this.metadata.sPLT_red[n2]);
                    chunkStream.writeByte(this.metadata.sPLT_green[n2]);
                    chunkStream.writeByte(this.metadata.sPLT_blue[n2]);
                    chunkStream.writeByte(this.metadata.sPLT_alpha[n2]);
                    chunkStream.writeShort(this.metadata.sPLT_frequency[n2]);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    chunkStream.writeShort(this.metadata.sPLT_red[n3]);
                    chunkStream.writeShort(this.metadata.sPLT_green[n3]);
                    chunkStream.writeShort(this.metadata.sPLT_blue[n3]);
                    chunkStream.writeShort(this.metadata.sPLT_alpha[n3]);
                    chunkStream.writeShort(this.metadata.sPLT_frequency[n3]);
                    ++n3;
                }
            }
            chunkStream.finish();
        }
    }

    private void write_tIME() throws IOException {
        if (this.metadata.tIME_present) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.tIME_TYPE, this.stream);
            chunkStream.writeShort(this.metadata.tIME_year);
            chunkStream.writeByte(this.metadata.tIME_month);
            chunkStream.writeByte(this.metadata.tIME_day);
            chunkStream.writeByte(this.metadata.tIME_hour);
            chunkStream.writeByte(this.metadata.tIME_minute);
            chunkStream.writeByte(this.metadata.tIME_second);
            chunkStream.finish();
        }
    }

    private void write_tEXt() throws IOException {
        Iterator iterator = ((AbstractList)this.metadata.tEXt_keyword).iterator();
        Iterator iterator2 = ((AbstractList)this.metadata.tEXt_text).iterator();
        while (iterator.hasNext()) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.tEXt_TYPE, this.stream);
            String string = (String)iterator.next();
            chunkStream.writeBytes(string);
            chunkStream.writeByte(0);
            String string2 = (String)iterator2.next();
            chunkStream.writeBytes(string2);
            chunkStream.finish();
        }
    }

    private void write_zTXt() throws IOException {
        Iterator iterator = ((AbstractList)this.metadata.zTXt_keyword).iterator();
        Iterator iterator2 = ((AbstractList)this.metadata.zTXt_compressionMethod).iterator();
        Iterator iterator3 = ((AbstractList)this.metadata.zTXt_compressedText).iterator();
        while (iterator.hasNext()) {
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.zTXt_TYPE, this.stream);
            String string = (String)iterator.next();
            chunkStream.writeBytes(string);
            chunkStream.writeByte(0);
            int n = (Integer)iterator2.next();
            chunkStream.writeByte(n);
            byte[] byArray = (byte[])iterator3.next();
            chunkStream.write(byArray);
            chunkStream.finish();
        }
    }

    private void writeUnknownChunks() throws IOException {
        Iterator iterator = ((AbstractList)this.metadata.unknownChunkType).iterator();
        Iterator iterator2 = ((AbstractList)this.metadata.unknownChunkData).iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string = (String)iterator.next();
            ChunkStream chunkStream = new ChunkStream(PNGImageReader.chunkType(string), this.stream);
            byte[] byArray = (byte[])iterator2.next();
            chunkStream.write(byArray);
            chunkStream.finish();
        }
    }

    private static int clamp(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    private void encodePass(ImageOutputStream imageOutputStream, RenderedImage renderedImage, int n, int n2, int n3, int n4) throws IOException {
        int n5 = renderedImage.getMinX();
        int n6 = renderedImage.getMinY();
        int n7 = renderedImage.getWidth();
        int n8 = renderedImage.getHeight();
        int n9 = 8 / this.metadata.IHDR_bitDepth;
        int n10 = n7 * this.numBands;
        int[] nArray = new int[n10];
        int n11 = (n10 - (n *= this.numBands) + (n3 *= this.numBands) - 1) / n3;
        int n12 = n11 * this.numBands;
        if (this.metadata.IHDR_bitDepth < 8) {
            n12 = (n12 + n9 - 1) / n9;
        } else if (this.metadata.IHDR_bitDepth == 16) {
            n12 *= 2;
        }
        if (n12 == 0) {
            return;
        }
        this.currRow = new byte[n12 + this.bpp];
        this.prevRow = new byte[n12 + this.bpp];
        this.filteredRows = new byte[5][n12 + this.bpp];
        int n13 = (1 << this.metadata.IHDR_bitDepth) - 1;
        int n14 = n6 + n2;
        while (n14 < n6 + n8) {
            int n15;
            Rectangle rectangle = new Rectangle(n5, n14, n7, 1);
            Raster raster = renderedImage.getData(rectangle);
            raster.getPixels(n5, n14, n7, 1, nArray);
            int n16 = this.bpp;
            int n17 = 0;
            int n18 = 0;
            switch (this.metadata.IHDR_bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n19;
                    int n20 = n9 - 1;
                    int n21 = n;
                    while (n21 < n10) {
                        n19 = PNGImageWriter.clamp(nArray[n21] >> this.bitShift, n13);
                        n18 = n18 << this.metadata.IHDR_bitDepth | n19;
                        if ((n17++ & n20) == n20) {
                            this.currRow[n16++] = (byte)n18;
                            n18 = 0;
                        }
                        n21 += n3;
                    }
                    if ((n17 & n20) == 0) break;
                    this.currRow[n16++] = (byte)(n18 <<= (8 / this.metadata.IHDR_bitDepth - n17) * this.metadata.IHDR_bitDepth);
                    break;
                }
                case 8: {
                    int n22;
                    int n19 = n;
                    while (n19 < n10) {
                        n22 = 0;
                        while (n22 < this.numBands) {
                            this.currRow[n16++] = (byte)PNGImageWriter.clamp(nArray[n19 + n22] >> this.bitShift, n13);
                            ++n22;
                        }
                        n19 += n3;
                    }
                    break;
                }
                case 16: {
                    int n22 = n;
                    while (n22 < n10) {
                        n15 = 0;
                        while (n15 < this.numBands) {
                            int n23 = PNGImageWriter.clamp(nArray[n22 + n15] >> this.bitShift, n13);
                            this.currRow[n16++] = (byte)(n23 >> 8);
                            this.currRow[n16++] = (byte)(n23 & 0xFF);
                            ++n15;
                        }
                        n22 += n3;
                    }
                    break;
                }
            }
            n15 = this.rowFilter.filterRow(this.metadata.IHDR_colorType, this.currRow, this.prevRow, this.filteredRows, n12, this.bpp);
            imageOutputStream.write(n15);
            imageOutputStream.write(this.filteredRows[n15], this.bpp, n12);
            byte[] byArray = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = byArray;
            n14 += n4;
        }
    }

    private void writeIDAT(RenderedImage renderedImage) throws IOException {
        IDATOutputStream iDATOutputStream = new IDATOutputStream(this.stream, 8192);
        if (this.metadata.IHDR_interlaceMethod == 1) {
            int n = 0;
            while (n < 7) {
                this.encodePass(iDATOutputStream, renderedImage, PNGImageReader.adam7XOffset[n], PNGImageReader.adam7YOffset[n], PNGImageReader.adam7XSubsampling[n], PNGImageReader.adam7YSubsampling[n]);
                ++n;
            }
        } else {
            this.encodePass(iDATOutputStream, renderedImage, 0, 0, 1, 1);
        }
        iDATOutputStream.finish();
    }

    private void writeIEND() throws IOException {
        ChunkStream chunkStream = new ChunkStream(PNGImageReader.IEND_TYPE, this.stream);
        chunkStream.finish();
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("image has a Raster!");
        }
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        this.metadata = iIOMetadata2 != null ? (PNGMetadata)this.convertImageMetadata(iIOMetadata2, ImageTypeSpecifier.createFromRenderedImage(renderedImage), null) : new PNGMetadata();
        this.metadata.initialize(new ImageTypeSpecifier(renderedImage));
        this.metadata.IHDR_width = renderedImage.getWidth();
        this.metadata.IHDR_height = renderedImage.getHeight();
        if (imageWriteParam != null) {
            switch (imageWriteParam.getProgressiveMode()) {
                case 1: {
                    this.metadata.IHDR_interlaceMethod = 1;
                    break;
                }
                case 0: {
                    this.metadata.IHDR_interlaceMethod = 0;
                }
            }
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBands = sampleModel.getNumBands();
        this.bpp = this.numBands * (this.metadata.IHDR_bitDepth == 16 ? 2 : 1);
        this.bitShift = 0;
        try {
            this.write_magic();
            this.write_IHDR();
            this.write_cHRM();
            this.write_gAMA();
            this.write_iCCP();
            this.write_sBIT();
            this.write_sRGB();
            this.write_PLTE();
            this.write_hIST();
            this.write_tRNS();
            this.write_bKGD();
            this.write_pHYs();
            this.write_sPLT();
            this.write_tIME();
            this.write_tEXt();
            this.write_zTXt();
            this.writeUnknownChunks();
            this.writeIDAT(renderedImage);
            this.writeIEND();
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error writing PNG header!", iOException);
        }
    }
}

