/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOAttr;
import javax.imageio.metadata.IIODOMException;
import javax.imageio.metadata.IIONamedNodeMap;
import javax.imageio.metadata.IIONodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IIOMetadataNode
implements Element,
NodeList {
    private String nodeName = null;
    private String nodeValue = null;
    private Object userObject = null;
    private IIOMetadataNode parent = null;
    private int numChildren = 0;
    private IIOMetadataNode firstChild = null;
    private IIOMetadataNode lastChild = null;
    private IIOMetadataNode nextSibling = null;
    private IIOMetadataNode previousSibling = null;
    private List attributes = new ArrayList();

    public IIOMetadataNode() {
    }

    public IIOMetadataNode(String string) {
        this.nodeName = string;
    }

    private void checkNode(Node node) throws DOMException {
        if (node == null) {
            return;
        }
        if (!(node instanceof IIOMetadataNode)) {
            throw new IIODOMException(4, "Node not an IIOMetadataNode!");
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public void setNodeValue(String string) throws DOMException {
        this.nodeValue = string;
    }

    public short getNodeType() {
        return 1;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return new IIONamedNodeMap(this.attributes);
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(node);
        this.checkNode(node2);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)node2;
        IIOMetadataNode iIOMetadataNode3 = null;
        IIOMetadataNode iIOMetadataNode4 = null;
        if (node2 == null) {
            iIOMetadataNode3 = this.lastChild;
            iIOMetadataNode4 = null;
            this.lastChild = iIOMetadataNode;
        } else {
            iIOMetadataNode3 = iIOMetadataNode2.previousSibling;
            iIOMetadataNode4 = iIOMetadataNode2;
        }
        if (iIOMetadataNode3 != null) {
            iIOMetadataNode3.nextSibling = iIOMetadataNode;
        }
        if (iIOMetadataNode4 != null) {
            iIOMetadataNode4.previousSibling = iIOMetadataNode;
        }
        iIOMetadataNode.parent = this;
        iIOMetadataNode.previousSibling = iIOMetadataNode3;
        iIOMetadataNode.nextSibling = iIOMetadataNode4;
        if (this.firstChild == iIOMetadataNode2) {
            this.firstChild = iIOMetadataNode;
        }
        ++this.numChildren;
        return iIOMetadataNode;
    }

    public Node replaceChild(Node node, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(node);
        this.checkNode(node2);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)node2;
        IIOMetadataNode iIOMetadataNode3 = iIOMetadataNode2.previousSibling;
        IIOMetadataNode iIOMetadataNode4 = iIOMetadataNode2.nextSibling;
        if (iIOMetadataNode3 != null) {
            iIOMetadataNode3.nextSibling = iIOMetadataNode;
        }
        if (iIOMetadataNode4 != null) {
            iIOMetadataNode4.previousSibling = iIOMetadataNode;
        }
        iIOMetadataNode.parent = this;
        iIOMetadataNode.previousSibling = iIOMetadataNode3;
        iIOMetadataNode.nextSibling = iIOMetadataNode4;
        if (this.firstChild == iIOMetadataNode2) {
            this.firstChild = iIOMetadataNode;
        }
        if (this.lastChild == iIOMetadataNode2) {
            this.lastChild = iIOMetadataNode;
        }
        iIOMetadataNode2.parent = null;
        iIOMetadataNode2.previousSibling = null;
        iIOMetadataNode2.nextSibling = null;
        return iIOMetadataNode2;
    }

    public Node removeChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.checkNode(node);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        IIOMetadataNode iIOMetadataNode2 = iIOMetadataNode.previousSibling;
        IIOMetadataNode iIOMetadataNode3 = iIOMetadataNode.nextSibling;
        if (iIOMetadataNode2 != null) {
            iIOMetadataNode2.nextSibling = iIOMetadataNode3;
        }
        if (iIOMetadataNode3 != null) {
            iIOMetadataNode3.previousSibling = iIOMetadataNode2;
        }
        if (this.firstChild == iIOMetadataNode) {
            this.firstChild = iIOMetadataNode3;
        }
        if (this.lastChild == iIOMetadataNode) {
            this.lastChild = iIOMetadataNode2;
        }
        iIOMetadataNode.parent = null;
        iIOMetadataNode.previousSibling = null;
        iIOMetadataNode.nextSibling = null;
        --this.numChildren;
        return iIOMetadataNode;
    }

    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.checkNode(node);
        ++this.numChildren;
        return this.insertBefore(node, null);
    }

    public boolean hasChildNodes() {
        return this.numChildren > 0;
    }

    public Node cloneNode(boolean bl) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.nodeName);
        iIOMetadataNode.setUserObject(this.getUserObject());
        if (bl) {
            IIOMetadataNode iIOMetadataNode2 = this.firstChild;
            while (iIOMetadataNode2 != null) {
                iIOMetadataNode.appendChild(iIOMetadataNode2.cloneNode(true));
                iIOMetadataNode2 = iIOMetadataNode2.nextSibling;
            }
        }
        return iIOMetadataNode;
    }

    public void normalize() {
    }

    public boolean supports(String string, String string2) {
        throw new RuntimeException("Not implemented!");
    }

    public String getNamespaceURI() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public String getPrefix() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setPrefix(String string) throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public String getLocalName() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public String getTagName() {
        return this.nodeName;
    }

    public String getAttribute(String string) {
        return this.getAttributeNode(string).getValue();
    }

    public String getAttributeNS(String string, String string2) {
        return this.getAttribute(string2);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.add(new IIOAttr(this, string, string2));
    }

    public void setAttributeNS(String string, String string2, String string3) {
        this.setAttribute(string2, string3);
    }

    public void removeAttribute(String string) {
        int n = this.attributes.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)this.attributes.get(n2);
            if (string.equals(attr.getName())) {
                this.attributes.remove(n2);
                return;
            }
            ++n2;
        }
    }

    public void removeAttributeNS(String string, String string2) {
        this.removeAttribute(string2);
    }

    public Attr getAttributeNode(String string) {
        Node node = this.getAttributes().getNamedItem(string);
        return (Attr)node;
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return this.getAttributeNode(string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (!(attr instanceof IIOAttr)) {
            throw new IIODOMException(4, "Node not an IIOAttr!");
        }
        this.attributes.add(attr);
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return this.setAttributeNode(attr);
    }

    public Attr removeAttributeNode(Attr attr) {
        this.removeAttribute(attr.getName());
        return attr;
    }

    public NodeList getElementsByTagName(String string) {
        ArrayList arrayList = new ArrayList();
        this.getElementsByTagName(string, arrayList);
        return new IIONodeList(arrayList);
    }

    private void getElementsByTagName(String string, List list) {
        if (this.nodeName.equals(string)) {
            list.add(this);
        }
        Node node = this.getFirstChild();
        while (node != null) {
            ((IIOMetadataNode)node).getElementsByTagName(string, list);
            node = node.getNextSibling();
        }
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.getElementsByTagName(string2);
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.hasAttribute(string2);
    }

    public int getLength() {
        return this.numChildren;
    }

    public Node item(int n) {
        if (n < 0) {
            return null;
        }
        Node node = this.getFirstChild();
        while (node != null && n-- > 0) {
            node = node.getNextSibling();
        }
        return node;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }
}

