/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import java.io.File;
import java.io.Serializable;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Vector;

public class ServerGrid
implements SQLData,
Serializable {
    private int type;
    private String name;
    private int units;
    private String fileName;
    private double cellSize;
    private int nRows;
    private int nColumns;
    private double xLLCorner;
    private double yLLCorner;
    private double xURCorner;
    private double yURCorner;
    private int noDataValue = -9999;
    private File inFile;
    private File outFile;
    private Vector z;
    private double zMax = -9999999.0;
    private double zMin = 9999999.0;
    private String sql_type;

    public ServerGrid(String string, int n, int n2, String string2, double d, int n3, int n4, double d2, double d3, int n5, Vector vector) {
        this.name = string;
        this.type = n;
        this.units = n2;
        this.fileName = string2;
        this.cellSize = d;
        this.nRows = n3;
        this.nColumns = n4;
        this.xLLCorner = d2;
        this.yLLCorner = d3;
        this.noDataValue = n5;
        this.z = vector;
        System.out.println("ServerGrid.constructor(...), name : " + this.name);
    }

    public ServerGrid() {
        this.name = "noName";
        this.type = 0;
        this.units = 0;
        this.fileName = "noFileName";
        this.cellSize = 0.0;
        this.nRows = 0;
        this.nColumns = 0;
        this.xLLCorner = 0.0;
        this.yLLCorner = 0.0;
        this.noDataValue = -9999;
        this.z = new Vector();
        System.out.println("ServerGrid.constructor(), name : " + this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getUnits() {
        return this.units;
    }

    public String getFileName() {
        return this.fileName;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public int getNRows() {
        return this.nRows;
    }

    public int getNColumns() {
        return this.nColumns;
    }

    public double getXLLCorner() {
        return this.xLLCorner;
    }

    public double getYLLCorner() {
        return this.yLLCorner;
    }

    public int getNoDataValue() {
        return this.noDataValue;
    }

    public Vector getZ() {
        return this.z;
    }

    public String toString() {
        return this.name;
    }

    public String getSQLTypeName() {
        return this.sql_type;
    }

    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        this.sql_type = string;
        this.name = sQLInput.readString();
        this.type = Double.valueOf(sQLInput.readString()).intValue();
        this.units = Double.valueOf(sQLInput.readString()).intValue();
        this.fileName = sQLInput.readString();
        this.cellSize = Double.valueOf(sQLInput.readString());
        this.xLLCorner = Double.valueOf(sQLInput.readString());
        this.yLLCorner = Double.valueOf(sQLInput.readString());
        this.noDataValue = Double.valueOf(sQLInput.readString()).intValue();
        this.nRows = Double.valueOf(sQLInput.readString()).intValue();
        this.nColumns = Double.valueOf(sQLInput.readString()).intValue();
        this.z = new Vector();
        int n = 0;
        while (n < this.nRows) {
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < this.nColumns) {
                String string2 = sQLInput.readString();
                vector.add(string2);
                ++n2;
            }
            this.z.add(vector);
            ++n;
        }
        System.out.println("ServerGrid.readSQL():");
        System.out.println("name : " + this.name);
        System.out.println("type : " + this.type);
        System.out.println("units : " + this.units);
        System.out.println("fileName : " + this.fileName);
        System.out.println("cellSize : " + this.cellSize);
        System.out.println("nRows : " + this.nRows);
        System.out.println("nColumns : " + this.nColumns);
        System.out.println("xLLCorner : " + this.xLLCorner);
        System.out.println("yLLCorner : " + this.yLLCorner);
        System.out.println("noDataValue : " + this.noDataValue);
    }

    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeString(this.name);
        sQLOutput.writeString(String.valueOf(this.type));
        sQLOutput.writeString(String.valueOf(this.units));
        sQLOutput.writeString(this.fileName);
        sQLOutput.writeString(String.valueOf(this.cellSize));
        sQLOutput.writeString(String.valueOf(this.xLLCorner));
        sQLOutput.writeString(String.valueOf(this.yLLCorner));
        sQLOutput.writeString(String.valueOf(this.noDataValue));
        sQLOutput.writeString(String.valueOf(this.nRows));
        sQLOutput.writeString(String.valueOf(this.nColumns));
        int n = 0;
        while (n < this.z.size()) {
            Vector vector = (Vector)this.z.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                String string = (String)vector.elementAt(n2);
                sQLOutput.writeString(string);
                ++n2;
            }
            ++n;
        }
        System.out.println("ServerGrid.writeSQL():");
        System.out.println("name : " + this.name);
        System.out.println("type : " + this.type);
        System.out.println("units : " + this.units);
        System.out.println("fileName : " + this.fileName);
        System.out.println("cellSize : " + this.cellSize);
        System.out.println("nRows : " + this.nRows);
        System.out.println("nColumns : " + this.nColumns);
        System.out.println("xLLCorner : " + this.xLLCorner);
        System.out.println("yLLCorner : " + this.yLLCorner);
        System.out.println("noDataValue : " + this.noDataValue);
    }
}

