/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import sun.jdbc.rowset.SerialBlob;
import sun.jdbc.rowset.SerialClob;
import sun.jdbc.rowset.SerialStruct;

class SerialArray
implements Array,
Serializable,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;

    SerialArray(Array array, Map map) throws SQLException {
        this.elements = (Object[])array.getArray(map);
        this.baseType = this.getBaseType();
        this.baseTypeName = this.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialStruct((Struct)this.elements[n], map);
                    ++n;
                }
                break;
            }
            case 2003: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialArray((Array)this.elements[n], map);
                    ++n;
                }
                break;
            }
            case 2004: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialBlob((Blob)this.elements[n]);
                    ++n;
                }
                break;
            }
            case 2005: {
                int n = 0;
                while (n < this.len) {
                    this.elements[n] = new SerialClob((Clob)this.elements[n]);
                    ++n;
                }
                break;
            }
        }
    }

    public Object getArray() throws SQLException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public Object getArray(long l, int n) throws SQLException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    public Object getArray(Map map) throws SQLException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

