/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageReader {
    protected ImageReaderSpi originatingProvider;
    protected Object input = null;
    protected boolean seekForwardOnly = false;
    protected int minIndex = 0;
    protected boolean abortFlag = false;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected List warningListeners = null;
    protected List warningLocales = null;
    protected List progressListeners = null;
    protected List updateListeners = null;

    protected ImageReader(ImageReaderSpi imageReaderSpi) {
        this.originatingProvider = imageReaderSpi;
    }

    public String getFormatName() throws IIOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setInput(Object object, boolean bl) {
        if (object != null) {
            this.seekForwardOnly = bl;
            this.minIndex = 0;
            boolean bl2 = false;
            if (this.originatingProvider != null) {
                Class[] classArray = this.originatingProvider.getInputTypes();
                int n = 0;
                while (n < classArray.length) {
                    if (classArray[n].isInstance(object)) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
            } else if (object instanceof ImageInputStream) {
                bl2 = true;
            }
            if (!bl2) {
                throw new IllegalArgumentException();
            }
        }
        this.input = object;
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            Locale[] localeArray = this.getAvailableLocales();
            boolean bl = false;
            if (localeArray != null) {
                int n = 0;
                while (n < localeArray.length) {
                    if (locale.equals(localeArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid locale!");
            }
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IIOException;

    public abstract int getWidth(int var1) throws IIOException;

    public abstract int getHeight(int var1) throws IIOException;

    public boolean isRandomAccessEasy(int n) throws IIOException {
        return false;
    }

    public float getAspectRatio(int n) throws IIOException {
        return (float)this.getWidth(n) / (float)this.getHeight(n);
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IIOException {
        return (ImageTypeSpecifier)this.getImageTypes(n).next();
    }

    public abstract Iterator getImageTypes(int var1) throws IIOException;

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam(false);
    }

    public abstract IIOMetadata getStreamMetadata() throws IIOException;

    public IIOMetadata getStreamMetadata(String string, Set set) throws IIOException {
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (set == null) {
            throw new IllegalArgumentException("nodeNames == null!");
        }
        IIOMetadata iIOMetadata = this.getStreamMetadata();
        String[] stringArray = iIOMetadata.getMetadataFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return iIOMetadata;
            }
            ++n;
        }
        return null;
    }

    public abstract IIOMetadata getImageMetadata(int var1) throws IIOException;

    public IIOMetadata getImageMetadata(int n, String string, Set set) throws IIOException {
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (set == null) {
            throw new IllegalArgumentException("nodeNames == null!");
        }
        IIOMetadata iIOMetadata = this.getImageMetadata(n);
        String[] stringArray = iIOMetadata.getMetadataFormatNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                return iIOMetadata;
            }
            ++n2;
        }
        return null;
    }

    public BufferedImage read(int n) throws IIOException {
        return this.read(n, null);
    }

    protected Rectangle getSourceRegion(ImageReadParam imageReadParam, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        if (imageReadParam != null) {
            Rectangle rectangle2 = imageReadParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n3 = imageReadParam.getSubsamplingXOffset();
            int n4 = imageReadParam.getSubsamplingYOffset();
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    protected void checkReadParamBandSettings(ImageReadParam imageReadParam, int n, int n2) {
        int n3;
        int n4;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        int n5 = nArray == null ? n : nArray.length;
        int n6 = n4 = nArray2 == null ? n2 : nArray2.length;
        if (n5 != n4) {
            throw new IllegalArgumentException("ImageReadParam num source & dest bands differ!");
        }
        if (nArray != null) {
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] >= n) {
                    throw new IllegalArgumentException("ImageReadParam source bands contains a value >= the number of source bands!");
                }
                ++n3;
            }
        }
        if (nArray2 != null) {
            n3 = 0;
            while (n3 < nArray2.length) {
                if (nArray2[n3] >= n2) {
                    throw new IllegalArgumentException("ImageReadParam dest bands contains a value >= the number of dest bands!");
                }
                ++n3;
            }
        }
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IIOException;

    public IIOImage readAll(int n, ImageReadParam imageReadParam) throws IIOException {
        if (n < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("imageIndex < getMinIndex()!");
        }
        BufferedImage bufferedImage = this.read(n);
        List list = null;
        int n2 = this.getNumThumbnails(n);
        int n3 = 0;
        while (n3 < n2) {
            list.add(this.readThumbnail(n, n3));
            ++n3;
        }
        IIOMetadata iIOMetadata = this.getImageMetadata(n);
        return new IIOImage(bufferedImage, list, iIOMetadata);
    }

    public Iterator readAll(Iterator iterator) throws IIOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        int n = this.getMinIndex();
        this.processSequenceStarted(n);
        while (true) {
            BufferedImage bufferedImage;
            ImageReadParam imageReadParam = null;
            if (iterator != null && iterator.hasNext() && (bufferedImage = (BufferedImage)iterator.next()) != null) {
                if (bufferedImage instanceof ImageReadParam) {
                    imageReadParam = (ImageReadParam)iterator.next();
                } else {
                    throw new IllegalArgumentException();
                }
            }
            bufferedImage = null;
            try {
                bufferedImage = this.read(n, imageReadParam);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            List list = null;
            int n2 = this.getNumThumbnails(n);
            int n3 = 0;
            while (n3 < n2) {
                list.add(this.readThumbnail(n, n3));
                ++n3;
            }
            IIOMetadata iIOMetadata = this.getImageMetadata(n);
            IIOImage iIOImage = new IIOImage(bufferedImage, list, iIOMetadata);
            arrayList.add(iIOImage);
            ++n;
        }
        this.processSequenceComplete();
        return arrayList.iterator();
    }

    public boolean canReadRaster() {
        return false;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IIOException {
        throw new UnsupportedOperationException();
    }

    public boolean isImageTiled(int n) throws IIOException {
        return false;
    }

    public int getTileWidth(int n) throws IIOException {
        return this.getWidth(n);
    }

    public int getTileHeight(int n) throws IIOException {
        return this.getHeight(n);
    }

    public int getTileGridXOffset(int n) throws IIOException {
        return 0;
    }

    public int getTileGridYOffset(int n) throws IIOException {
        return 0;
    }

    public BufferedImage readTile(int n, int n2, int n3) throws IIOException {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.read(n);
    }

    public Raster readTileRaster(int n, int n2, int n3) throws IIOException {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.readRaster(n, null);
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IIOException {
        return this.read(n, imageReadParam);
    }

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public boolean hasThumbnails(int n) throws IIOException {
        return this.getNumThumbnails(n) > 0;
    }

    public int getNumThumbnails(int n) throws IIOException {
        return 0;
    }

    public int getThumbnailWidth(int n, int n2) throws IIOException {
        return this.readThumbnail(n, n2).getWidth();
    }

    public int getThumbnailHeight(int n, int n2) throws IIOException {
        return this.readThumbnail(n, n2).getHeight();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IIOException {
        throw new UnsupportedOperationException("Thumbnails not supported!");
    }

    public void abort() {
        this.abortFlag = true;
    }

    static List addToList(List arrayList, Object object) {
        if (object == null) {
            return arrayList;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        arrayList.add(object);
        return arrayList;
    }

    static List removeFromList(List list, Object object) {
        if (list == null || object == null) {
            return list;
        }
        list.remove(object);
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        this.warningListeners = ImageReader.addToList(this.warningListeners, iIOReadWarningListener);
        this.warningLocales = ImageReader.addToList(this.warningLocales, this.getLocale());
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null || this.warningListeners == null) {
            return;
        }
        int n = this.warningListeners.indexOf(iIOReadWarningListener);
        if (n != -1) {
            this.warningListeners.remove(n);
            this.warningLocales.remove(n);
            if (this.warningListeners.size() == 0) {
                this.warningLocales = null;
                this.warningListeners = null;
            }
        }
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.progressListeners = ImageReader.addToList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.progressListeners = ImageReader.removeFromList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        this.updateListeners = ImageReader.addToList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        this.updateListeners = ImageReader.removeFromList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    protected void processSequenceStarted(int n) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.sequenceStarted(this, n);
            ++n3;
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.sequenceComplete(this);
            ++n2;
        }
    }

    protected void processImageStarted(int n) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n3);
            iIOReadProgressListener.imageStarted(this, n);
            ++n3;
        }
    }

    protected void processImageProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.imageProgress(this, f);
            ++n2;
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.imageComplete(this);
            ++n2;
        }
    }

    protected void processThumbnailStarted(int n, int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n4);
            iIOReadProgressListener.thumbnailStarted(this, n, n2);
            ++n4;
        }
    }

    protected void processThumbnailProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.thumbnailProgress(this, f);
            ++n2;
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.thumbnailComplete(this);
            ++n2;
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)this.progressListeners.get(n2);
            iIOReadProgressListener.readAborted(this);
            ++n2;
        }
    }

    protected void processPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        int n9 = 0;
        while (n9 < n8) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n9);
            iIOReadUpdateListener.passStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
            ++n9;
        }
    }

    protected void processImageUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n7 = this.updateListeners.size();
        int n8 = 0;
        while (n8 < n7) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n8);
            iIOReadUpdateListener.imageUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
            ++n8;
        }
    }

    protected void processPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n = this.updateListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n2);
            iIOReadUpdateListener.passComplete(this, bufferedImage);
            ++n2;
        }
    }

    protected void processThumbnailPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        int n9 = 0;
        while (n9 < n8) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n9);
            iIOReadUpdateListener.thumbnailPassStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
            ++n9;
        }
    }

    protected void processThumbnailUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n7 = this.updateListeners.size();
        int n8 = 0;
        while (n8 < n7) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n8);
            iIOReadUpdateListener.thumbnailUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
            ++n8;
        }
    }

    protected void processThumbnailPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n = this.updateListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)this.updateListeners.get(n2);
            iIOReadUpdateListener.thumbnailPassComplete(this, bufferedImage);
            ++n2;
        }
    }

    protected void processWarningOccurred(String string) {
        if (this.warningListeners == null) {
            return;
        }
        int n = this.warningListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)this.warningListeners.get(n2);
            iIOReadWarningListener.warningOccurred(this, string);
            ++n2;
        }
    }

    protected void processWarningOccurred(String string, String string2) {
        if (this.warningListeners == null) {
            return;
        }
        int n = this.warningListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)this.warningListeners.get(n2);
            Locale locale = (Locale)this.warningLocales.get(n2);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            String string3 = resourceBundle.getString(string2);
            iIOReadWarningListener.warningOccurred(this, string3);
            ++n2;
        }
    }

    public void reset() {
        this.setInput(null, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadProgressListeners();
        this.removeAllIIOReadWarningListeners();
        this.abortFlag = false;
    }

    public void dispose() {
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator iterator, int n, int n2) throws IIOException {
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = 1;
        int n8 = 1;
        int n9 = 0;
        int n10 = 0;
        Point point = new Point(0, 0);
        if (imageReadParam != null) {
            bufferedImage = imageReadParam.getDestination();
            if (bufferedImage != null) {
                return bufferedImage;
            }
            imageTypeSpecifier = imageReadParam.getDestinationType();
            Rectangle rectangle = imageReadParam.getSourceRegion();
            if (rectangle != null) {
                n3 = rectangle.x;
                n4 = rectangle.y;
                n5 = rectangle.width;
                n6 = rectangle.height;
            }
            n7 = imageReadParam.getSourceXSubsampling();
            n8 = imageReadParam.getSourceYSubsampling();
            n9 = imageReadParam.getSubsamplingXOffset();
            n10 = imageReadParam.getSubsamplingYOffset();
            point = imageReadParam.getDestinationOffset();
        }
        if (imageTypeSpecifier == null) {
            imageTypeSpecifier = (ImageTypeSpecifier)iterator.next();
        } else {
            boolean bl = false;
            while (iterator.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier2 = (ImageTypeSpecifier)iterator.next();
                if (!imageTypeSpecifier2.equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        if (n5 + n3 > n) {
            n5 = n - n3;
        }
        if (n6 + n4 > n2) {
            n6 = n2 - n4;
        }
        int n11 = (n5 - n9 + n7 - 1) / n7 + point.x;
        int n12 = (n6 - n10 + n8 - 1) / n8 + point.y;
        if (n11 < 1) {
            n11 = 1;
        }
        if (n12 < 1) {
            n12 = 1;
        }
        return imageTypeSpecifier.createBufferedImage(n11, n12);
    }
}

