/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GIFImageMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "com.sun.imageio.gifimage_1.0";
    static final String[] metadataFormatNames = new String[]{"com.sun.imageio.gifimage_1.0"};
    static final String[] disposalMethodNames = new String[]{"none", "doNotDispose", "restoreToBackgroundColor", "restoreToPrevious", "undefinedDisposalMethod4", "undefinedDisposalMethod5", "undefinedDisposalMethod6", "undefinedDisposalMethod7"};
    public int imageLeftPosition;
    public int imageTopPosition;
    public int imageWidth;
    public int imageHeight;
    public boolean localColorTableFlag = false;
    public boolean interlaceFlag = false;
    public boolean sortFlag = false;
    public int sizeOfLocalColorTable = 0;
    public byte[] localColorTable = null;
    public int disposalMethod = 0;
    public boolean userInputFlag = false;
    public boolean transparentColorFlag = false;
    public int delayTime = 0;
    public int transparentColorIndex = 0;
    public boolean hasPlainTextExtension = false;
    public int textGridLeft;
    public int textGridRight;
    public int textGridWidth;
    public int textGridHeight;
    public int characterCellWidth;
    public int characterCellHeight;
    public int textForegroundColor;
    public int textBackgroundColor;
    public byte[] text;
    public List applicationIDs = null;
    public List authenticationCodes = null;
    public List applicationData = null;
    public List comments = null;

    public GIFImageMetadata() {
        super(nativeMetadataFormatName, metadataFormatNames);
    }

    public boolean isReadOnly() {
        return true;
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return null;
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private String toISO8859(byte[] byArray) {
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode;
        int n;
        int n2;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ImageDescriptor");
        iIOMetadataNode3.setAttribute("imageLeftPosition", Integer.toString(this.imageLeftPosition));
        iIOMetadataNode3.setAttribute("imageTopPosition", Integer.toString(this.imageLeftPosition));
        iIOMetadataNode3.setAttribute("imageWidth", Integer.toString(this.imageWidth));
        iIOMetadataNode3.setAttribute("imageHeight", Integer.toString(this.imageHeight));
        iIOMetadataNode3.setAttribute("localColorTableFlag", this.localColorTableFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("interlaceFlag", this.interlaceFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("sortFlag", this.sortFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("sizeOfLocalColorTable", Integer.toString(this.sizeOfLocalColorTable));
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        if (this.localColorTable != null) {
            iIOMetadataNode3 = new IIOMetadataNode("LocalColorTable");
            n2 = this.localColorTable.length / 3;
            n = 0;
            while (n < n2) {
                iIOMetadataNode = new IIOMetadataNode("ColorTableEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n));
                int n3 = this.localColorTable[3 * n] & 0xFF;
                int n4 = this.localColorTable[3 * n] & 0xFF;
                int n5 = this.localColorTable[3 * n] & 0xFF;
                iIOMetadataNode.setAttribute("red", Integer.toString(n3));
                iIOMetadataNode.setAttribute("green", Integer.toString(n3));
                iIOMetadataNode.setAttribute("blue", Integer.toString(n3));
                iIOMetadataNode3.appendChild(iIOMetadataNode);
                ++n;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        iIOMetadataNode3 = new IIOMetadataNode("GraphicControlExtension");
        iIOMetadataNode3.setAttribute("disposalMethod", disposalMethodNames[this.disposalMethod]);
        iIOMetadataNode3.setAttribute("userInputFlag", this.userInputFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("transparentColorFlag", this.transparentColorFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("delayTime", Integer.toString(this.delayTime));
        iIOMetadataNode3.setAttribute("transparentColorIndex", Integer.toString(this.transparentColorIndex));
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        if (this.hasPlainTextExtension) {
            iIOMetadataNode3 = new IIOMetadataNode("PlainTextExtension");
            iIOMetadataNode3.setAttribute("textGridLeft", Integer.toString(this.textGridLeft));
            iIOMetadataNode3.setAttribute("textGridRight", Integer.toString(this.textGridRight));
            iIOMetadataNode3.setAttribute("textGridWidth", Integer.toString(this.textGridWidth));
            iIOMetadataNode3.setAttribute("textGridHeight", Integer.toString(this.textGridHeight));
            iIOMetadataNode3.setAttribute("characterCellWidth", Integer.toString(this.characterCellWidth));
            iIOMetadataNode3.setAttribute("characterCellHeight", Integer.toString(this.characterCellHeight));
            iIOMetadataNode3.setAttribute("textForegroundColor", Integer.toString(this.textForegroundColor));
            iIOMetadataNode3.setAttribute("textBackgroundColor", Integer.toString(this.textBackgroundColor));
            iIOMetadataNode3.setAttribute("text", this.toISO8859(this.text));
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        int n6 = n2 = this.applicationIDs == null ? 0 : this.applicationIDs.size();
        if (n2 > 0) {
            iIOMetadataNode3 = new IIOMetadataNode("ApplicationExtensions");
            n = 0;
            while (n < n2) {
                iIOMetadataNode = new IIOMetadataNode("ApplicationExtension");
                byte[] byArray = (byte[])this.applicationIDs.get(n);
                iIOMetadataNode.setAttribute("applicationID", this.toISO8859(byArray));
                byte[] byArray2 = (byte[])this.authenticationCodes.get(n);
                iIOMetadataNode.setAttribute("authenticationCode", this.toISO8859(byArray2));
                byte[] byArray3 = (byte[])this.applicationData.get(n);
                iIOMetadataNode.setUserObject((byte[])byArray3.clone());
                iIOMetadataNode3.appendChild(iIOMetadataNode);
                ++n;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        int n7 = n = this.comments == null ? 0 : this.comments.size();
        if (n > 0) {
            iIOMetadataNode3 = new IIOMetadataNode("CommentExtensions");
            int n8 = 0;
            while (n8 < n) {
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("CommentExtension");
                byte[] byArray = (byte[])this.comments.get(n8);
                iIOMetadataNode4.setAttribute("value", this.toISO8859(byArray));
                iIOMetadataNode3.appendChild(iIOMetadataNode4);
                ++n8;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode2;
    }

    public void setFromTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

