/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GIFStreamMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "com.sun.imageio.gifstream_1.0";
    static final String[] metadataFormatNames = new String[]{"com.sun.imageio.gifstream_1.0"};
    public String version;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundColorIndex;
    public int pixelAspectRatio;
    public boolean globalColorTableFlag;
    public int colorResolution;
    public boolean sortFlag;
    public int sizeOfGlobalColorTable;
    public byte[] globalColorTable;

    public GIFStreamMetadata() {
        super(nativeMetadataFormatName, metadataFormatNames);
    }

    public IIOMetadataFormat getMetadataFormat(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return null;
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Version");
        iIOMetadataNode2.setAttribute("value", this.version);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("LogicalScreenDescriptor");
        iIOMetadataNode2.setAttribute("logicalScreenWidth", Integer.toString(this.logicalScreenWidth));
        iIOMetadataNode2.setAttribute("logicalScreenHeight", Integer.toString(this.logicalScreenHeight));
        iIOMetadataNode2.setAttribute("backgroundColorIndex", Integer.toString(this.backgroundColorIndex));
        iIOMetadataNode2.setAttribute("pixelAspectRatio", Integer.toString(this.pixelAspectRatio));
        iIOMetadataNode2.setAttribute("globalColorTableFlag", this.globalColorTableFlag ? "true" : "false");
        iIOMetadataNode2.setAttribute("colorResolution", Integer.toString(this.colorResolution));
        iIOMetadataNode2.setAttribute("sortFlag", this.sortFlag ? "true" : "false");
        iIOMetadataNode2.setAttribute("sizeOfGlobalColorTable", Integer.toString(this.sizeOfGlobalColorTable));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.globalColorTable != null) {
            iIOMetadataNode2 = new IIOMetadataNode("GlobalColorTable");
            int n = this.globalColorTable.length / 3;
            int n2 = 0;
            while (n2 < n) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ColorTableEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n2));
                int n3 = this.globalColorTable[3 * n2] & 0xFF;
                int n4 = this.globalColorTable[3 * n2] & 0xFF;
                int n5 = this.globalColorTable[3 * n2] & 0xFF;
                iIOMetadataNode3.setAttribute("red", Integer.toString(n3));
                iIOMetadataNode3.setAttribute("green", Integer.toString(n3));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(n3));
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                ++n2;
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public void setFromTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

