/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import javax.imageio.IIOParamController;
import javax.imageio.ImageTypeSpecifier;

public abstract class IIOParam {
    protected Rectangle sourceRegion = null;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected int subsamplingXOffset = 0;
    protected int subsamplingYOffset = 0;
    protected int[] sourceBands = null;
    protected ImageTypeSpecifier destinationType = null;
    protected Point destinationOffset = new Point(0, 0);
    protected IIOParamController defaultController = null;
    protected IIOParamController controller = this.defaultController;

    protected IIOParam() {
    }

    public void setSourceRegion(Rectangle rectangle) {
        if (rectangle == null) {
            this.sourceRegion = null;
            return;
        }
        if (rectangle.x < 0 || rectangle.y < 0) {
            throw new IllegalArgumentException();
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.subsamplingXOffset >= rectangle.width || this.subsamplingYOffset >= rectangle.height) {
            throw new IllegalStateException();
        }
        this.sourceRegion = (Rectangle)rectangle.clone();
    }

    public Rectangle getSourceRegion() {
        if (this.sourceRegion == null) {
            return null;
        }
        return (Rectangle)this.sourceRegion.clone();
    }

    public void setSourceSubsampling(int n, int n2, int n3, int n4) {
        if (n <= 0 || n2 <= 0 || n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
            throw new IllegalArgumentException();
        }
        if (this.sourceRegion != null && (n3 >= this.sourceRegion.width || n4 >= this.sourceRegion.height)) {
            throw new IllegalStateException();
        }
        this.sourceXSubsampling = n;
        this.sourceYSubsampling = n2;
        this.subsamplingXOffset = n3;
        this.subsamplingYOffset = n4;
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public int getSubsamplingXOffset() {
        return this.subsamplingXOffset;
    }

    public int getSubsamplingYOffset() {
        return this.subsamplingYOffset;
    }

    public void setSourceBands(int[] nArray) {
        if (nArray == null) {
            this.sourceBands = null;
        } else {
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (n3 < 0) {
                    throw new IllegalArgumentException("Band value < 0!");
                }
                int n4 = n2 + 1;
                while (n4 < n) {
                    if (n3 == nArray[n4]) {
                        throw new IllegalArgumentException("Duplicate band value!");
                    }
                    ++n4;
                }
                ++n2;
            }
            this.sourceBands = (int[])nArray.clone();
        }
    }

    public int[] getSourceBands() {
        if (this.sourceBands == null) {
            return null;
        }
        return (int[])this.sourceBands.clone();
    }

    public void setDestinationType(ImageTypeSpecifier imageTypeSpecifier) {
        this.destinationType = imageTypeSpecifier;
    }

    public ImageTypeSpecifier getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationOffset(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("destinationOffset == null!");
        }
        this.destinationOffset = (Point)point.clone();
    }

    public Point getDestinationOffset() {
        return (Point)this.destinationOffset.clone();
    }

    public void setController(IIOParamController iIOParamController) {
        this.controller = iIOParamController;
    }

    public IIOParamController getController() {
        return this.controller;
    }

    public IIOParamController getDefaultController() {
        return this.defaultController;
    }

    public boolean hasController() {
        return this.controller != null;
    }

    public void activateController() {
        if (this.controller == null) {
            throw new IllegalStateException();
        }
        this.controller.activate(this);
    }
}

