/*
 * Decompiled with CFR 0.152.
 */
package iDSS.gridDisp;

import iDSS.utils.IDSSAppConstants;
import iDSS.xyGraph.GraphicalDisplay2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class DrawingPanel2
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private boolean firstTime = true;
    private BufferedImage bufferImage;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private int sizeX;
    private int sizeY;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private String mouseCoords;
    private GraphicalDisplay2 parentFrame;

    public DrawingPanel2(int n, int n2) {
        System.out.println("In Constructor of DrawingPanel2");
        this.leftMargin = 0;
        this.rightMargin = 0;
        this.topMargin = 0;
        this.bottomMargin = 0;
        this.sizeX = n;
        this.sizeY = n2;
        this.parentFrame = null;
        this.bufferImage = new BufferedImage(this.sizeX, this.sizeY, 1);
        if (this.bufferImage != null) {
            System.out.println("bufferImage created in Drawingpanel2");
            Graphics graphics = this.bufferImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(this.leftMargin, this.topMargin, this.sizeX - this.leftMargin - this.rightMargin, this.sizeY - this.topMargin - this.bottomMargin);
            graphics.setColor(Color.black);
        }
        this.setSize(new Dimension(this.sizeX, this.sizeY));
        this.setPreferredSize(new Dimension(this.sizeX, this.sizeY));
        this.setVisible(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.repaint();
        System.out.println("Creating DrawingPanel2, width, height : " + n + ", " + n2);
        System.out.println("Created size: width, height : " + this.getWidth() + ", " + this.getHeight());
    }

    public DrawingPanel2(int n, int n2, GraphicalDisplay2 graphicalDisplay2) {
        System.out.println("In Constructor");
        this.leftMargin = 0;
        this.rightMargin = 0;
        this.topMargin = 0;
        this.bottomMargin = 0;
        this.sizeX = n;
        this.sizeY = n2;
        this.parentFrame = graphicalDisplay2;
        System.out.println("Creating DrawingPanel2, width, height : " + n + ", " + n2);
        this.bufferImage = new BufferedImage(this.sizeX, this.sizeY, 1);
        if (this.bufferImage != null) {
            System.out.println("bufferImage created");
            Graphics graphics = this.bufferImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(this.leftMargin, this.topMargin, this.sizeX - this.leftMargin - this.rightMargin, this.sizeY - this.topMargin - this.bottomMargin);
            graphics.setColor(Color.black);
        }
        this.setSize(this.sizeX, this.sizeY);
        this.setVisible(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.repaint();
    }

    public int getCanvasX() {
        return this.sizeX;
    }

    public int getCanvasY() {
        return this.sizeY;
    }

    public void paint(Graphics graphics) {
        if (this.firstTime) {
            this.firstTime = false;
            System.out.println("firstTime");
            if (this.bufferImage == null) {
                this.bufferImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics graphics2 = this.bufferImage.getGraphics();
                graphics2.setColor(Color.white);
                graphics2.fillRect(this.leftMargin, this.topMargin, this.sizeX - this.leftMargin - this.rightMargin, this.sizeY - this.topMargin - this.bottomMargin);
                graphics2.setColor(Color.black);
            }
        }
        graphics.drawImage(this.bufferImage, 0, 0, this);
    }

    public void setupPanel() {
        System.out.println("In setupPanel()");
        while (this.bufferImage.getGraphics() == null) {
            this.repaint();
        }
        Graphics graphics = this.bufferImage.getGraphics();
        int n = this.getWidth();
        int n2 = this.getHeight();
    }

    public BufferedImage getCanvas() {
        System.out.println("In DrawingPanel2 getCanvas()");
        return this.bufferImage;
    }

    public void refreshCanvas(BufferedImage bufferedImage) {
        if (IDSSAppConstants.debug) {
            System.out.println("DrawingPanel2.refreshCanvas()");
            System.out.println("getSize().width  : " + this.getSize().width + "\n" + "getSize().height : " + this.getSize().height + "\n" + "bi.getWidth()    : " + bufferedImage.getWidth() + "\n" + "bi.getHeight()    : " + bufferedImage.getHeight());
        }
        Graphics graphics = this.bufferImage.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, this.getSize().width, this.getSize().height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), this);
        this.repaint();
    }

    public void clearBuffer() {
        Graphics graphics = this.bufferImage.getGraphics();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.white);
        graphics.fillRect(this.leftMargin, this.topMargin, n - this.leftMargin - this.rightMargin, n2 - this.topMargin - this.bottomMargin);
        graphics.setColor(Color.black);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.x1 = mouseEvent.getX();
        this.y1 = mouseEvent.getY();
        this.x2 = this.x1;
        this.y2 = this.y1;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.x2 = mouseEvent.getX();
        this.y2 = mouseEvent.getY();
        Graphics graphics = this.bufferImage.getGraphics();
        graphics.setColor(Color.black);
        graphics.setPaintMode();
        graphics.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.red);
        graphics.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
        this.x2 = mouseEvent.getX();
        this.y2 = mouseEvent.getY();
        graphics.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
        graphics.setPaintMode();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void drawXYGraph(double[] dArray, double[] dArray2) {
        double d;
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray2.length];
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        double d2 = this.getMax(dArray);
        double d3 = this.getMax(dArray2);
        double d4 = this.getMin(dArray);
        double d5 = this.getMin(dArray2);
        int n3 = 0;
        while (n3 < dArray.length) {
            d = (double)(n - this.rightMargin - this.leftMargin) / (d2 - d4) * (dArray[n3] - d4) + (double)this.leftMargin;
            nArray[n3] = (int)d;
            ++n3;
        }
        int n4 = 0;
        while (n4 < dArray.length) {
            d = (double)n2 - (dArray2[n4] - d5) * (double)(n2 - this.bottomMargin - this.topMargin) / (d3 - d5) - (double)this.bottomMargin;
            nArray2[n4] = (int)d;
            ++n4;
        }
        if (this.bufferImage == null) {
            System.out.println("bufferImage is null!!");
        }
        if (this.firstTime) {
            this.setupPanel();
        }
        Graphics graphics = this.bufferImage.getGraphics();
        System.out.println("Drawing polyline");
        graphics.setColor(Color.black);
        graphics.drawPolyline(nArray, nArray2, nArray.length);
        this.repaint();
    }

    private double getMax(double[] dArray) {
        double d = -9.999999999999E12;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    private double getMin(double[] dArray) {
        double d = 9.999999999999E12;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.parentFrame != null) {
            System.out.println("Drawingpanel2 resized, parent not null");
            this.sizeX = this.getWidth();
            this.sizeY = this.getHeight();
            this.bufferImage = new BufferedImage(this.sizeX, this.sizeY, 1);
            if (this.bufferImage != null) {
                System.out.println("bufferImage recreated");
                Graphics graphics = this.bufferImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(this.leftMargin, this.topMargin, this.sizeX - this.leftMargin - this.rightMargin, this.sizeY - this.topMargin - this.bottomMargin);
                graphics.setColor(Color.black);
            }
            System.out.println("drawingpanel2:componentResized, sizeX,sizeY : " + this.sizeX + " ," + this.sizeY);
            this.clearBuffer();
            this.parentFrame.resizeCanvas();
        } else {
            System.out.println("Drawingpanel2 resized, parent is null");
            this.resizeDrawingPanel();
        }
    }

    private void resizeDrawingPanel() {
        System.out.println("In resizeDrawingPanel()");
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.sizeX;
        int n4 = this.sizeY;
        System.out.println(n + ", " + n2);
        BufferedImage bufferedImage = this.bufferImage;
        this.bufferImage = null;
        this.bufferImage = new BufferedImage(Math.max(n, n3), Math.max(n2, n4), 1);
        Graphics graphics = this.bufferImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(this.leftMargin, this.topMargin, n - this.leftMargin - this.rightMargin, n2 - this.topMargin - this.bottomMargin);
        graphics.setColor(Color.black);
        graphics.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, n3, n4, Color.white, this);
        this.sizeX = n;
        this.sizeY = n2;
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private String getMouseCoords() {
        String string = new String("");
        String string2 = new String("");
        string = String.valueOf(this.x2);
        string2 = String.valueOf(this.y2);
        this.mouseCoords = string + "," + string2;
        return this.mouseCoords;
    }
}

