/*
 * Decompiled with CFR 0.152.
 */
package iDSS.grids;

import iDSS.sm.SurvivalModel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Vector;

public class GridCell
implements Serializable {
    private long totalFloodingTime = 0L;
    private long totalDryTime = 0L;
    private double highestDepthOfFlooding = 0.0;
    private long longestFloodingTime = 0L;
    private long longestDryTime = 0L;
    private long totalCriticalFloodingTime = 0L;
    private long longestCriticalFloodingTime = 0L;
    private long currentFloodingTime = 0L;
    private long currentDryTime = 0L;
    private long currentCriticalFloodingTime = 0L;
    private double probabilityOfSurvival = 1.0;
    private double minimumProbabilityOfSurvival = 1.0;
    private boolean flooded = false;
    private boolean criticallyFlooded = false;
    private boolean criticalFloodingEnds = false;
    private boolean dry = false;

    public static Vector getParametersVector() {
        Vector<String> vector = new Vector<String>();
        vector.add("totalFloodingTime");
        vector.add("totalDryTime");
        vector.add("highestDepthOfFlooding");
        vector.add("longestFloodingTime");
        vector.add("longestDryTime");
        vector.add("totalCriticalFloodingTime");
        vector.add("longestCriticalFloodingTime");
        vector.add("minimumProbabilityOfSurvival");
        return vector;
    }

    public String getValue(String string) {
        String string2 = null;
        double d = 0.0;
        if (string.equals("totalFloodingTime")) {
            d = this.totalFloodingTime;
        } else if (string.equals("totalDryTime")) {
            d = this.totalDryTime;
        } else if (string.equals("highestDepthOfFlooding")) {
            d = this.highestDepthOfFlooding;
        } else if (string.equals("longestFloodingTime")) {
            d = this.longestFloodingTime;
        } else if (string.equals("longestDryTime")) {
            d = this.longestDryTime;
        } else if (string.equals("totalCriticalFloodingTime")) {
            d = this.totalCriticalFloodingTime;
        } else if (string.equals("longestCriticalFloodingTime")) {
            d = this.longestCriticalFloodingTime;
        } else if (string.equals("minimumProbabilityOfSurvival")) {
            d = this.minimumProbabilityOfSurvival;
        }
        string2 = String.valueOf(d);
        return string2;
    }

    public void addToTotalFloodingTime(long l) {
        this.totalFloodingTime += l;
    }

    public long getTotalFloodingTime() {
        return this.totalFloodingTime;
    }

    public void addToCurrentFloodingTime(long l) {
        if (this.dry) {
            this.longestDryTime = Math.max(this.currentDryTime, this.longestDryTime);
            this.currentDryTime = 0L;
            this.dry = false;
        } else if (this.criticallyFlooded) {
            this.longestCriticalFloodingTime = Math.max(this.currentCriticalFloodingTime, this.longestCriticalFloodingTime);
            this.criticallyFlooded = false;
            this.criticalFloodingEnds = true;
        }
        this.flooded = true;
        this.currentFloodingTime += l;
    }

    public void addToTotalDryTime(long l) {
        this.totalDryTime += l;
    }

    public long getTotalDryTime() {
        return this.totalDryTime;
    }

    public void addToCurrentDryTime(long l) {
        if (this.criticallyFlooded) {
            this.longestCriticalFloodingTime = Math.max(this.currentCriticalFloodingTime, this.longestCriticalFloodingTime);
            this.criticallyFlooded = false;
            this.criticalFloodingEnds = true;
            this.longestFloodingTime = Math.max(this.currentFloodingTime, this.longestFloodingTime);
            this.currentFloodingTime = 0L;
            this.flooded = false;
        } else if (this.flooded) {
            this.longestFloodingTime = Math.max(this.currentFloodingTime, this.longestFloodingTime);
            this.currentFloodingTime = 0L;
            this.flooded = false;
        }
        this.dry = true;
        this.currentDryTime += l;
    }

    public long getLongestDryTime() {
        return this.longestDryTime;
    }

    public void setHighestDepthOfFlooding(double d) {
        if (this.highestDepthOfFlooding < d) {
            this.highestDepthOfFlooding = d;
        }
    }

    public double getHighestDepthOfFlooding() {
        return this.highestDepthOfFlooding;
    }

    public long getLongestFloodingTime() {
        return this.longestFloodingTime;
    }

    public void addToTotalCriticalFloodingTime(long l) {
        this.totalCriticalFloodingTime += l;
        this.totalFloodingTime += l;
    }

    public void addToCurrentCriticalFloodingTime(long l) {
        if (this.dry) {
            this.longestDryTime = Math.max(this.currentDryTime, this.longestDryTime);
            this.currentDryTime = 0L;
            this.dry = false;
        }
        this.criticallyFlooded = true;
        this.currentCriticalFloodingTime += l;
        this.flooded = true;
        this.currentFloodingTime += l;
    }

    public long getTotalCriticalFloodingTime() {
        return this.totalCriticalFloodingTime;
    }

    public long getLongestCriticalFloodingTime() {
        return this.longestCriticalFloodingTime;
    }

    public void buildUP(double d, long l, Timestamp timestamp, SurvivalModel survivalModel) {
        double d2 = survivalModel.getCriticalFloodingDepth(timestamp);
        if (d > d2) {
            this.addToTotalCriticalFloodingTime(l);
            this.addToCurrentCriticalFloodingTime(l);
            this.setHighestDepthOfFlooding(d);
        } else if (d > 0.0) {
            this.addToTotalFloodingTime(l);
            this.addToCurrentFloodingTime(l);
            this.setHighestDepthOfFlooding(d);
        } else {
            this.addToTotalDryTime(l);
            this.addToCurrentDryTime(l);
        }
        if (this.criticalFloodingEnds) {
            this.criticalFloodingEnds = false;
            this.probabilityOfSurvival = survivalModel.getProbability(this.currentCriticalFloodingTime, d2, timestamp);
            this.minimumProbabilityOfSurvival = Math.min(this.minimumProbabilityOfSurvival, this.probabilityOfSurvival);
            this.currentCriticalFloodingTime = 0L;
        }
    }

    public void roundUp(SurvivalModel survivalModel, long l, double d, Timestamp timestamp) {
        if (this.criticallyFlooded) {
            this.longestCriticalFloodingTime = Math.max(this.currentCriticalFloodingTime, this.longestCriticalFloodingTime);
            this.longestFloodingTime = Math.max(this.currentFloodingTime, this.longestFloodingTime);
            this.probabilityOfSurvival = survivalModel.getProbability(this.currentCriticalFloodingTime, survivalModel.getCriticalFloodingDepth(timestamp), timestamp);
            this.minimumProbabilityOfSurvival = Math.min(this.probabilityOfSurvival, this.minimumProbabilityOfSurvival);
            this.criticalFloodingEnds = false;
            this.currentCriticalFloodingTime = 0L;
            this.currentFloodingTime = 0L;
        } else if (this.flooded) {
            this.longestFloodingTime = Math.max(this.currentFloodingTime, this.longestFloodingTime);
            this.currentFloodingTime = 0L;
        } else if (this.dry) {
            this.longestDryTime = Math.max(this.currentDryTime, this.longestDryTime);
            this.currentDryTime = 0L;
        }
    }

    public String getStatus() {
        String string = "";
        if (this.criticallyFlooded) {
            string = "criticallyFlooded";
        } else if (this.flooded) {
            string = "flooded";
        } else if (this.dry) {
            string = "dry";
        }
        return string;
    }
}

